#ifndef H5TOH4APICOMPITABLE_H
#define H5TOH4APICOMPITABLE_H

#if (H5_VERS_MAJOR == 1 && H5_VERS_MINOR == 6) || defined H5_USE_16_API

  	#define H5GOPEN(fd, name) H5Gopen(fd, name)
    #define H5DOPEN(fd, name) H5Dopen(fd, name)
    #define H5TARRAY_CREATE(tid, rank, dims, perm) H5Tarray_create(tid, rank, dims, perm)
    #define H5EGET_AUTO(func, data) H5Eget_auto(func, data)
    #define H5ESET_AUTO(func, data) H5Eset_auto(func, data)
    #define H5AITERATE(loc_id, idx, op, op_data) H5Aiterate(loc_id, (unsigned *)idx, (H5A_operator_t)op, op_data)
    #define H5TGET_ARRAY_DIMS(tid, dims, perm) H5Tget_array_dims(tid, dims, perm)
    #define H5RDEREFERENCE(obj_id,ref_type,ref) H5Rdereference(obj_id,ref_type,ref)

#else


    #define H5GOPEN(fd, name) H5Gopen2(fd, name, H5P_DEFAULT)
    #define H5DOPEN(fd, name) H5Dopen2(fd, name, H5P_DEFAULT)
    #define H5TARRAY_CREATE(tid, rank, dims, perm) H5Tarray_create2(tid, rank, dims)
    #define H5EGET_AUTO(func, data) H5Eget_auto2(H5E_DEFAULT, func, data)
    #define H5ESET_AUTO(func, data) H5Eset_auto2(H5E_DEFAULT, func, data)
    #define H5AITERATE(loc_id, idx, op, op_data) H5Aiterate1(loc_id,  (unsigned *)idx, (H5A_operator1_t)op, op_data)
    #define H5TGET_ARRAY_DIMS(tid, dims, perm) H5Tget_array_dims2(tid, dims)

    #if (H5_VERS_MAJOR == 1 && H5_VERS_MINOR == 8)
        #define H5RDEREFERENCE(obj_id,ref_type,ref) H5Rdereference(obj_id,ref_type,ref)
    #else 
        #if (defined H5_USE_18_API)
            #define H5RDEREFERENCE(obj_id,ref_type,ref) H5Rdereference1(obj_id,ref_type,ref)
        
        /* Note: in 1.10, H5Rdereference2 is used by default,
           a new parameter opal_id (object access property list) is now added. We may not
           have time to tackle this in this release. So still use H5Rdereference2.
           https://support.hdfgroup.org/HDF5/doc/RM/RM_H5R.html#Reference-Dereference
        */
        #else                                        
            #define H5RDEREFERENCE(obj_id,ref_type,ref) H5Rdereference1(obj_id,ref_type,ref)
        #endif
    #endif


#endif

#endif

