#-------------------------------------------------------------------------------
MACRO (EXTERNAL_HDF4_LIBRARY compress_type libtype)
  SET (HDF45_BUILD_XDR_LIB OFF)
  IF (WIN32 AND NOT CYGWIN)
    SET (HDF45_BUILD_XDR_LIB ON)
  ENDIF (WIN32 AND NOT CYGWIN)
  IF (${compress_type} MATCHES "SVN")
    EXTERNALPROJECT_ADD (HDF4
        SVN_REPOSITORY ${HDF4_URL}
        # [SVN_REVISION rev] 
        INSTALL_COMMAND ""
        CMAKE_ARGS
            -DHDF_LEGACY_NAMING:BOOL=OFF
            -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
            -DHDF_PACKAGE_EXT:STRING=${HDF_PACKAGE_EXT}
            -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
            -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_INSTALL_PREFIX}
            -DCMAKE_RUNTIME_OUTPUT_DIRECTORY:PATH=${CMAKE_RUNTIME_OUTPUT_DIRECTORY}
            -DCMAKE_LIBRARY_OUTPUT_DIRECTORY:PATH=${CMAKE_LIBRARY_OUTPUT_DIRECTORY}
            -DCMAKE_ARCHIVE_OUTPUT_DIRECTORY:PATH=${CMAKE_ARCHIVE_OUTPUT_DIRECTORY}
            -DCMAKE_ANSI_CFLAGS:STRING=${CMAKE_ANSI_CFLAGS}
            -DHDF4_BUILD_TOOLS:BOOL=ON
            -DHDF4_BUILD_FORTRAN:BOOL=OFF
            -DHDF4_BUILD_XDR_LIB:BOOL=${HDF45_BUILD_XDR_LIB}
            -DHDF4_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DHDF4_PACKAGE_EXTLIBS:BOOL=${HDF_PACKAGE_EXTLIBS}
            -DHDF4_ALLOW_EXTERNAL_SUPPORT:STRING="SVN"
            -DJPEG_SVN_URL:STRING=${JPEG_SVN_URL}
            -DZLIB_SVN_URL:STRING=${ZLIB_SVN_URL}
            -DSZIP_SVN_URL:STRING=${SZIP_SVN_URL}
            -DHDF4_ENABLE_JPEG_LIB_SUPPORT:BOOL=${HDF_ENABLE_JPEG_LIB_SUPPORT}
            -DHDF4_ENABLE_Z_LIB_SUPPORT:BOOL=${HDF_ENABLE_Z_LIB_SUPPORT}
            -DHDF4_ENABLE_SZIP_SUPPORT:BOOL=${HDF_ENABLE_SZIP_SUPPORT}
            -DHDF4_ENABLE_SZIP_ENCODING:BOOL=${HDF_ENABLE_SZIP_ENCODING}
    ) 
  ENDIF (${compress_type} MATCHES "SVN")
  IF (${compress_type} MATCHES "TGZ")
    EXTERNALPROJECT_ADD (HDF4
        URL ${HDF4_URL}
        URL_MD5 ""
        INSTALL_COMMAND ""
        CMAKE_ARGS
            -DHDF_LEGACY_NAMING:BOOL=OFF
            -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
            -DHDF_PACKAGE_EXT:STRING=${HDF_PACKAGE_EXT}
            -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
            -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_INSTALL_PREFIX}
            -DCMAKE_RUNTIME_OUTPUT_DIRECTORY:PATH=${CMAKE_RUNTIME_OUTPUT_DIRECTORY}
            -DCMAKE_LIBRARY_OUTPUT_DIRECTORY:PATH=${CMAKE_LIBRARY_OUTPUT_DIRECTORY}
            -DCMAKE_ARCHIVE_OUTPUT_DIRECTORY:PATH=${CMAKE_ARCHIVE_OUTPUT_DIRECTORY}
            -DCMAKE_ANSI_CFLAGS:STRING=${CMAKE_ANSI_CFLAGS}
            -DHDF4_BUILD_TOOLS:BOOL=ON
            -DHDF4_BUILD_FORTRAN:BOOL=OFF
            -DHDF4_BUILD_XDR_LIB:BOOL=${HDF45_BUILD_XDR_LIB}
            -DHDF4_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DHDF4_PACKAGE_EXTLIBS:BOOL=${HDF_PACKAGE_EXTLIBS}
            -DHDF4_ALLOW_EXTERNAL_SUPPORT:STRING="TGZ"
            -DTGZ_PATH:STRING=${TGZ_PATH}
            -DJPEG_TGZ_NAME:STRING=${JPEG_TGZ_NAME}
            -DZLIB_TGZ_NAME:STRING=${ZLIB_TGZ_NAME}
            -DSZIP_TGZ_NAME:STRING=${SZIP_TGZ_NAME}
            -DHDF4_ENABLE_JPEG_LIB_SUPPORT:BOOL=${HDF_ENABLE_JPEG_LIB_SUPPORT}
            -DHDF4_ENABLE_Z_LIB_SUPPORT:BOOL=${HDF_ENABLE_Z_LIB_SUPPORT}
            -DHDF4_ENABLE_SZIP_SUPPORT:BOOL=${HDF_ENABLE_SZIP_SUPPORT}
            -DHDF4_ENABLE_SZIP_ENCODING:BOOL=${HDF_ENABLE_SZIP_ENCODING}
    ) 
  ENDIF (${compress_type} MATCHES "TGZ")
  EXTERNALPROJECT_GET_PROPERTY (HDF4 BINARY_DIR SOURCE_DIR) 

  IF (${CMAKE_BUILD_TYPE} MATCHES "DEBUG")
    IF (WIN32)
      SET (HDF_LIB_NAME "hdf_D")
      SET (MFHDF_LIB_NAME "hdf_D")
      SET (XDR_LIB_NAME "xdr_D")
      IF (HDF_ENABLE_JPEG_LIB_SUPPORT)
        SET (JPEG_LIB_NAME "jpeg_D")
      ENDIF (HDF_ENABLE_JPEG_LIB_SUPPORT)
      IF (HDF_ENABLE_Z_LIB_SUPPORT)
        SET (ZLIB_LIB_NAME "zlib_D")
      ENDIF (HDF_ENABLE_Z_LIB_SUPPORT)
      IF (HDF_ENABLE_SZIP_SUPPORT)
        SET (SZIP_LIB_NAME "szip_D")
      ENDIF (HDF_ENABLE_SZIP_SUPPORT)
    ELSE (WIN32)
      SET (HDF_LIB_NAME "hdf_debug")
      SET (MFHDF_LIB_NAME "mfhdf_debug")
      SET (XDR_LIB_NAME "xdr_debug")
      IF (HDF_ENABLE_JPEG_LIB_SUPPORT)
        SET (JPEG_LIB_NAME "jpeg_debug")
      ENDIF (HDF_ENABLE_JPEG_LIB_SUPPORT)
      IF (HDF_ENABLE_Z_LIB_SUPPORT)
        SET (ZLIB_LIB_NAME "z_debug")
      ENDIF (HDF_ENABLE_Z_LIB_SUPPORT)
      IF (HDF_ENABLE_SZIP_SUPPORT)
        SET (SZIP_LIB_NAME "szip_debug")
      ENDIF (HDF_ENABLE_SZIP_SUPPORT)
    ENDIF (WIN32)
  ELSE (${CMAKE_BUILD_TYPE} MATCHES "DEBUG")
    SET (HDF_LIB_NAME "hdf")
    SET (MFHDF_LIB_NAME "mfhdf")
    SET (XDR_LIB_NAME "xdr")
    IF (HDF_ENABLE_JPEG_LIB_SUPPORT)
      SET (JPEG_LIB_NAME "jpeg")
    ENDIF (HDF_ENABLE_JPEG_LIB_SUPPORT)
    IF (HDF_ENABLE_Z_LIB_SUPPORT)
      IF (WIN32)
        SET (ZLIB_LIB_NAME "zlib")
      ELSE (WIN32)
        SET (ZLIB_LIB_NAME "z")
      ENDIF (WIN32)
    ENDIF (HDF_ENABLE_Z_LIB_SUPPORT)
    IF (HDF_ENABLE_SZIP_SUPPORT)
      SET (SZIP_LIB_NAME "szip")
    ENDIF (HDF_ENABLE_SZIP_SUPPORT)
  ENDIF (${CMAKE_BUILD_TYPE} MATCHES "DEBUG")

  # Create imported target hdf4
  ADD_LIBRARY(hdf ${libtype} IMPORTED)
  ADD_DEPENDENCIES (hdf HDF4)
  ADD_LIBRARY(mfhdf ${libtype} IMPORTED)
  ADD_DEPENDENCIES (mfhdf HDF4)
  SET (MFHDF_IMPORTED_LINK_INTERFACE_LIBRARIES "hdf")
  IF (HDF45_BUILD_XDR_LIB)
    ADD_LIBRARY(xdr ${libtype} IMPORTED)
    ADD_DEPENDENCIES (xdr HDF4)
    SET (MFHDF_IMPORTED_LINK_INTERFACE_LIBRARIES "xdr;${MFHDF_IMPORTED_LINK_INTERFACE_LIBRARIES}")
  ENDIF (HDF45_BUILD_XDR_LIB)
  IF (HDF_ENABLE_JPEG_LIB_SUPPORT)
    ADD_LIBRARY(jpeg ${libtype} IMPORTED)
    ADD_DEPENDENCIES (jpeg HDF4)
  ENDIF (HDF_ENABLE_JPEG_LIB_SUPPORT)
  IF (HDF_ENABLE_Z_LIB_SUPPORT)
    ADD_LIBRARY(zlib ${libtype} IMPORTED)
    ADD_DEPENDENCIES (zlib HDF4)
  ENDIF (HDF_ENABLE_Z_LIB_SUPPORT)
  IF (HDF_ENABLE_SZIP_SUPPORT)
    ADD_LIBRARY(szip ${libtype} IMPORTED)
    ADD_DEPENDENCIES (szip HDF4)
  ENDIF (HDF_ENABLE_SZIP_SUPPORT)

  IF (${libtype} MATCHES "SHARED")
    IF (WIN32)
      IF (MINGW)
        SET_TARGET_PROPERTIES(hdf PROPERTIES
            IMPORTED_IMPLIB "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${HDF_LIB_NAME}.lib"
            IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${HDF_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
            IMPORTED_LINK_INTERFACE_LIBRARIES "jpeg;zlib;szip"
          )
        SET_TARGET_PROPERTIES(mfhdf PROPERTIES
            IMPORTED_IMPLIB "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${MFHDF_LIB_NAME}.lib"
            IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${MFHDF_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
            IMPORTED_LINK_INTERFACE_LIBRARIES "${MFHDF_IMPORTED_LINK_INTERFACE_LIBRARIES}"
          )
        IF (HDF45_BUILD_XDR_LIB)
          SET_TARGET_PROPERTIES(xdr PROPERTIES
              IMPORTED_IMPLIB "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${XDR_LIB_NAME}.lib"
              IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${XDR_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
          )
        ENDIF (HDF45_BUILD_XDR_LIB)
        IF (HDF_ENABLE_JPEG_LIB_SUPPORT)
          SET_TARGET_PROPERTIES(jpeg PROPERTIES
              IMPORTED_IMPLIB "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${JPEG_LIB_NAME}.lib"
              IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${JPEG_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
          )
        ENDIF (HDF_ENABLE_JPEG_LIB_SUPPORT)
        IF (HDF_ENABLE_Z_LIB_SUPPORT)
         SET_TARGET_PROPERTIES(zlib PROPERTIES
              IMPORTED_IMPLIB "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${ZLIB_LIB_NAME}.lib"
              IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${ZLIB_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
          )
        ENDIF (HDF_ENABLE_Z_LIB_SUPPORT)
        IF (HDF_ENABLE_SZIP_SUPPORT)
          SET_TARGET_PROPERTIES(szip PROPERTIES
              IMPORTED_IMPLIB "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${SZIP_LIB_NAME}.lib"
              IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${SZIP_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
          )
        ENDIF (HDF_ENABLE_SZIP_SUPPORT)
      ELSE (MINGW)
        SET_TARGET_PROPERTIES(hdf PROPERTIES
            IMPORTED_IMPLIB "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/${CMAKE_IMPORT_LIBRARY_PREFIX}${HDF_LIB_NAME}${CMAKE_IMPORT_LIBRARY_SUFFIX}"
            IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/${CMAKE_IMPORT_LIBRARY_PREFIX}${HDF_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
            IMPORTED_LINK_INTERFACE_LIBRARIES "jpeg;zlib;szip"
          )
        SET_TARGET_PROPERTIES(mfhdf PROPERTIES
            IMPORTED_IMPLIB "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/${CMAKE_IMPORT_LIBRARY_PREFIX}${MFHDF_LIB_NAME}${CMAKE_IMPORT_LIBRARY_SUFFIX}"
            IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/${CMAKE_IMPORT_LIBRARY_PREFIX}${MFHDF_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
            IMPORTED_LINK_INTERFACE_LIBRARIES "${MFHDF_IMPORTED_LINK_INTERFACE_LIBRARIES}"
          )
        IF (HDF45_BUILD_XDR_LIB)
          SET_TARGET_PROPERTIES(xdr PROPERTIES
              IMPORTED_IMPLIB "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/${CMAKE_IMPORT_LIBRARY_PREFIX}${XDR_LIB_NAME}${CMAKE_IMPORT_LIBRARY_SUFFIX}"
              IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/${CMAKE_IMPORT_LIBRARY_PREFIX}${XDR_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
          )
        ENDIF (HDF45_BUILD_XDR_LIB)
        IF (HDF_ENABLE_JPEG_LIB_SUPPORT)
          SET_TARGET_PROPERTIES(jpeg PROPERTIES
              IMPORTED_IMPLIB "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/${CMAKE_IMPORT_LIBRARY_PREFIX}${JPEG_LIB_NAME}${CMAKE_IMPORT_LIBRARY_SUFFIX}"
              IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/${CMAKE_IMPORT_LIBRARY_PREFIX}${JPEG_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
          )
        ENDIF (HDF_ENABLE_JPEG_LIB_SUPPORT)
        IF (HDF_ENABLE_Z_LIB_SUPPORT)
         SET_TARGET_PROPERTIES(zlib PROPERTIES
              IMPORTED_IMPLIB "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/${CMAKE_IMPORT_LIBRARY_PREFIX}${ZLIB_LIB_NAME}${CMAKE_IMPORT_LIBRARY_SUFFIX}"
              IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/${CMAKE_IMPORT_LIBRARY_PREFIX}${ZLIB_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
          )
        ENDIF (HDF_ENABLE_Z_LIB_SUPPORT)
        IF (HDF_ENABLE_SZIP_SUPPORT)
          SET_TARGET_PROPERTIES(szip PROPERTIES
              IMPORTED_IMPLIB "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/${CMAKE_IMPORT_LIBRARY_PREFIX}${SZIP_LIB_NAME}${CMAKE_IMPORT_LIBRARY_SUFFIX}"
              IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/${CMAKE_IMPORT_LIBRARY_PREFIX}${SZIP_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
          )
        ENDIF (HDF_ENABLE_SZIP_SUPPORT)
      ENDIF (MINGW)
    ELSE (WIN32)
      SET_TARGET_PROPERTIES(hdf PROPERTIES
          IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_SHARED_LIBRARY_PREFIX}${HDF_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
          IMPORTED_LINK_INTERFACE_LIBRARIES "jpeg;zlib;szip"
          IMPORTED_SONAME "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_SHARED_LIBRARY_PREFIX}${HDF_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}.${HDF4_VERSION_STRING}"
          SOVERSION "${HDF4_VERSION_STRING}"
      )
      SET_TARGET_PROPERTIES(mfhdf PROPERTIES
          IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_SHARED_LIBRARY_PREFIX}${MFHDF_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
          IMPORTED_LINK_INTERFACE_LIBRARIES "${MFHDF_IMPORTED_LINK_INTERFACE_LIBRARIES}"
          IMPORTED_SONAME "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_SHARED_LIBRARY_PREFIX}${MFHDF_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}.${HDF4_VERSION_STRING}"
          SOVERSION "${HDF4_VERSION_STRING}"
      )
      IF (HDF45_BUILD_XDR_LIB)
        SET_TARGET_PROPERTIES(xdr PROPERTIES
            IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_SHARED_LIBRARY_PREFIX}${XDR_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
            IMPORTED_SONAME "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_SHARED_LIBRARY_PREFIX}${XDR_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}.${HDF4_VERSION_STRING}"
            SOVERSION "${HDF4_VERSION_STRING}"
        )
      ENDIF (HDF45_BUILD_XDR_LIB)
      IF (HDF_ENABLE_JPEG_LIB_SUPPORT)
        SET_TARGET_PROPERTIES(jpeg PROPERTIES
            IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_SHARED_LIBRARY_PREFIX}${JPEG_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
            IMPORTED_SONAME "${CMAKE_SHARED_LIBRARY_PREFIX}${JPEG_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}.${JPEG_VERSION_STRING}"
            SOVERSION "${JPEG_VERSION_STRING}"
        )
      ENDIF (HDF_ENABLE_JPEG_LIB_SUPPORT)
      IF (HDF_ENABLE_Z_LIB_SUPPORT)
        SET_TARGET_PROPERTIES(zlib PROPERTIES
            IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_SHARED_LIBRARY_PREFIX}${ZLIB_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
            IMPORTED_SONAME "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_SHARED_LIBRARY_PREFIX}${ZLIB_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}.${ZLIB_VERSION_STRING}"
            SOVERSION "${ZLIB_VERSION_STRING}"
        )
      ENDIF (HDF_ENABLE_Z_LIB_SUPPORT)
      IF (HDF_ENABLE_SZIP_SUPPORT)
        SET_TARGET_PROPERTIES(szip PROPERTIES
           IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_SHARED_LIBRARY_PREFIX}${SZIP_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
            IMPORTED_SONAME "${CMAKE_SHARED_LIBRARY_PREFIX}${SZIP_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}.${SZIP_VERSION_STRING}"
            SOVERSION "${SZIP_VERSION_STRING}"
        )
      ENDIF (HDF_ENABLE_SZIP_SUPPORT)
    ENDIF (WIN32)
  ELSE (${libtype} MATCHES "SHARED")
    IF (WIN32 AND NOT MINGW)
      SET_TARGET_PROPERTIES(hdf PROPERTIES
          IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/lib${HDF_LIB_NAME}${CMAKE_STATIC_LIBRARY_SUFFIX}"
          IMPORTED_LINK_INTERFACE_LIBRARIES "jpeg;zlib;szip"
          IMPORTED_LINK_INTERFACE_LANGUAGES "C"
      )
      SET_TARGET_PROPERTIES(mfhdf PROPERTIES
          IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/lib${MFHDF_LIB_NAME}${CMAKE_STATIC_LIBRARY_SUFFIX}"
          IMPORTED_LINK_INTERFACE_LIBRARIES "${MFHDF_IMPORTED_LINK_INTERFACE_LIBRARIES}"
          IMPORTED_LINK_INTERFACE_LANGUAGES "C"
      )
      IF (HDF45_BUILD_XDR_LIB)
        SET_TARGET_PROPERTIES(xdr PROPERTIES
            IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/lib${XDR_LIB_NAME}${CMAKE_STATIC_LIBRARY_SUFFIX}"
            IMPORTED_LINK_INTERFACE_LANGUAGES "C"
      )
      ENDIF (HDF45_BUILD_XDR_LIB)
      IF (HDF_ENABLE_JPEG_LIB_SUPPORT)
        SET_TARGET_PROPERTIES(jpeg PROPERTIES
            IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/lib${JPEG_LIB_NAME}${CMAKE_STATIC_LIBRARY_SUFFIX}"
            IMPORTED_LINK_INTERFACE_LANGUAGES "C"
        )
      ENDIF (HDF_ENABLE_JPEG_LIB_SUPPORT)
      IF (HDF_ENABLE_Z_LIB_SUPPORT)
        SET_TARGET_PROPERTIES(zlib PROPERTIES
            IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/lib${ZLIB_LIB_NAME}${CMAKE_STATIC_LIBRARY_SUFFIX}"
            IMPORTED_LINK_INTERFACE_LANGUAGES "C"
        )
      ENDIF (HDF_ENABLE_Z_LIB_SUPPORT)
      IF (HDF_ENABLE_SZIP_SUPPORT)
        SET_TARGET_PROPERTIES(szip PROPERTIES
            IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/lib${SZIP_LIB_NAME}${CMAKE_STATIC_LIBRARY_SUFFIX}"
            IMPORTED_LINK_INTERFACE_LANGUAGES "C"
        )
      ENDIF (HDF_ENABLE_SZIP_SUPPORT)
    ELSE (WIN32 AND NOT MINGW)
      SET_TARGET_PROPERTIES(hdf PROPERTIES
          IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/lib${HDF_LIB_NAME}${CMAKE_STATIC_LIBRARY_SUFFIX}"
          IMPORTED_LINK_INTERFACE_LIBRARIES "jpeg;zlib;szip"
          IMPORTED_LINK_INTERFACE_LANGUAGES "C"
      )
      SET_TARGET_PROPERTIES(mfhdf PROPERTIES
          IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/lib${MFHDF_LIB_NAME}${CMAKE_STATIC_LIBRARY_SUFFIX}"
          IMPORTED_LINK_INTERFACE_LIBRARIES "${MFHDF_IMPORTED_LINK_INTERFACE_LIBRARIES}"
          IMPORTED_LINK_INTERFACE_LANGUAGES "C"
      )
      IF (HDF45_BUILD_XDR_LIB)
        SET_TARGET_PROPERTIES(xdr PROPERTIES
            IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/lib${XDR_LIB_NAME}${CMAKE_STATIC_LIBRARY_SUFFIX}"
            IMPORTED_LINK_INTERFACE_LANGUAGES "C"
      )
      ENDIF (HDF45_BUILD_XDR_LIB)
      IF (HDF_ENABLE_JPEG_LIB_SUPPORT)
        SET_TARGET_PROPERTIES(jpeg PROPERTIES
            IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/lib${JPEG_LIB_NAME}${CMAKE_STATIC_LIBRARY_SUFFIX}"
            IMPORTED_LINK_INTERFACE_LANGUAGES "C"
        )
      ENDIF (HDF_ENABLE_JPEG_LIB_SUPPORT)
      IF (HDF_ENABLE_Z_LIB_SUPPORT)
        SET_TARGET_PROPERTIES(zlib PROPERTIES
            IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/lib${ZLIB_LIB_NAME}${CMAKE_STATIC_LIBRARY_SUFFIX}"
            IMPORTED_LINK_INTERFACE_LANGUAGES "C"
        )
      ENDIF (HDF_ENABLE_Z_LIB_SUPPORT)
      IF (HDF_ENABLE_SZIP_SUPPORT)
        SET_TARGET_PROPERTIES(szip PROPERTIES
            IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/lib${SZIP_LIB_NAME}${CMAKE_STATIC_LIBRARY_SUFFIX}"
            IMPORTED_LINK_INTERFACE_LANGUAGES "C"
        )
      ENDIF (HDF_ENABLE_SZIP_SUPPORT)
    ENDIF (WIN32 AND NOT MINGW)
  ENDIF (${libtype} MATCHES "SHARED")
  SET (HDF4_LIBRARY "hdf;mfhdf")
  IF (HDF45_BUILD_XDR_LIB)
    SET (HDF4_LIBRARY "${HDF4_LIBRARY};xdr")
  ENDIF (HDF45_BUILD_XDR_LIB)
  IF (HDF_ENABLE_JPEG_LIB_SUPPORT)
    SET (HDF4_LIBRARY "${HDF4_LIBRARY};jpeg")
    SET (JPEG_LIBRARY "jpeg")
    SET (JPEG_INCLUDE_DIR "${BINARY_DIR}/JPEG-prefix/src/JPEG/src")
    SET (JPEG_INCLUDE_DIR_GEN "${BINARY_DIR}/JPEG-prefix/src/JPEG-build")
    SET (H425_HAVE_JPEGLIB_H 1)
    SET (H425_HAVE_LIBJPEG 1)
    SET (H425_JPEGLIB_HEADER "jpeglib.h")
    SET (JPEG_LIBRARIES ${JPEG_LIBRARY})
    SET (JPEG_INCLUDE_DIRS ${JPEG_INCLUDE_DIR_GEN} ${JPEG_INCLUDE_DIR})
  ENDIF (HDF_ENABLE_JPEG_LIB_SUPPORT)
  IF (HDF_ENABLE_Z_LIB_SUPPORT)
    SET (HDF4_LIBRARY "${HDF4_LIBRARY};zlib")
    SET (ZLIB_LIBRARY "zlib")
    SET (ZLIB_INCLUDE_DIR "${BINARY_DIR}/ZLIB-prefix/src/ZLIB/src")
    SET (ZLIB_INCLUDE_DIR_GEN "${BINARY_DIR}/ZLIB-prefix/src/ZLIB-build")
    SET (H425_HAVE_FILTER_DEFLATE 1)
    SET (H425_HAVE_ZLIB_H 1)
    SET (H425_HAVE_LIBZ 1)
    SET (H425_ZLIB_HEADER "zlib.h")
    SET (ZLIB_LIBRARIES ${ZLIB_LIBRARY})
    SET (ZLIB_INCLUDE_DIRS ${ZLIB_INCLUDE_DIR_GEN} ${ZLIB_INCLUDE_DIR})
   ENDIF (HDF_ENABLE_Z_LIB_SUPPORT)
  IF (HDF_ENABLE_SZIP_SUPPORT)
    SET (HDF4_LIBRARY "${HDF4_LIBRARY};szip")
    SET (SZIP_LIBRARY "szip")
    SET (SZIP_INCLUDE_DIR "${BINARY_DIR}/SZIP-prefix/src/SZIP/src")
    SET (SZIP_INCLUDE_DIR_GEN "${BINARY_DIR}/SZIP-prefix/src/SZIP-build")
    SET (H425_HAVE_FILTER_SZIP 1)
    SET (H425_HAVE_SZLIB_H 1)
    SET (H425_HAVE_LIBSZ 1)
    SET (SZIP_LIBRARIES ${SZIP_LIBRARY})
    SET (SZIP_INCLUDE_DIRS ${SZIP_INCLUDE_DIR_GEN} ${SZIP_INCLUDE_DIR})
  ENDIF (HDF_ENABLE_SZIP_SUPPORT)
  
  SET (HDF4_INCLUDE_DIR_GEN "${BINARY_DIR}")
  SET (HDF4_HDF_INCLUDE_DIR "${SOURCE_DIR}/hdf/src")
  SET (HDF4_MFHDF_INCLUDE_DIR "${SOURCE_DIR}/mfhdf/libsrc")
  SET (HDF4_INCLUDE_DIR ${HDF4_HDF_INCLUDE_DIR} ${HDF4_MFHDF_INCLUDE_DIR})
  SET (HDF4_FOUND 1)
  SET (HDF4_LIBRARIES ${HDF4_LIBRARY})
  SET (HDF4_INCLUDE_DIRS ${HDF4_INCLUDE_DIR_GEN} ${HDF4_INCLUDE_DIR})
  ADD_EXECUTABLE (hdiff IMPORTED)
  IF (${libtype} MATCHES "SHARED" AND WIN32)
    SET_PROPERTY (TARGET hdiff PROPERTY IMPORTED_LOCATION "${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/hdiffdll")
  ELSE (${libtype} MATCHES "SHARED" AND WIN32)
    SET_PROPERTY (TARGET hdiff PROPERTY IMPORTED_LOCATION "${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/hdiff")
  ENDIF (${libtype} MATCHES "SHARED" AND WIN32)
  SET (HDF4_DIFF_EXECUTABLE $<TARGET_FILE:hdiff>)
ENDMACRO (EXTERNAL_HDF4_LIBRARY)

#-------------------------------------------------------------------------------
MACRO (PACKAGE_HDF4_LIBRARY compress_type)
  ADD_CUSTOM_TARGET (HDF4-GenHeader-Copy ALL
      COMMAND ${CMAKE_COMMAND} -E copy_if_different ${HDF4_INCLUDE_DIR_GEN}/h4config.h ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/
      COMMENT "Copying ${HDF4_INCLUDE_DIR_GEN}/h4config.h to ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/"
  )
  IF (${compress_type} MATCHES "SVN" OR ${compress_type} MATCHES "TGZ")
    ADD_DEPENDENCIES (HDF4-GenHeader-Copy HDF4)
  ENDIF (${compress_type} MATCHES "SVN" OR ${compress_type} MATCHES "TGZ")
ENDMACRO (PACKAGE_HDF4_LIBRARY)

#-------------------------------------------------------------------------------
MACRO (EXTERNAL_HDF5_LIBRARY compress_type libtype)
  IF (${compress_type} MATCHES "SVN")
    EXTERNALPROJECT_ADD (HDF5
        SVN_REPOSITORY ${HDF5_URL}
        # [SVN_REVISION rev] 
        INSTALL_COMMAND ""
        CMAKE_ARGS
            -DHDF_LEGACY_NAMING:BOOL=OFF
            -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
            -DHDF_PACKAGE_EXT:STRING=${HDF_PACKAGE_EXT}
            -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
            -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_INSTALL_PREFIX}
            -DCMAKE_RUNTIME_OUTPUT_DIRECTORY:PATH=${CMAKE_RUNTIME_OUTPUT_DIRECTORY}
            -DCMAKE_LIBRARY_OUTPUT_DIRECTORY:PATH=${CMAKE_LIBRARY_OUTPUT_DIRECTORY}
            -DCMAKE_ARCHIVE_OUTPUT_DIRECTORY:PATH=${CMAKE_ARCHIVE_OUTPUT_DIRECTORY}
            -DCMAKE_ANSI_CFLAGS:STRING=${CMAKE_ANSI_CFLAGS}
            -DHDF5_BUILD_TOOLS:BOOL=ON
            -DHDF5_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DHDF5_PACKAGE_EXTLIBS:BOOL=${HDF_PACKAGE_EXTLIBS}
            -DHDF5_ALLOW_EXTERNAL_SUPPORT:STRING="SVN"
            -DZLIB_SVN_URL:STRING=${ZLIB_SVN_URL}
            -DSZIP_SVN_URL:STRING=${SZIP_SVN_URL}
            -DHDF5_ENABLE_Z_LIB_SUPPORT:BOOL=${HDF_ENABLE_Z_LIB_SUPPORT}
            -DHDF5_ENABLE_SZIP_SUPPORT:BOOL=${HDF_ENABLE_SZIP_SUPPORT}
            -DHDF5_ENABLE_SZIP_ENCODING:BOOL=${HDF_ENABLE_SZIP_ENCODING}
    ) 
  ENDIF (${compress_type} MATCHES "SVN")
  IF (${compress_type} MATCHES "TGZ")
    EXTERNALPROJECT_ADD (HDF5
        URL ${HDF5_URL}
        URL_MD5 ""
        INSTALL_COMMAND ""
        CMAKE_ARGS
            -DHDF_LEGACY_NAMING:BOOL=OFF
            -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
            -DHDF_PACKAGE_EXT:STRING=${HDF_PACKAGE_EXT}
            -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
            -DCMAKE_INSTALL_PREFIX:PATH=${CMAKE_INSTALL_PREFIX}
            -DCMAKE_RUNTIME_OUTPUT_DIRECTORY:PATH=${CMAKE_RUNTIME_OUTPUT_DIRECTORY}
            -DCMAKE_LIBRARY_OUTPUT_DIRECTORY:PATH=${CMAKE_LIBRARY_OUTPUT_DIRECTORY}
            -DCMAKE_ARCHIVE_OUTPUT_DIRECTORY:PATH=${CMAKE_ARCHIVE_OUTPUT_DIRECTORY}
            -DCMAKE_ANSI_CFLAGS:STRING=${CMAKE_ANSI_CFLAGS}
            -DHDF5_BUILD_TOOLS:BOOL=ON
            -DHDF5_EXTERNALLY_CONFIGURED:BOOL=OFF
            -DHDF5_PACKAGE_EXTLIBS:BOOL=${HDF_PACKAGE_EXTLIBS}
            -DHDF5_ALLOW_EXTERNAL_SUPPORT:STRING="TGZ"
            -DTGZ_PATH:STRING=${TGZ_PATH}
            -DZLIB_TGZ_NAME:STRING=${ZLIB_TGZ_NAME}
            -DSZIP_TGZ_NAME:STRING=${SZIP_TGZ_NAME}
            -DHDF5_ENABLE_Z_LIB_SUPPORT:BOOL=${HDF_ENABLE_Z_LIB_SUPPORT}
            -DHDF5_ENABLE_SZIP_SUPPORT:BOOL=${HDF_ENABLE_SZIP_SUPPORT}
            -DHDF5_ENABLE_SZIP_ENCODING:BOOL=${HDF_ENABLE_SZIP_ENCODING}
    ) 
  ENDIF (${compress_type} MATCHES "TGZ")
  EXTERNALPROJECT_GET_PROPERTY (HDF5 BINARY_DIR SOURCE_DIR) 

  IF (${CMAKE_BUILD_TYPE} MATCHES "DEBUG")
    IF (WIN32)
      SET (HDF5_LIB_NAME "hdf5_D")
    ELSE (WIN32)
      SET (HDF5_LIB_NAME "hdf5_debug")
    ENDIF (WIN32)
  ELSE (${CMAKE_BUILD_TYPE} MATCHES "DEBUG")
    SET (HDF5_LIB_NAME "hdf5")
  ENDIF (${CMAKE_BUILD_TYPE} MATCHES "DEBUG")

  # Create imported target hdf5
  ADD_LIBRARY(hdf5 ${libtype} IMPORTED)
  ADD_DEPENDENCIES (hdf5 HDF5)

  IF (${libtype} MATCHES "SHARED")
    IF (WIN32)
      IF (MINGW)
        SET_TARGET_PROPERTIES(hdf5 PROPERTIES
            IMPORTED_IMPLIB "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${HDF5_LIB_NAME}.lib"
            IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${HDF5_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
            IMPORTED_LINK_INTERFACE_LIBRARIES "zlib;szip"
        )
      ELSE (MINGW)
        SET_TARGET_PROPERTIES(hdf5 PROPERTIES
            IMPORTED_IMPLIB "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/${CMAKE_IMPORT_LIBRARY_PREFIX}${HDF5_LIB_NAME}${CMAKE_IMPORT_LIBRARY_SUFFIX}"
            IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/${CMAKE_IMPORT_LIBRARY_PREFIX}${HDF5_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
            IMPORTED_LINK_INTERFACE_LIBRARIES "zlib;szip"
        )
      ENDIF (MINGW)
    ELSE (WIN32)
      SET_TARGET_PROPERTIES(hdf5 PROPERTIES
          IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_SHARED_LIBRARY_PREFIX}${HDF5_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}"
          IMPORTED_LINK_INTERFACE_LIBRARIES "zlib;szip"
          IMPORTED_SONAME "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_SHARED_LIBRARY_PREFIX}${HDF5_LIB_NAME}${CMAKE_SHARED_LIBRARY_SUFFIX}.${HDF5_VERSION_STRING}"
          SOVERSION "${HDF5_VERSION_STRING}"
      )
    ENDIF (WIN32)
  ELSE (${libtype} MATCHES "SHARED")
    IF (WIN32 AND NOT MINGW)
      SET_TARGET_PROPERTIES(hdf5 PROPERTIES
          IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/${CMAKE_BUILD_TYPE}/lib${HDF5_LIB_NAME}${CMAKE_STATIC_LIBRARY_SUFFIX}"
          IMPORTED_LINK_INTERFACE_LIBRARIES "zlib;szip"
          IMPORTED_LINK_INTERFACE_LANGUAGES "C"
      )
    ELSE (WIN32 AND NOT MINGW)
      SET_TARGET_PROPERTIES(hdf5 PROPERTIES
          IMPORTED_LOCATION "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/lib${HDF5_LIB_NAME}${CMAKE_STATIC_LIBRARY_SUFFIX}"
          IMPORTED_LINK_INTERFACE_LIBRARIES "zlib;szip"
          IMPORTED_LINK_INTERFACE_LANGUAGES "C"
      )
    ENDIF (WIN32 AND NOT MINGW)
  ENDIF (${libtype} MATCHES "SHARED")
  SET (HDF5_LIBRARY "hdf5")

  SET (HDF5_INCLUDE_DIR_GEN "${BINARY_DIR}")
  SET (HDF5_INCLUDE_DIR "${SOURCE_DIR}/src")
  SET (HDF5_FOUND 1)
  SET (HDF5_LIBRARIES ${HDF5_LIBRARY})
  SET (HDF5_INCLUDE_DIRS ${HDF5_INCLUDE_DIR_GEN} ${HDF5_INCLUDE_DIR})
  ADD_EXECUTABLE (h5diff IMPORTED)
  IF (${libtype} MATCHES "SHARED" AND WIN32)
    SET_PROPERTY (TARGET h5diff PROPERTY IMPORTED_LOCATION "${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/h5diffdll")
  ELSE (${libtype} MATCHES "SHARED" AND WIN32)
    SET_PROPERTY (TARGET h5diff PROPERTY IMPORTED_LOCATION "${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/h5diff")
  ENDIF (${libtype} MATCHES "SHARED" AND WIN32)
  SET (HDF5_DIFF_EXECUTABLE $<TARGET_FILE:h5diff>)
ENDMACRO (EXTERNAL_HDF5_LIBRARY)

#-------------------------------------------------------------------------------
MACRO (PACKAGE_HDF5_LIBRARY compress_type)
  ADD_CUSTOM_TARGET (HDF5-GenHeader-Copy ALL
      COMMAND ${CMAKE_COMMAND} -E copy_if_different ${HDF5_INCLUDE_DIR_GEN}/H5pubconf.h ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/
      COMMENT "Copying ${HDF5_INCLUDE_DIR_GEN}/H5pubconf.h to ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/"
  )
  IF (${compress_type} MATCHES "SVN" OR ${compress_type} MATCHES "TGZ")
    ADD_DEPENDENCIES (HDF5-GenHeader-Copy HDF5)
  ENDIF (${compress_type} MATCHES "SVN" OR ${compress_type} MATCHES "TGZ")
ENDMACRO (PACKAGE_HDF5_LIBRARY)
