/*
 * Copyright 2010-2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package griffon.core.controller;

import griffon.core.ApplicationHandler;
import griffon.core.GriffonController;

import java.util.Map;

/**
 * @author Andres Almiray
 * @since 1.1.0
 */
public interface GriffonControllerActionManager extends ApplicationHandler {
    String ACTION = "Action";

    Map<String, GriffonControllerAction> actionsFor(GriffonController controller);

    GriffonControllerAction actionFor(GriffonController controller, String actionName);

    void createActions(GriffonController controller);

    String normalizeName(String actionName);
}
