/*
 * Copyright 2011-2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codehaus.griffon.resolve.config;

import groovy.lang.GroovyObjectSupport;
import org.codehaus.griffon.resolve.IvyDependencyManager;

abstract class AbstractDependencyManagementConfigurer extends GroovyObjectSupport {

    protected final DependencyConfigurationContext context;

    public AbstractDependencyManagementConfigurer(DependencyConfigurationContext context) {
        this.context = context;
    }

    public IvyDependencyManager getDependencyManager() {
        return context.dependencyManager;
    }

    public DependencyConfigurationContext getContext() {
        return context;
    }

    public String getGriffonVersion() {
        return getDependencyManager().getBuildSettings().getGriffonVersion();
    }

    public String getGroovyVersion() {
        return getDependencyManager().getBuildSettings().getGroovyVersion();
    }

    public String getAntVersion() {
        return getDependencyManager().getBuildSettings().getAntVersion();
    }

    public String getSlf4jVersion() {
        return getDependencyManager().getBuildSettings().getSlf4jVersion();
    }

    public String getSpringVersion() {
        return getDependencyManager().getBuildSettings().getSpringVersion();
    }
}
