/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.math.BigDecimal;
import java.text.NumberFormat;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberLabel
extends Label {
    private final NumberFormat nf;
    private ObjectProperty<BigDecimal> number = new SimpleObjectProperty();

    public final BigDecimal getNumber() {
        return (BigDecimal)this.number.get();
    }

    public final void setNumber(BigDecimal value) {
        this.number.set((Object)value);
    }

    public ObjectProperty<BigDecimal> numberProperty() {
        return this.number;
    }

    public NumberLabel() {
        this(BigDecimal.ZERO);
    }

    public NumberLabel(BigDecimal value) {
        this(value, NumberFormat.getInstance());
        this.initHandlers();
    }

    public NumberLabel(BigDecimal value, NumberFormat nf) {
        this.nf = nf;
        this.initHandlers();
        this.setNumber(value);
    }

    private void initHandlers() {
        this.numberProperty().addListener((ChangeListener)new ChangeListener<BigDecimal>(){

            public void changed(ObservableValue<? extends BigDecimal> obserable, BigDecimal oldValue, BigDecimal newValue) {
                NumberLabel.this.setText(NumberLabel.this.nf.format(newValue));
            }
        });
    }
}

