/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import javafx.animation.AnimationTimer;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import jfxtras.labs.internal.scene.control.behavior.TrafficLightBehavior;
import jfxtras.labs.scene.control.gauge.TrafficLight;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrafficLightSkin
extends SkinBase<TrafficLight, TrafficLightBehavior> {
    public static final long BLINK_INTERVAL = 500000000L;
    private TrafficLight control;
    private boolean isDirty;
    private boolean initialized;
    private Group trafficlight;
    private Shape redOn;
    private Shape highlightRedOn;
    private Shape yellowOn;
    private Shape highlightYellowOn;
    private Shape greenOn;
    private Shape highlightGreenOn;
    private boolean on;
    private AnimationTimer timer;
    private long lastTimerCall;

    public TrafficLightSkin(TrafficLight CONTROL) {
        super((Control)CONTROL, (BehaviorBase)new TrafficLightBehavior(CONTROL));
        this.control = CONTROL;
        this.initialized = false;
        this.isDirty = false;
        this.redOn = new Circle();
        this.highlightRedOn = new Ellipse();
        this.yellowOn = new Circle();
        this.highlightYellowOn = new Ellipse();
        this.greenOn = new Circle();
        this.highlightGreenOn = new Ellipse();
        this.trafficlight = new Group();
        this.timer = new AnimationTimer(){

            public void handle(long l) {
                long currentNanoTime = System.nanoTime();
                if (currentNanoTime > TrafficLightSkin.this.lastTimerCall + 500000000L) {
                    TrafficLightSkin.this.on = (byte)(TrafficLightSkin.this.on ^ 1);
                    if (TrafficLightSkin.this.control.isRedBlinking()) {
                        TrafficLightSkin.this.redOn.setVisible(TrafficLightSkin.this.on);
                        TrafficLightSkin.this.highlightRedOn.setVisible(TrafficLightSkin.this.on);
                    }
                    if (TrafficLightSkin.this.control.isYellowBlinking()) {
                        TrafficLightSkin.this.yellowOn.setVisible(TrafficLightSkin.this.on);
                        TrafficLightSkin.this.highlightYellowOn.setVisible(TrafficLightSkin.this.on);
                    }
                    if (TrafficLightSkin.this.control.isGreenBlinking()) {
                        TrafficLightSkin.this.greenOn.setVisible(TrafficLightSkin.this.on);
                        TrafficLightSkin.this.highlightGreenOn.setVisible(TrafficLightSkin.this.on);
                    }
                    TrafficLightSkin.this.lastTimerCall = currentNanoTime;
                }
            }
        };
        this.lastTimerCall = 0L;
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 | this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(80.0, 200.0);
        }
        this.control.prefWidthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                TrafficLightSkin.this.isDirty = true;
            }
        });
        this.control.prefHeightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                TrafficLightSkin.this.isDirty = true;
            }
        });
        this.registerChangeListener((ObservableValue)this.control.redOnProperty(), "RED");
        this.registerChangeListener((ObservableValue)this.control.redBlinkingProperty(), "RED_BLINKING");
        this.registerChangeListener((ObservableValue)this.control.yellowOnProperty(), "YELLOW");
        this.registerChangeListener((ObservableValue)this.control.yellowBlinkingProperty(), "YELLOW_BLINKING");
        this.registerChangeListener((ObservableValue)this.control.greenOnProperty(), "GREEN");
        this.registerChangeListener((ObservableValue)this.control.greenBlinkingProperty(), "GREEN_BLINKING");
        this.registerChangeListener((ObservableValue)this.control.darkBackgroundProperty(), "DARK_BACKGROUND");
        this.timer.start();
        this.initialized = true;
        this.paint();
    }

    public final void paint() {
        if (!this.initialized) {
            this.init();
        }
        this.getChildren().clear();
        this.drawTrafficLight();
        this.getChildren().add((Object)this.trafficlight);
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if (PROPERTY == "RED") {
            this.redOn.setVisible(this.control.isRedOn());
            this.highlightRedOn.setVisible(this.control.isRedOn());
        } else if (PROPERTY != "RED_BLINKING") {
            if (PROPERTY == "YELLOW") {
                this.yellowOn.setVisible(this.control.isYellowOn());
                this.highlightYellowOn.setVisible(this.control.isYellowOn());
            } else if (PROPERTY != "YELLOW_BLINKING") {
                if (PROPERTY == "GREEN") {
                    this.greenOn.setVisible(this.control.isGreenOn());
                    this.highlightGreenOn.setVisible(this.control.isGreenOn());
                } else if (PROPERTY != "GREEN_BLINKING" && PROPERTY == "DARK_BACKGROUND") {
                    this.paint();
                }
            }
        }
    }

    public void layoutChildren() {
        if (this.isDirty) {
            this.paint();
            this.isDirty = false;
        }
        super.layoutChildren();
    }

    public final TrafficLight getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    protected double computePrefWidth(double PREF_WIDTH) {
        double prefWidth = 80.0;
        if (PREF_WIDTH != -1.0) {
            prefWidth = Math.max(0.0, PREF_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    protected double computePrefHeight(double PREF_HEIGHT) {
        double prefHeight = 200.0;
        if (PREF_HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, PREF_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefWidth(prefHeight);
    }

    public final void drawTrafficLight() {
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        this.trafficlight.getChildren().clear();
        Rectangle HOUSING_BACKGROUND = new Rectangle(0.125 * WIDTH, 0.055 * HEIGHT, 0.75 * WIDTH, 0.9 * HEIGHT);
        HOUSING_BACKGROUND.setArcWidth(0.75 * WIDTH);
        HOUSING_BACKGROUND.setArcHeight(0.3 * HEIGHT);
        Color HOUSING_BACKGROUND_FILL = this.control.isDarkBackground() ? Color.color((double)0.2, (double)0.2, (double)0.2, (double)0.6) : Color.color((double)0.8, (double)0.8, (double)0.8, (double)0.6);
        HOUSING_BACKGROUND.setFill((Paint)HOUSING_BACKGROUND_FILL);
        HOUSING_BACKGROUND.setStroke(null);
        Path HOUSING_FRAME = new Path();
        HOUSING_FRAME.setFillRule(FillRule.EVEN_ODD);
        HOUSING_FRAME.getElements().add((Object)new MoveTo(0.125 * WIDTH, 0.205 * HEIGHT));
        HOUSING_FRAME.getElements().add((Object)new CubicCurveTo(0.125 * WIDTH, 0.12 * HEIGHT, 0.2875 * WIDTH, 0.055 * HEIGHT, 0.5 * WIDTH, 0.055 * HEIGHT));
        HOUSING_FRAME.getElements().add((Object)new CubicCurveTo(0.7125 * WIDTH, 0.055 * HEIGHT, 0.875 * WIDTH, 0.12 * HEIGHT, 0.875 * WIDTH, 0.205 * HEIGHT));
        HOUSING_FRAME.getElements().add((Object)new CubicCurveTo(0.875 * WIDTH, 0.205 * HEIGHT, 0.875 * WIDTH, 0.805 * HEIGHT, 0.875 * WIDTH, 0.805 * HEIGHT));
        HOUSING_FRAME.getElements().add((Object)new CubicCurveTo(0.875 * WIDTH, 0.89 * HEIGHT, 0.7125 * WIDTH, 0.955 * HEIGHT, 0.5 * WIDTH, 0.955 * HEIGHT));
        HOUSING_FRAME.getElements().add((Object)new CubicCurveTo(0.2875 * WIDTH, 0.955 * HEIGHT, 0.125 * WIDTH, 0.89 * HEIGHT, 0.125 * WIDTH, 0.805 * HEIGHT));
        HOUSING_FRAME.getElements().add((Object)new CubicCurveTo(0.125 * WIDTH, 0.805 * HEIGHT, 0.125 * WIDTH, 0.205 * HEIGHT, 0.125 * WIDTH, 0.205 * HEIGHT));
        HOUSING_FRAME.getElements().add((Object)new ClosePath());
        HOUSING_FRAME.getElements().add((Object)new MoveTo(0.0, 0.2 * HEIGHT));
        HOUSING_FRAME.getElements().add((Object)new CubicCurveTo(0.0, 0.2 * HEIGHT, 0.0, 0.8 * HEIGHT, 0.0, 0.8 * HEIGHT));
        HOUSING_FRAME.getElements().add((Object)new CubicCurveTo(0.0, 0.91 * HEIGHT, 0.225 * WIDTH, HEIGHT, 0.5 * WIDTH, HEIGHT));
        HOUSING_FRAME.getElements().add((Object)new CubicCurveTo(0.775 * WIDTH, HEIGHT, WIDTH, 0.91 * HEIGHT, WIDTH, 0.8 * HEIGHT));
        HOUSING_FRAME.getElements().add((Object)new CubicCurveTo(WIDTH, 0.8 * HEIGHT, WIDTH, 0.2 * HEIGHT, WIDTH, 0.2 * HEIGHT));
        HOUSING_FRAME.getElements().add((Object)new CubicCurveTo(WIDTH, 0.09 * HEIGHT, 0.775 * WIDTH, 0.0, 0.5 * WIDTH, 0.0));
        HOUSING_FRAME.getElements().add((Object)new CubicCurveTo(0.225 * WIDTH, 0.0, 0.0, 0.09 * HEIGHT, 0.0, 0.2 * HEIGHT));
        HOUSING_FRAME.getElements().add((Object)new ClosePath());
        Color HOUSING_FRAME_FILL = this.control.isDarkBackground() ? Color.color((double)0.8, (double)0.8, (double)0.8, (double)0.6) : Color.color((double)0.2, (double)0.2, (double)0.2, (double)0.6);
        HOUSING_FRAME.setFill((Paint)HOUSING_FRAME_FILL);
        HOUSING_FRAME.setStroke(null);
        this.trafficlight.getChildren().addAll((Object[])new Node[]{HOUSING_BACKGROUND, HOUSING_FRAME});
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.setWidth(0.140625 * WIDTH);
        INNER_SHADOW.setHeight(0.140625 * WIDTH);
        INNER_SHADOW.setRadius(0.140625 * WIDTH);
        INNER_SHADOW.setColor(Color.BLACK);
        INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        DropShadow RED_GLOW = new DropShadow();
        RED_GLOW.setWidth(0.25 * WIDTH);
        RED_GLOW.setHeight(0.25 * WIDTH);
        RED_GLOW.setRadius(0.18 * WIDTH);
        RED_GLOW.setColor(Color.RED);
        RED_GLOW.setBlurType(BlurType.GAUSSIAN);
        RED_GLOW.inputProperty().set((Object)INNER_SHADOW);
        DropShadow YELLOW_GLOW = new DropShadow();
        YELLOW_GLOW.setWidth(0.25 * WIDTH);
        YELLOW_GLOW.setHeight(0.25 * WIDTH);
        YELLOW_GLOW.setRadius(0.18 * WIDTH);
        YELLOW_GLOW.setColor(Color.YELLOW);
        YELLOW_GLOW.setBlurType(BlurType.GAUSSIAN);
        YELLOW_GLOW.inputProperty().set((Object)INNER_SHADOW);
        DropShadow GREEN_GLOW = new DropShadow();
        GREEN_GLOW.setWidth(0.25 * WIDTH);
        GREEN_GLOW.setHeight(0.25 * WIDTH);
        GREEN_GLOW.setRadius(0.18 * WIDTH);
        GREEN_GLOW.setColor(Color.LIME);
        GREEN_GLOW.setBlurType(BlurType.GAUSSIAN);
        GREEN_GLOW.inputProperty().set((Object)INNER_SHADOW);
        Circle redOff = new Circle(0.5 * WIDTH, 0.2 * HEIGHT, 0.3125 * WIDTH);
        RadialGradient RED_OFF_FILL = new RadialGradient(0.0, 0.0, 0.5 * WIDTH, 0.285 * HEIGHT, 0.59375 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.3019607843, (double)0.0, (double)0.0, (double)1.0)), new Stop(0.98, Color.color((double)0.0039215686, (double)0.0, (double)0.0, (double)1.0)), new Stop(0.99, Color.BLACK), new Stop(1.0, Color.BLACK)});
        redOff.setFill((Paint)RED_OFF_FILL);
        redOff.setStroke(null);
        redOff.setEffect((Effect)INNER_SHADOW);
        Ellipse HIGHLIGHT_RED_OFF = new Ellipse(0.49375 * WIDTH, 0.13 * HEIGHT, 0.23125 * WIDTH, 0.05 * HEIGHT);
        RadialGradient HIGHLIGHT_RED_OFF_FILL = new RadialGradient(0.0, 0.0, 0.5 * WIDTH, 0.105 * HEIGHT, 0.2125 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2235294118)), new Stop(0.98, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0274509804)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0274509804))});
        HIGHLIGHT_RED_OFF.setFill((Paint)HIGHLIGHT_RED_OFF_FILL);
        HIGHLIGHT_RED_OFF.setStroke(null);
        this.redOn = new Circle(0.5 * WIDTH, 0.2 * HEIGHT, 0.3125 * WIDTH);
        RadialGradient RED_ON_FILL = new RadialGradient(0.0, 0.0, 0.5 * WIDTH, 0.285 * HEIGHT, 0.59375 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.RED), new Stop(0.98, Color.color((double)0.2549019608, (double)0.0, (double)0.0, (double)1.0)), new Stop(0.99, Color.color((double)0.2470588235, (double)0.0, (double)0.0, (double)1.0)), new Stop(1.0, Color.color((double)0.2470588235, (double)0.0, (double)0.0, (double)1.0))});
        this.redOn.setFill((Paint)RED_ON_FILL);
        this.redOn.setStroke(null);
        this.redOn.setEffect((Effect)RED_GLOW);
        this.redOn.setVisible(this.control.isRedOn());
        this.highlightRedOn = new Ellipse(0.49375 * WIDTH, 0.13 * HEIGHT, 0.23125 * WIDTH, 0.05 * HEIGHT);
        RadialGradient HIGHLIGHT_RED_ON_FILL = new RadialGradient(0.0, 0.0, 0.5 * WIDTH, 0.105 * HEIGHT, 0.2125 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.6745098039)), new Stop(0.98, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0862745098)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0862745098))});
        this.highlightRedOn.setFill((Paint)HIGHLIGHT_RED_ON_FILL);
        this.highlightRedOn.setStroke(null);
        this.highlightRedOn.setVisible(this.control.isRedOn());
        this.trafficlight.getChildren().addAll((Object[])new Node[]{redOff, HIGHLIGHT_RED_OFF, this.redOn, this.highlightRedOn});
        Circle yellowOff = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.3125 * WIDTH);
        RadialGradient YELLOW_OFF_FILL = new RadialGradient(0.0, 0.0, 0.5 * WIDTH, 0.585 * HEIGHT, 0.59375 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.3254901961, (double)0.3333333333, (double)0.0, (double)1.0)), new Stop(0.98, Color.color((double)0.0039215686, (double)0.0039215686, (double)0.0, (double)1.0)), new Stop(0.99, Color.BLACK), new Stop(1.0, Color.BLACK)});
        yellowOff.setFill((Paint)YELLOW_OFF_FILL);
        yellowOff.setStroke(null);
        yellowOff.setEffect((Effect)INNER_SHADOW);
        Ellipse HIGHLIGHT_YELLOW_OFF = new Ellipse(0.49375 * WIDTH, 0.43 * HEIGHT, 0.23125 * WIDTH, 0.05 * HEIGHT);
        RadialGradient HIGHLIGHT_YELLOW_OFF_FILL = new RadialGradient(0.0, 0.0, 0.5 * WIDTH, 0.405 * HEIGHT, 0.2125 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2235294118)), new Stop(0.98, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0274509804)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0274509804))});
        HIGHLIGHT_YELLOW_OFF.setFill((Paint)HIGHLIGHT_YELLOW_OFF_FILL);
        HIGHLIGHT_YELLOW_OFF.setStroke(null);
        this.yellowOn = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.3125 * WIDTH);
        RadialGradient YELLOW_ON_FILL = new RadialGradient(0.0, 0.0, 0.5 * WIDTH, 0.585 * HEIGHT, 0.59375 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.YELLOW), new Stop(0.98, Color.color((double)0.3333333333, (double)0.3411764706, (double)0.0, (double)1.0)), new Stop(0.99, Color.color((double)0.3254901961, (double)0.3333333333, (double)0.0, (double)1.0)), new Stop(1.0, Color.color((double)0.3254901961, (double)0.3333333333, (double)0.0, (double)1.0))});
        this.yellowOn.setFill((Paint)YELLOW_ON_FILL);
        this.yellowOn.setStroke(null);
        this.yellowOn.setEffect((Effect)YELLOW_GLOW);
        this.yellowOn.setVisible(this.control.isYellowOn());
        this.highlightYellowOn = new Ellipse(0.49375 * WIDTH, 0.43 * HEIGHT, 0.23125 * WIDTH, 0.05 * HEIGHT);
        RadialGradient HIGHLIGHT_YELLOW_ON_FILL = new RadialGradient(0.0, 0.0, 0.5 * WIDTH, 0.405 * HEIGHT, 0.2125 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.6745098039)), new Stop(0.98, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0862745098)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0862745098))});
        this.highlightYellowOn.setFill((Paint)HIGHLIGHT_YELLOW_ON_FILL);
        this.highlightYellowOn.setStroke(null);
        this.highlightYellowOn.setVisible(this.control.isYellowOn());
        this.trafficlight.getChildren().addAll((Object[])new Node[]{yellowOff, HIGHLIGHT_YELLOW_OFF, this.yellowOn, this.highlightYellowOn});
        Circle greenOff = new Circle(0.5 * WIDTH, 0.8 * HEIGHT, 0.3125 * WIDTH);
        RadialGradient GREEN_OFF_FILL = new RadialGradient(0.0, 0.0, 0.5 * WIDTH, 0.885 * HEIGHT, 0.59375 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.0980392157, (double)0.337254902, (double)0.0, (double)1.0)), new Stop(0.98, Color.color((double)0.0, (double)0.0039215686, (double)0.0, (double)1.0)), new Stop(0.99, Color.BLACK), new Stop(1.0, Color.BLACK)});
        greenOff.setFill((Paint)GREEN_OFF_FILL);
        greenOff.setStroke(null);
        greenOff.setEffect((Effect)INNER_SHADOW);
        Ellipse HIGHLIGHT_GREEN_OFF = new Ellipse(0.49375 * WIDTH, 0.73 * HEIGHT, 0.23125 * WIDTH, 0.05 * HEIGHT);
        RadialGradient HIGHLIGHT_OFF_GREEN_FILL = new RadialGradient(0.0, 0.0, 0.5 * WIDTH, 0.705 * HEIGHT, 0.2125 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2235294118)), new Stop(0.98, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0274509804)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0274509804))});
        HIGHLIGHT_GREEN_OFF.setFill((Paint)HIGHLIGHT_OFF_GREEN_FILL);
        HIGHLIGHT_GREEN_OFF.setStroke(null);
        this.greenOn = new Circle(0.5 * WIDTH, 0.8 * HEIGHT, 0.3125 * WIDTH);
        RadialGradient GREEN_ON_FILL = new RadialGradient(0.0, 0.0, 0.5 * WIDTH, 0.885 * HEIGHT, 0.59375 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.LIME), new Stop(0.98, Color.color((double)0.1254901961, (double)0.2784313725, (double)0.1411764706, (double)1.0)), new Stop(0.99, Color.color((double)0.1254901961, (double)0.2705882353, (double)0.1411764706, (double)1.0)), new Stop(1.0, Color.color((double)0.1254901961, (double)0.2705882353, (double)0.1411764706, (double)1.0))});
        this.greenOn.setFill((Paint)GREEN_ON_FILL);
        this.greenOn.setStroke(null);
        this.greenOn.setEffect((Effect)GREEN_GLOW);
        this.greenOn.setVisible(this.control.isGreenOn());
        this.highlightGreenOn = new Ellipse(0.49375 * WIDTH, 0.73 * HEIGHT, 0.23125 * WIDTH, 0.05 * HEIGHT);
        RadialGradient HIGHLIGHT_GREEN_ON_FILL = new RadialGradient(0.0, 0.0, 0.5 * WIDTH, 0.705 * HEIGHT, 0.2125 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.6745098039)), new Stop(0.98, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0862745098)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0862745098))});
        this.highlightGreenOn.setFill((Paint)HIGHLIGHT_GREEN_ON_FILL);
        this.highlightGreenOn.setStroke(null);
        this.highlightGreenOn.setVisible(this.control.isGreenOn());
        this.trafficlight.getChildren().addAll((Object[])new Node[]{greenOff, HIGHLIGHT_GREEN_OFF, this.greenOn, this.highlightGreenOn});
    }
}

