/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.skin.SkinBase;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.util.Duration;
import jfxtras.labs.animation.Timer;
import jfxtras.labs.internal.scene.control.behavior.SpinnerBehavior;
import jfxtras.labs.scene.control.Spinner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpinnerCaspianSkin<T>
extends SkinBase<Spinner<T>, SpinnerBehavior<T>> {
    private Region decrementArrow = null;
    private Region incrementArrow = null;
    private GridPane gridPane = null;
    private BorderPane valueGroup;
    private final Timer unclickTimer = new Timer(new Runnable(){

        public void run() {
            SpinnerCaspianSkin.this.unclickArrows();
        }
    }).withDelay(Duration.millis((double)100.0)).withRepeats(false);
    private final Timer repeatDecrementClickTimer = new Timer(new Runnable(){

        public void run() {
            ((Spinner)SpinnerCaspianSkin.this.getSkinnable()).decrement();
        }
    }).withDelay(Duration.millis((double)500.0)).withCycleDuration(Duration.millis((double)50.0));
    private final Timer repeatIncrementClickTimer = new Timer(new Runnable(){

        public void run() {
            ((Spinner)SpinnerCaspianSkin.this.getSkinnable()).increment();
        }
    }).withDelay(Duration.millis((double)500.0)).withCycleDuration(Duration.millis((double)50.0));
    private TextField textField = null;

    public SpinnerCaspianSkin(Spinner<T> control) {
        super(control, new SpinnerBehavior<T>(control));
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((Spinner)this.getSkinnable()).editableProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                SpinnerCaspianSkin.this.replaceValueNode();
            }
        });
        this.replaceValueNode();
        ((Spinner)this.getSkinnable()).valueProperty().addListener(new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> observableValue, T oldValue, T newValue) {
                SpinnerCaspianSkin.this.refreshValue();
            }
        });
        this.refreshValue();
        ((Spinner)this.getSkinnable()).arrowDirectionProperty().addListener((ChangeListener)new ChangeListener<Spinner.ArrowDirection>(){

            public void changed(ObservableValue<? extends Spinner.ArrowDirection> observableValue, Spinner.ArrowDirection oldValue, Spinner.ArrowDirection newValue) {
                SpinnerCaspianSkin.this.setArrowCSS();
                SpinnerCaspianSkin.this.setArrowLocation();
            }
        });
        this.setArrowCSS();
        this.setArrowLocation();
        ((Spinner)this.getSkinnable()).alignmentProperty().addListener((ChangeListener)new ChangeListener<Pos>(){

            public void changed(ObservableValue<? extends Pos> observableValue, Pos oldValue, Pos newValue) {
                SpinnerCaspianSkin.this.alignValue();
            }
        });
        this.alignValue();
    }

    private void refreshValue() {
        if (((Spinner)this.getSkinnable()).isEditable().booleanValue()) {
            Object lValue = ((Spinner)this.getSkinnable()).getValue();
            this.textField.setText(((Spinner)this.getSkinnable()).getStringConverter().toString(lValue));
        } else {
            Node node = (Node)((Spinner)this.getSkinnable()).getCellFactory().call((Object)this.getSkinnable());
        }
    }

    private void createNodes() {
        this.decrementArrow = new Region();
        this.decrementArrow.getStyleClass().add((Object)"idle");
        this.valueGroup = new BorderPane();
        this.valueGroup.getStyleClass().add((Object)"value");
        this.incrementArrow = new Region();
        this.incrementArrow.getStyleClass().add((Object)"idle");
        this.gridPane = new GridPane();
        this.gridPane.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent evt) {
                if (SpinnerCaspianSkin.this.mouseEventOverArrow(evt, SpinnerCaspianSkin.this.decrementArrow)) {
                    SpinnerCaspianSkin.this.unclickArrows();
                    SpinnerCaspianSkin.this.decrementArrow.getStyleClass().add((Object)"clicked");
                    ((Spinner)SpinnerCaspianSkin.this.getSkinnable()).decrement();
                    SpinnerCaspianSkin.this.unclickTimer.restart();
                    return;
                }
                if (SpinnerCaspianSkin.this.mouseEventOverArrow(evt, SpinnerCaspianSkin.this.incrementArrow)) {
                    SpinnerCaspianSkin.this.unclickArrows();
                    SpinnerCaspianSkin.this.incrementArrow.getStyleClass().add((Object)"clicked");
                    ((Spinner)SpinnerCaspianSkin.this.getSkinnable()).increment();
                    SpinnerCaspianSkin.this.unclickTimer.restart();
                    return;
                }
            }
        });
        this.gridPane.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent evt) {
                if (SpinnerCaspianSkin.this.mouseEventOverArrow(evt, SpinnerCaspianSkin.this.decrementArrow)) {
                    SpinnerCaspianSkin.this.decrementArrow.getStyleClass().add((Object)"clicked");
                    SpinnerCaspianSkin.this.repeatDecrementClickTimer.restart();
                    return;
                }
                if (SpinnerCaspianSkin.this.mouseEventOverArrow(evt, SpinnerCaspianSkin.this.incrementArrow)) {
                    SpinnerCaspianSkin.this.incrementArrow.getStyleClass().add((Object)"clicked");
                    SpinnerCaspianSkin.this.repeatIncrementClickTimer.restart();
                    return;
                }
            }
        });
        this.gridPane.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent evt) {
                SpinnerCaspianSkin.this.unclickArrows();
                SpinnerCaspianSkin.this.repeatDecrementClickTimer.stop();
                SpinnerCaspianSkin.this.repeatIncrementClickTimer.stop();
            }
        });
        this.gridPane.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent evt) {
                SpinnerCaspianSkin.this.unclickArrows();
                SpinnerCaspianSkin.this.repeatDecrementClickTimer.stop();
                SpinnerCaspianSkin.this.repeatIncrementClickTimer.stop();
            }
        });
        this.getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
        this.getChildren().add((Object)this.gridPane);
    }

    private boolean mouseEventOverArrow(MouseEvent evt, Region region) {
        Point2D lClickInRelationToArrow = region.sceneToLocal(evt.getSceneX(), evt.getSceneY());
        return lClickInRelationToArrow.getX() >= 0.0 && lClickInRelationToArrow.getX() <= region.getWidth() && lClickInRelationToArrow.getY() >= 0.0 && lClickInRelationToArrow.getY() <= region.getHeight();
    }

    private void unclickArrows() {
        this.decrementArrow.getStyleClass().remove((Object)"clicked");
        this.incrementArrow.getStyleClass().remove((Object)"clicked");
    }

    private void replaceValueNode() {
        this.valueGroup.getChildren().clear();
        if (!((Spinner)this.getSkinnable()).isEditable().booleanValue()) {
            Node lNode = (Node)((Spinner)this.getSkinnable()).getCellFactory().call((Object)this.getSkinnable());
            this.valueGroup.setCenter(lNode);
        } else {
            if (this.textField == null) {
                this.textField = new TextField();
                this.textField.focusedProperty().addListener(new InvalidationListener(){

                    public void invalidated(Observable arg0) {
                        if (!SpinnerCaspianSkin.this.textField.isFocused()) {
                            SpinnerCaspianSkin.this.parse(SpinnerCaspianSkin.this.textField);
                        }
                    }
                });
                this.textField.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent evt) {
                        SpinnerCaspianSkin.this.parse(SpinnerCaspianSkin.this.textField);
                    }
                });
                this.textField.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        if (t.getCode() == KeyCode.ESCAPE) {
                            SpinnerCaspianSkin.this.refreshValue();
                        }
                    }
                });
                this.textField.alignmentProperty().bind(((Spinner)this.getSkinnable()).alignmentProperty());
            }
            this.valueGroup.setCenter((Node)this.textField);
        }
        this.alignValue();
    }

    private void alignValue() {
        BorderPane.setAlignment((Node)((Node)this.valueGroup.getChildren().get(0)), (Pos)((Pos)((Spinner)this.getSkinnable()).alignmentProperty().getValue()));
    }

    protected void parse(TextField textField) {
        String lText = textField.getText();
        ((SpinnerBehavior)this.getBehavior()).parse(lText);
        this.refreshValue();
    }

    private void setArrowLocation() {
        Spinner.ArrowDirection lArrowDirection = ((Spinner)this.getSkinnable()).getArrowDirection();
        Spinner.ArrowPosition lArrowPosition = ((Spinner)this.getSkinnable()).getArrowPosition();
        ColumnConstraints lColumnValue = new ColumnConstraints(this.valueGroup.getMinWidth(), this.valueGroup.getPrefWidth(), Double.MAX_VALUE);
        lColumnValue.setHgrow(Priority.ALWAYS);
        ColumnConstraints lColumnArrow = new ColumnConstraints(10.0);
        RowConstraints lRowValue = new RowConstraints(this.valueGroup.getMinHeight(), this.valueGroup.getPrefHeight(), Double.MAX_VALUE);
        lRowValue.setVgrow(Priority.ALWAYS);
        RowConstraints lRowArrow = new RowConstraints(10.0);
        this.gridPane.getChildren().clear();
        this.gridPane.getColumnConstraints().clear();
        this.gridPane.getRowConstraints().clear();
        if (lArrowDirection == Spinner.ArrowDirection.HORIZONTAL) {
            if (lArrowPosition == Spinner.ArrowPosition.LEADING) {
                this.gridPane.setHgap(3.0);
                this.gridPane.setVgap(0.0);
                this.gridPane.add((Node)this.decrementArrow, 0, 0);
                this.gridPane.add((Node)this.incrementArrow, 1, 0);
                this.gridPane.add((Node)this.valueGroup, 2, 0);
                this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{lColumnArrow, lColumnArrow, lColumnValue});
            }
            if (lArrowPosition == Spinner.ArrowPosition.TRAILING) {
                this.gridPane.setHgap(3.0);
                this.gridPane.setVgap(0.0);
                this.gridPane.add((Node)this.valueGroup, 0, 0);
                this.gridPane.add((Node)this.decrementArrow, 1, 0);
                this.gridPane.add((Node)this.incrementArrow, 2, 0);
                this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{lColumnValue, lColumnArrow, lColumnArrow});
            }
            if (lArrowPosition == Spinner.ArrowPosition.SPLIT) {
                this.gridPane.setHgap(3.0);
                this.gridPane.setVgap(0.0);
                this.gridPane.add((Node)this.decrementArrow, 0, 0);
                this.gridPane.add((Node)this.valueGroup, 1, 0);
                this.gridPane.add((Node)this.incrementArrow, 2, 0);
                this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{lColumnArrow, lColumnValue, lColumnArrow});
            }
        }
        if (lArrowDirection == Spinner.ArrowDirection.VERTICAL) {
            if (lArrowPosition == Spinner.ArrowPosition.LEADING) {
                this.gridPane.setHgap(3.0);
                this.gridPane.setVgap(0.0);
                this.gridPane.add((Node)this.incrementArrow, 0, 0);
                this.gridPane.add((Node)this.decrementArrow, 0, 1);
                this.gridPane.add((Node)this.valueGroup, 1, 0, 1, 2);
                this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{lColumnArrow, lColumnValue});
                this.gridPane.getRowConstraints().addAll((Object[])new RowConstraints[]{lRowArrow, lRowArrow});
            }
            if (lArrowPosition == Spinner.ArrowPosition.TRAILING) {
                this.gridPane.setHgap(3.0);
                this.gridPane.setVgap(0.0);
                this.gridPane.add((Node)this.valueGroup, 0, 0, 1, 2);
                this.gridPane.add((Node)this.incrementArrow, 1, 0);
                this.gridPane.add((Node)this.decrementArrow, 1, 1);
                this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{lColumnValue, lColumnArrow});
                this.gridPane.getRowConstraints().addAll((Object[])new RowConstraints[]{lRowArrow, lRowArrow});
            }
            if (lArrowPosition == Spinner.ArrowPosition.SPLIT) {
                this.gridPane.setHgap(3.0);
                this.gridPane.setVgap(0.0);
                this.gridPane.add((Node)this.incrementArrow, 0, 0);
                this.gridPane.add((Node)this.valueGroup, 0, 1);
                this.gridPane.add((Node)this.decrementArrow, 0, 2);
                this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{lColumnValue});
                this.gridPane.getRowConstraints().addAll((Object[])new RowConstraints[]{lRowArrow, lRowValue, lRowArrow});
            }
        }
    }

    private void setArrowCSS() {
        if (((Spinner)this.getSkinnable()).getArrowDirection().equals((Object)Spinner.ArrowDirection.HORIZONTAL)) {
            this.decrementArrow.getStyleClass().add((Object)"left-arrow");
            this.incrementArrow.getStyleClass().add((Object)"right-arrow");
        } else {
            this.decrementArrow.getStyleClass().add((Object)"down-arrow");
            this.incrementArrow.getStyleClass().add((Object)"up-arrow");
        }
    }
}

