/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import jfxtras.labs.internal.scene.control.behavior.NixieTubeBehavior;
import jfxtras.labs.scene.control.gauge.NixieTube;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NixieTubeSkin
extends SkinBase<NixieTube, NixieTubeBehavior> {
    private NixieTube control;
    private boolean isDirty;
    private boolean initialized;
    private Path hatch;
    private Group numbers;
    private Path zero;
    private Path one;
    private Path two;
    private Path three;
    private Path four;
    private Path five;
    private Path six;
    private Path seven;
    private Path eight;
    private Path nine;
    private Group tube;
    private Rectangle leftLight;
    private Rectangle rightLight;
    private DropShadow hatchGlow;
    private InnerShadow innerGlow;
    private DropShadow glow;

    public NixieTubeSkin(NixieTube CONTROL) {
        super((Control)CONTROL, (BehaviorBase)new NixieTubeBehavior(CONTROL));
        this.control = CONTROL;
        this.initialized = false;
        this.isDirty = false;
        this.hatch = new Path();
        this.numbers = new Group();
        this.tube = new Group();
        this.leftLight = new Rectangle();
        this.rightLight = new Rectangle();
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 | this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(86.0, 145.0);
        }
        this.control.prefWidthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                NixieTubeSkin.this.isDirty = true;
            }
        });
        this.control.prefHeightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                NixieTubeSkin.this.isDirty = true;
            }
        });
        this.registerChangeListener((ObservableValue)this.control.glowColorProperty(), "GLOW_COLOR");
        this.registerChangeListener((ObservableValue)this.control.numberProperty(), "NUMBER");
        this.createGlows();
        this.initialized = true;
        this.paint();
        this.setNumber();
    }

    public final void paint() {
        if (!this.initialized) {
            this.init();
        }
        this.getChildren().clear();
        this.drawNumbers();
        this.drawTube();
        this.getChildren().addAll((Object[])new Node[]{this.numbers, this.tube});
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if (PROPERTY == "GLOW_COLOR") {
            this.createGlows();
            this.setNumber();
            this.hatch.setEffect((Effect)this.hatchGlow);
        } else if (PROPERTY == "NUMBER") {
            this.setNumber();
        }
    }

    public void layoutChildren() {
        if (this.isDirty) {
            this.paint();
            this.isDirty = false;
        }
        super.layoutChildren();
    }

    public final NixieTube getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    protected double computePrefWidth(double PREF_WIDTH) {
        double prefWidth = 86.0;
        if (PREF_WIDTH != -1.0) {
            prefWidth = Math.max(0.0, PREF_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    protected double computePrefHeight(double PREF_HEIGHT) {
        double prefHeight = 145.0;
        if (PREF_HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, PREF_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefWidth(prefHeight);
    }

    private final void switchOffAllNumbers() {
        Color colorOff = Color.color((double)0.2, (double)0.2, (double)0.2, (double)0.6);
        this.zero.setEffect(null);
        this.zero.setStroke((Paint)colorOff);
        this.zero.setStrokeWidth(1.0);
        this.one.setEffect(null);
        this.one.setStroke((Paint)colorOff);
        this.one.setStrokeWidth(1.0);
        this.two.setEffect(null);
        this.two.setStroke((Paint)colorOff);
        this.two.setStrokeWidth(1.0);
        this.three.setEffect(null);
        this.three.setStroke((Paint)colorOff);
        this.three.setStrokeWidth(1.0);
        this.four.setEffect(null);
        this.four.setStroke((Paint)colorOff);
        this.four.setStrokeWidth(1.0);
        this.five.setEffect(null);
        this.five.setStroke((Paint)colorOff);
        this.five.setStrokeWidth(1.0);
        this.six.setEffect(null);
        this.six.setStroke((Paint)colorOff);
        this.six.setStrokeWidth(1.0);
        this.seven.setEffect(null);
        this.seven.setStroke((Paint)colorOff);
        this.seven.setStrokeWidth(1.0);
        this.eight.setEffect(null);
        this.eight.setStroke((Paint)colorOff);
        this.eight.setStrokeWidth(1.0);
        this.nine.setEffect(null);
        this.nine.setStroke((Paint)colorOff);
        this.nine.setStrokeWidth(1.0);
    }

    private final void setNumber() {
        this.switchOffAllNumbers();
        double STROKE_WIDTH = 0.023255814 * this.control.getPrefWidth();
        Color colorOn = Color.color((double)0.2, (double)0.2, (double)0.2, (double)1.0);
        switch (this.control.getNumber()) {
            case 0: {
                this.zero.setStroke((Paint)colorOn);
                this.zero.setEffect((Effect)this.glow);
                this.zero.setStrokeWidth(STROKE_WIDTH);
                break;
            }
            case 1: {
                this.one.setStroke((Paint)colorOn);
                this.one.setEffect((Effect)this.glow);
                this.one.setStrokeWidth(STROKE_WIDTH);
                break;
            }
            case 2: {
                this.two.setStroke((Paint)colorOn);
                this.two.setEffect((Effect)this.glow);
                this.two.setStrokeWidth(STROKE_WIDTH);
                break;
            }
            case 3: {
                this.three.setStroke((Paint)colorOn);
                this.three.setEffect((Effect)this.glow);
                this.three.setStrokeWidth(STROKE_WIDTH);
                break;
            }
            case 4: {
                this.four.setStroke((Paint)colorOn);
                this.four.setEffect((Effect)this.glow);
                this.four.setStrokeWidth(STROKE_WIDTH);
                break;
            }
            case 5: {
                this.five.setStroke((Paint)colorOn);
                this.five.setEffect((Effect)this.glow);
                this.five.setStrokeWidth(STROKE_WIDTH);
                break;
            }
            case 6: {
                this.six.setStroke((Paint)colorOn);
                this.six.setEffect((Effect)this.glow);
                this.six.setStrokeWidth(STROKE_WIDTH);
                break;
            }
            case 7: {
                this.seven.setStroke((Paint)colorOn);
                this.seven.setEffect((Effect)this.glow);
                this.seven.setStrokeWidth(STROKE_WIDTH);
                break;
            }
            case 8: {
                this.eight.setStroke((Paint)colorOn);
                this.eight.setEffect((Effect)this.glow);
                this.eight.setStrokeWidth(STROKE_WIDTH);
                break;
            }
            case 9: {
                this.nine.setStroke((Paint)colorOn);
                this.nine.setEffect((Effect)this.glow);
                this.nine.setStrokeWidth(STROKE_WIDTH);
            }
        }
    }

    private final void createGlows() {
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        this.innerGlow = new InnerShadow();
        this.innerGlow.setWidth(0.18 * WIDTH);
        this.innerGlow.setHeight(0.18 * WIDTH);
        this.innerGlow.setRadius(0.15 * WIDTH);
        this.innerGlow.setColor(this.control.getGlowColor().brighter().brighter());
        this.innerGlow.setBlurType(BlurType.GAUSSIAN);
        this.innerGlow.inputProperty().set(null);
        this.glow = new DropShadow();
        this.glow.setSpread(0.006 * WIDTH);
        this.glow.setRadius(0.15 * WIDTH);
        this.glow.setColor(this.control.getGlowColor());
        this.glow.setBlurType(BlurType.GAUSSIAN);
        this.glow.inputProperty().set((Object)this.innerGlow);
        this.hatchGlow = new DropShadow();
        this.hatchGlow.setRadius(0.1 * WIDTH);
        this.hatchGlow.setColor(Color.color((double)this.control.getGlowColor().getRed(), (double)this.control.getGlowColor().getGreen(), (double)this.control.getGlowColor().getBlue(), (double)0.6));
        this.hatch.setFill((Paint)Color.color((double)this.control.getGlowColor().getRed(), (double)this.control.getGlowColor().getGreen(), (double)this.control.getGlowColor().getBlue(), (double)0.05));
        this.leftLight.setFill((Paint)new LinearGradient(0.011627906976744186 * WIDTH, 0.32413793103448274 * HEIGHT, 0.011627906976744245 * WIDTH, 0.903448275862069 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)this.control.getGlowColor().getRed(), (double)this.control.getGlowColor().getGreen(), (double)this.control.getGlowColor().getBlue(), (double)0.1)), new Stop(0.5, Color.color((double)this.control.getGlowColor().getRed(), (double)this.control.getGlowColor().getGreen(), (double)this.control.getGlowColor().getBlue(), (double)0.4)), new Stop(1.0, Color.color((double)this.control.getGlowColor().getRed(), (double)this.control.getGlowColor().getGreen(), (double)this.control.getGlowColor().getBlue(), (double)0.1))}));
        this.rightLight.setFill((Paint)new LinearGradient(WIDTH, 0.32413793103448274 * HEIGHT, WIDTH, 0.903448275862069 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)this.control.getGlowColor().getRed(), (double)this.control.getGlowColor().getGreen(), (double)this.control.getGlowColor().getBlue(), (double)0.1)), new Stop(0.5, Color.color((double)this.control.getGlowColor().getRed(), (double)this.control.getGlowColor().getGreen(), (double)this.control.getGlowColor().getBlue(), (double)0.4)), new Stop(1.0, Color.color((double)this.control.getGlowColor().getRed(), (double)this.control.getGlowColor().getGreen(), (double)this.control.getGlowColor().getBlue(), (double)0.1))}));
    }

    private final void drawNumbers() {
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        this.numbers.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.numbers.getChildren().add((Object)IBOUNDS);
        this.createGlows();
        Color colorOff = Color.color((double)0.2, (double)0.2, (double)0.2, (double)0.6);
        this.one = new Path();
        this.one.setFillRule(FillRule.EVEN_ODD);
        this.one.getElements().add((Object)new MoveTo(0.4883720930232558 * WIDTH, 0.296551724137931 * HEIGHT));
        this.one.getElements().add((Object)new CubicCurveTo(0.4883720930232558 * WIDTH, 0.2896551724137931 * HEIGHT, 0.4883720930232558 * WIDTH, 0.2827586206896552 * HEIGHT, 0.5 * WIDTH, 0.2827586206896552 * HEIGHT));
        this.one.getElements().add((Object)new CubicCurveTo(0.5116279069767442 * WIDTH, 0.2827586206896552 * HEIGHT, 0.5232558139534884 * WIDTH, 0.2896551724137931 * HEIGHT, 0.5232558139534884 * WIDTH, 0.296551724137931 * HEIGHT));
        this.one.getElements().add((Object)new CubicCurveTo(0.5232558139534884 * WIDTH, 0.296551724137931 * HEIGHT, 0.5232558139534884 * WIDTH, 0.8482758620689655 * HEIGHT, 0.5232558139534884 * WIDTH, 0.8482758620689655 * HEIGHT));
        this.one.getElements().add((Object)new CubicCurveTo(0.5232558139534884 * WIDTH, 0.8551724137931035 * HEIGHT, 0.5116279069767442 * WIDTH, 0.8620689655172413 * HEIGHT, 0.5 * WIDTH, 0.8689655172413793 * HEIGHT));
        this.one.getElements().add((Object)new CubicCurveTo(0.4883720930232558 * WIDTH, 0.8689655172413793 * HEIGHT, 0.4883720930232558 * WIDTH, 0.8551724137931035 * HEIGHT, 0.4883720930232558 * WIDTH, 0.8482758620689655 * HEIGHT));
        this.one.getElements().add((Object)new CubicCurveTo(0.4883720930232558 * WIDTH, 0.8482758620689655 * HEIGHT, 0.4883720930232558 * WIDTH, 0.296551724137931 * HEIGHT, 0.4883720930232558 * WIDTH, 0.296551724137931 * HEIGHT));
        this.one.getElements().add((Object)new ClosePath());
        this.one.setFill(null);
        this.one.setStroke((Paint)colorOff);
        this.zero = new Path();
        this.zero.setFillRule(FillRule.EVEN_ODD);
        this.zero.getElements().add((Object)new MoveTo(0.2441860465116279 * WIDTH, 0.5862068965517241 * HEIGHT));
        this.zero.getElements().add((Object)new CubicCurveTo(0.2441860465116279 * WIDTH, 0.43448275862068964 * HEIGHT, 0.36046511627906974 * WIDTH, 0.31724137931034485 * HEIGHT, 0.5116279069767442 * WIDTH, 0.31724137931034485 * HEIGHT));
        this.zero.getElements().add((Object)new CubicCurveTo(0.6627906976744186 * WIDTH, 0.31724137931034485 * HEIGHT, 0.7790697674418605 * WIDTH, 0.43448275862068964 * HEIGHT, 0.7790697674418605 * WIDTH, 0.5862068965517241 * HEIGHT));
        this.zero.getElements().add((Object)new CubicCurveTo(0.7790697674418605 * WIDTH, 0.7310344827586207 * HEIGHT, 0.6627906976744186 * WIDTH, 0.8482758620689655 * HEIGHT, 0.5116279069767442 * WIDTH, 0.8482758620689655 * HEIGHT));
        this.zero.getElements().add((Object)new CubicCurveTo(0.36046511627906974 * WIDTH, 0.8482758620689655 * HEIGHT, 0.2441860465116279 * WIDTH, 0.7310344827586207 * HEIGHT, 0.2441860465116279 * WIDTH, 0.5862068965517241 * HEIGHT));
        this.zero.getElements().add((Object)new ClosePath());
        this.zero.setFill(null);
        this.zero.setStroke((Paint)colorOff);
        this.two = new Path();
        this.two.setFillRule(FillRule.EVEN_ODD);
        this.two.getElements().add((Object)new MoveTo(0.23255813953488372 * WIDTH, 0.47586206896551725 * HEIGHT));
        this.two.getElements().add((Object)new CubicCurveTo(0.23255813953488372 * WIDTH, 0.47586206896551725 * HEIGHT, 0.23255813953488372 * WIDTH, 0.43448275862068964 * HEIGHT, 0.23255813953488372 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.two.getElements().add((Object)new CubicCurveTo(0.2441860465116279 * WIDTH, 0.4068965517241379 * HEIGHT, 0.27906976744186046 * WIDTH, 0.3793103448275862 * HEIGHT, 0.3023255813953488 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.two.getElements().add((Object)new CubicCurveTo(0.32558139534883723 * WIDTH, 0.35172413793103446 * HEIGHT, 0.3488372093023256 * WIDTH, 0.33793103448275863 * HEIGHT, 0.4069767441860465 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.two.getElements().add((Object)new CubicCurveTo(0.43023255813953487 * WIDTH, 0.31724137931034485 * HEIGHT, 0.47674418604651164 * WIDTH, 0.31724137931034485 * HEIGHT, 0.4883720930232558 * WIDTH, 0.31724137931034485 * HEIGHT));
        this.two.getElements().add((Object)new CubicCurveTo(0.5697674418604651 * WIDTH, 0.31724137931034485 * HEIGHT, 0.6162790697674418 * WIDTH, 0.32413793103448274 * HEIGHT, 0.627906976744186 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.two.getElements().add((Object)new CubicCurveTo(0.6744186046511628 * WIDTH, 0.33793103448275863 * HEIGHT, 0.686046511627907 * WIDTH, 0.3448275862068966 * HEIGHT, 0.7093023255813954 * WIDTH, 0.3586206896551724 * HEIGHT));
        this.two.getElements().add((Object)new CubicCurveTo(0.7441860465116279 * WIDTH, 0.3793103448275862 * HEIGHT, 0.7674418604651163 * WIDTH, 0.41379310344827586 * HEIGHT, 0.7674418604651163 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.two.getElements().add((Object)new CubicCurveTo(0.7674418604651163 * WIDTH, 0.496551724137931 * HEIGHT, 0.7441860465116279 * WIDTH, 0.5241379310344828 * HEIGHT, 0.686046511627907 * WIDTH, 0.5448275862068965 * HEIGHT));
        this.two.getElements().add((Object)new CubicCurveTo(0.6627906976744186 * WIDTH, 0.5586206896551724 * HEIGHT, 0.5813953488372093 * WIDTH, 0.5724137931034483 * HEIGHT, 0.5348837209302325 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.two.getElements().add((Object)new CubicCurveTo(0.4883720930232558 * WIDTH, 0.5862068965517241 * HEIGHT, 0.45348837209302323 * WIDTH, 0.6 * HEIGHT, 0.45348837209302323 * WIDTH, 0.6 * HEIGHT));
        this.two.getElements().add((Object)new CubicCurveTo(0.36046511627906974 * WIDTH, 0.6344827586206897 * HEIGHT, 0.29069767441860467 * WIDTH, 0.6896551724137931 * HEIGHT, 0.2558139534883721 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.two.getElements().add((Object)new CubicCurveTo(0.2441860465116279 * WIDTH, 0.7724137931034483 * HEIGHT, 0.23255813953488372 * WIDTH, 0.8482758620689655 * HEIGHT, 0.23255813953488372 * WIDTH, 0.8482758620689655 * HEIGHT));
        this.two.getElements().add((Object)new LineTo(0.7906976744186046 * WIDTH, 0.8482758620689655 * HEIGHT));
        this.two.setFill(null);
        this.two.setStroke((Paint)colorOff);
        this.three = new Path();
        this.three.setFillRule(FillRule.EVEN_ODD);
        this.three.getElements().add((Object)new MoveTo(0.23255813953488372 * WIDTH, 0.31724137931034485 * HEIGHT));
        this.three.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.31724137931034485 * HEIGHT));
        this.three.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.three.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.5172413793103449 * HEIGHT));
        this.three.getElements().add((Object)new CubicCurveTo(0.5232558139534884 * WIDTH, 0.5172413793103449 * HEIGHT, 0.5697674418604651 * WIDTH, 0.5241379310344828 * HEIGHT, 0.6046511627906976 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.three.getElements().add((Object)new CubicCurveTo(0.6744186046511628 * WIDTH, 0.5448275862068965 * HEIGHT, 0.7209302325581395 * WIDTH, 0.593103448275862 * HEIGHT, 0.7209302325581395 * WIDTH, 0.593103448275862 * HEIGHT));
        this.three.getElements().add((Object)new CubicCurveTo(0.7674418604651163 * WIDTH, 0.6344827586206897 * HEIGHT, 0.7674418604651163 * WIDTH, 0.6758620689655173 * HEIGHT, 0.7674418604651163 * WIDTH, 0.6896551724137931 * HEIGHT));
        this.three.getElements().add((Object)new CubicCurveTo(0.7674418604651163 * WIDTH, 0.7172413793103448 * HEIGHT, 0.7558139534883721 * WIDTH, 0.7448275862068966 * HEIGHT, 0.7325581395348837 * WIDTH, 0.7655172413793103 * HEIGHT));
        this.three.getElements().add((Object)new CubicCurveTo(0.7093023255813954 * WIDTH, 0.7862068965517242 * HEIGHT, 0.686046511627907 * WIDTH, 0.8068965517241379 * HEIGHT, 0.6395348837209303 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.three.getElements().add((Object)new CubicCurveTo(0.5930232558139535 * WIDTH, 0.8413793103448276 * HEIGHT, 0.5116279069767442 * WIDTH, 0.8482758620689655 * HEIGHT, 0.5116279069767442 * WIDTH, 0.8482758620689655 * HEIGHT));
        this.three.getElements().add((Object)new CubicCurveTo(0.5 * WIDTH, 0.8482758620689655 * HEIGHT, 0.45348837209302323 * WIDTH, 0.8482758620689655 * HEIGHT, 0.45348837209302323 * WIDTH, 0.8482758620689655 * HEIGHT));
        this.three.getElements().add((Object)new CubicCurveTo(0.3953488372093023 * WIDTH, 0.8482758620689655 * HEIGHT, 0.32558139534883723 * WIDTH, 0.8275862068965517 * HEIGHT, 0.29069767441860467 * WIDTH, 0.8068965517241379 * HEIGHT));
        this.three.getElements().add((Object)new CubicCurveTo(0.2558139534883721 * WIDTH, 0.7931034482758621 * HEIGHT, 0.23255813953488372 * WIDTH, 0.7655172413793103 * HEIGHT, 0.23255813953488372 * WIDTH, 0.7655172413793103 * HEIGHT));
        this.three.setFill(null);
        this.three.setStroke((Paint)colorOff);
        this.six = new Path();
        this.six.setFillRule(FillRule.EVEN_ODD);
        this.six.getElements().add((Object)new MoveTo(0.5232558139534884 * WIDTH, 0.2827586206896552 * HEIGHT));
        this.six.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.six.getElements().add((Object)new MoveTo(0.22093023255813954 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.six.getElements().add((Object)new CubicCurveTo(0.22093023255813954 * WIDTH, 0.5862068965517241 * HEIGHT, 0.3488372093023256 * WIDTH, 0.5103448275862069 * HEIGHT, 0.5116279069767442 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.six.getElements().add((Object)new CubicCurveTo(0.6627906976744186 * WIDTH, 0.5103448275862069 * HEIGHT, 0.7906976744186046 * WIDTH, 0.5862068965517241 * HEIGHT, 0.7906976744186046 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.six.getElements().add((Object)new CubicCurveTo(0.7906976744186046 * WIDTH, 0.7655172413793103 * HEIGHT, 0.6627906976744186 * WIDTH, 0.8413793103448276 * HEIGHT, 0.5116279069767442 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.six.getElements().add((Object)new CubicCurveTo(0.3488372093023256 * WIDTH, 0.8413793103448276 * HEIGHT, 0.22093023255813954 * WIDTH, 0.7655172413793103 * HEIGHT, 0.22093023255813954 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.six.getElements().add((Object)new ClosePath());
        this.six.setFill(null);
        this.six.setStroke((Paint)colorOff);
        this.four = new Path();
        this.four.setFillRule(FillRule.EVEN_ODD);
        this.four.getElements().add((Object)new MoveTo(0.7790697674418605 * WIDTH, 0.6827586206896552 * HEIGHT));
        this.four.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.6827586206896552 * HEIGHT));
        this.four.getElements().add((Object)new CubicCurveTo(0.2441860465116279 * WIDTH, 0.6827586206896552 * HEIGHT, 0.23255813953488372 * WIDTH, 0.6758620689655173 * HEIGHT, 0.22093023255813954 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.four.getElements().add((Object)new CubicCurveTo(0.19767441860465115 * WIDTH, 0.6689655172413793 * HEIGHT, 0.19767441860465115 * WIDTH, 0.6689655172413793 * HEIGHT, 0.20930232558139536 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.four.getElements().add((Object)new CubicCurveTo(0.20930232558139536 * WIDTH, 0.6551724137931034 * HEIGHT, 0.6046511627906976 * WIDTH, 0.30344827586206896 * HEIGHT, 0.6046511627906976 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.four.getElements().add((Object)new LineTo(0.6046511627906976 * WIDTH, 0.8482758620689655 * HEIGHT));
        this.four.setFill(null);
        this.four.setStroke((Paint)colorOff);
        this.nine = new Path();
        this.nine.setFillRule(FillRule.EVEN_ODD);
        this.nine.getElements().add((Object)new MoveTo(0.5465116279069767 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.nine.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.nine.getElements().add((Object)new MoveTo(0.23255813953488372 * WIDTH, 0.46206896551724136 * HEIGHT));
        this.nine.getElements().add((Object)new CubicCurveTo(0.23255813953488372 * WIDTH, 0.3724137931034483 * HEIGHT, 0.36046511627906974 * WIDTH, 0.296551724137931 * HEIGHT, 0.5116279069767442 * WIDTH, 0.296551724137931 * HEIGHT));
        this.nine.getElements().add((Object)new CubicCurveTo(0.6627906976744186 * WIDTH, 0.296551724137931 * HEIGHT, 0.7906976744186046 * WIDTH, 0.3724137931034483 * HEIGHT, 0.7906976744186046 * WIDTH, 0.46206896551724136 * HEIGHT));
        this.nine.getElements().add((Object)new CubicCurveTo(0.7906976744186046 * WIDTH, 0.5517241379310345 * HEIGHT, 0.6627906976744186 * WIDTH, 0.6275862068965518 * HEIGHT, 0.5116279069767442 * WIDTH, 0.6275862068965518 * HEIGHT));
        this.nine.getElements().add((Object)new CubicCurveTo(0.36046511627906974 * WIDTH, 0.6275862068965518 * HEIGHT, 0.23255813953488372 * WIDTH, 0.5517241379310345 * HEIGHT, 0.23255813953488372 * WIDTH, 0.46206896551724136 * HEIGHT));
        this.nine.getElements().add((Object)new ClosePath());
        this.nine.setFill(null);
        this.nine.setStroke((Paint)colorOff);
        this.five = new Path();
        this.five.setFillRule(FillRule.EVEN_ODD);
        this.five.getElements().add((Object)new MoveTo(0.7093023255813954 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.five.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.five.getElements().add((Object)new LineTo(0.26744186046511625 * WIDTH, 0.5655172413793104 * HEIGHT));
        this.five.getElements().add((Object)new CubicCurveTo(0.26744186046511625 * WIDTH, 0.5655172413793104 * HEIGHT, 0.29069767441860467 * WIDTH, 0.5655172413793104 * HEIGHT, 0.29069767441860467 * WIDTH, 0.5655172413793104 * HEIGHT));
        this.five.getElements().add((Object)new CubicCurveTo(0.3488372093023256 * WIDTH, 0.5448275862068965 * HEIGHT, 0.4069767441860465 * WIDTH, 0.5310344827586206 * HEIGHT, 0.4418604651162791 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.five.getElements().add((Object)new CubicCurveTo(0.4883720930232558 * WIDTH, 0.5241379310344828 * HEIGHT, 0.5116279069767442 * WIDTH, 0.5241379310344828 * HEIGHT, 0.5465116279069767 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.five.getElements().add((Object)new CubicCurveTo(0.6162790697674418 * WIDTH, 0.5379310344827586 * HEIGHT, 0.686046511627907 * WIDTH, 0.5793103448275863 * HEIGHT, 0.6976744186046512 * WIDTH, 0.593103448275862 * HEIGHT));
        this.five.getElements().add((Object)new CubicCurveTo(0.7209302325581395 * WIDTH, 0.6068965517241379 * HEIGHT, 0.7441860465116279 * WIDTH, 0.6413793103448275 * HEIGHT, 0.7558139534883721 * WIDTH, 0.6482758620689655 * HEIGHT));
        this.five.getElements().add((Object)new CubicCurveTo(0.7558139534883721 * WIDTH, 0.6620689655172414 * HEIGHT, 0.7674418604651163 * WIDTH, 0.696551724137931 * HEIGHT, 0.7674418604651163 * WIDTH, 0.696551724137931 * HEIGHT));
        this.five.getElements().add((Object)new CubicCurveTo(0.7674418604651163 * WIDTH, 0.7172413793103448 * HEIGHT, 0.7441860465116279 * WIDTH, 0.7448275862068966 * HEIGHT, 0.7441860465116279 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.five.getElements().add((Object)new CubicCurveTo(0.7441860465116279 * WIDTH, 0.7586206896551724 * HEIGHT, 0.7093023255813954 * WIDTH, 0.7931034482758621 * HEIGHT, 0.7093023255813954 * WIDTH, 0.7931034482758621 * HEIGHT));
        this.five.getElements().add((Object)new CubicCurveTo(0.6976744186046512 * WIDTH, 0.8068965517241379 * HEIGHT, 0.6395348837209303 * WIDTH, 0.8275862068965517 * HEIGHT, 0.6395348837209303 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.five.getElements().add((Object)new CubicCurveTo(0.5697674418604651 * WIDTH, 0.8482758620689655 * HEIGHT, 0.47674418604651164 * WIDTH, 0.8482758620689655 * HEIGHT, 0.47674418604651164 * WIDTH, 0.8482758620689655 * HEIGHT));
        this.five.getElements().add((Object)new CubicCurveTo(0.3953488372093023 * WIDTH, 0.8482758620689655 * HEIGHT, 0.3372093023255814 * WIDTH, 0.8206896551724138 * HEIGHT, 0.3372093023255814 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.five.getElements().add((Object)new CubicCurveTo(0.3023255813953488 * WIDTH, 0.8137931034482758 * HEIGHT, 0.26744186046511625 * WIDTH, 0.7862068965517242 * HEIGHT, 0.26744186046511625 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.five.getElements().add((Object)new CubicCurveTo(0.2441860465116279 * WIDTH, 0.7724137931034483 * HEIGHT, 0.23255813953488372 * WIDTH, 0.7517241379310344 * HEIGHT, 0.23255813953488372 * WIDTH, 0.7517241379310344 * HEIGHT));
        this.five.setFill(null);
        this.five.setStroke((Paint)colorOff);
        this.eight = new Path();
        this.eight.setFillRule(FillRule.EVEN_ODD);
        this.eight.getElements().add((Object)new MoveTo(0.20930232558139536 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.eight.getElements().add((Object)new CubicCurveTo(0.20930232558139536 * WIDTH, 0.6137931034482759 * HEIGHT, 0.3372093023255814 * WIDTH, 0.5448275862068965 * HEIGHT, 0.5 * WIDTH, 0.5448275862068965 * HEIGHT));
        this.eight.getElements().add((Object)new CubicCurveTo(0.6627906976744186 * WIDTH, 0.5448275862068965 * HEIGHT, 0.7906976744186046 * WIDTH, 0.6137931034482759 * HEIGHT, 0.7906976744186046 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.eight.getElements().add((Object)new CubicCurveTo(0.7906976744186046 * WIDTH, 0.7862068965517242 * HEIGHT, 0.6627906976744186 * WIDTH, 0.8551724137931035 * HEIGHT, 0.5 * WIDTH, 0.8551724137931035 * HEIGHT));
        this.eight.getElements().add((Object)new CubicCurveTo(0.3372093023255814 * WIDTH, 0.8551724137931035 * HEIGHT, 0.20930232558139536 * WIDTH, 0.7862068965517242 * HEIGHT, 0.20930232558139536 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.eight.getElements().add((Object)new ClosePath());
        this.eight.getElements().add((Object)new MoveTo(0.26744186046511625 * WIDTH, 0.4206896551724138 * HEIGHT));
        this.eight.getElements().add((Object)new CubicCurveTo(0.26744186046511625 * WIDTH, 0.3448275862068966 * HEIGHT, 0.37209302325581395 * WIDTH, 0.2896551724137931 * HEIGHT, 0.5116279069767442 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.eight.getElements().add((Object)new CubicCurveTo(0.6511627906976745 * WIDTH, 0.2896551724137931 * HEIGHT, 0.7558139534883721 * WIDTH, 0.3448275862068966 * HEIGHT, 0.7558139534883721 * WIDTH, 0.4206896551724138 * HEIGHT));
        this.eight.getElements().add((Object)new CubicCurveTo(0.7558139534883721 * WIDTH, 0.4896551724137931 * HEIGHT, 0.6511627906976745 * WIDTH, 0.5448275862068965 * HEIGHT, 0.5116279069767442 * WIDTH, 0.5448275862068965 * HEIGHT));
        this.eight.getElements().add((Object)new CubicCurveTo(0.37209302325581395 * WIDTH, 0.5448275862068965 * HEIGHT, 0.26744186046511625 * WIDTH, 0.4896551724137931 * HEIGHT, 0.26744186046511625 * WIDTH, 0.4206896551724138 * HEIGHT));
        this.eight.getElements().add((Object)new ClosePath());
        this.eight.setFill(null);
        this.eight.setStroke((Paint)colorOff);
        this.seven = new Path();
        this.seven.setFillRule(FillRule.EVEN_ODD);
        this.seven.getElements().add((Object)new MoveTo(0.22093023255813954 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.seven.getElements().add((Object)new LineTo(0.7906976744186046 * WIDTH, 0.296551724137931 * HEIGHT));
        this.seven.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.seven.setFill(null);
        this.seven.setStroke((Paint)colorOff);
        this.numbers.getChildren().addAll((Object[])new Node[]{this.one, this.zero, this.two, this.three, this.six, this.four, this.nine, this.five, this.eight, this.seven});
    }

    /*
     * Opcode count of 14935 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private final void drawTube() {
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        this.tube.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.tube.getChildren().add((Object)IBOUNDS);
        this.hatch = new Path();
        this.hatch.setFillRule(FillRule.EVEN_ODD);
        this.hatch.getElements().add((Object)new MoveTo(0.8372093023255814 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.872093023255814 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.872093023255814 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.8758620689655172 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.7674418604651163 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.8758620689655172 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.6976744186046512 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.8758620689655172 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.627906976744186 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.8758620689655172 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5581395348837209 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.8758620689655172 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.4883720930232558 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.8758620689655172 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.4186046511627907 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.8758620689655172 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.3488372093023256 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.8758620689655172 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.27906976744186046 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.8758620689655172 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.20930232558139536 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.8758620689655172 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.8620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.8413793103448276 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.8275862068965517 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.8023255813953488 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.8344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.7325581395348837 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.8344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.6627906976744186 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.8344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5930232558139535 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.8344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5232558139534884 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.8344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.45348837209302323 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.8344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.38372093023255816 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.8344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.313953488372093 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.8344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.2441860465116279 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.8344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.1744186046511628 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.8344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.13953488372093023 * WIDTH, 0.8206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.13953488372093023 * WIDTH, 0.8 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.7862068965517242 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.8372093023255814 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.872093023255814 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.872093023255814 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.7931034482758621 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.7674418604651163 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.7931034482758621 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.6976744186046512 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.7931034482758621 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.627906976744186 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.7931034482758621 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5581395348837209 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.7931034482758621 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.4883720930232558 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.7931034482758621 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.4186046511627907 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.7931034482758621 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.3488372093023256 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.7931034482758621 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.27906976744186046 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.7931034482758621 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.20930232558139536 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.7931034482758621 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.7793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.7586206896551724 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.7448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.8023255813953488 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.7517241379310344 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.7325581395348837 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.7517241379310344 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.6627906976744186 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.7517241379310344 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5930232558139535 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.7517241379310344 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5232558139534884 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.7517241379310344 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.45348837209302323 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.7517241379310344 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.38372093023255816 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.7517241379310344 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.313953488372093 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.7517241379310344 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.2441860465116279 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.7517241379310344 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.1744186046511628 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.7517241379310344 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.13953488372093023 * WIDTH, 0.7379310344827587 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.13953488372093023 * WIDTH, 0.7172413793103448 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.7034482758620689 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.8372093023255814 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.872093023255814 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.872093023255814 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.7103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.7674418604651163 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.7103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.6976744186046512 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.7103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.627906976744186 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.7103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5581395348837209 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.7103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.4883720930232558 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.7103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.4186046511627907 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.7103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.3488372093023256 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.7103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.27906976744186046 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.7103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.20930232558139536 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.7103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.696551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.6758620689655173 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.6620689655172414 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.8023255813953488 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.6689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.7325581395348837 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.6689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.6627906976744186 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.6689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5930232558139535 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.6689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5232558139534884 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.6689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.45348837209302323 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.6689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.38372093023255816 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.6689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.313953488372093 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.6689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.2441860465116279 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.6689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.1744186046511628 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.6689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.13953488372093023 * WIDTH, 0.6551724137931034 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.13953488372093023 * WIDTH, 0.6344827586206897 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.6206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.8372093023255814 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.872093023255814 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.872093023255814 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.6275862068965518 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.7674418604651163 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.6275862068965518 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.6976744186046512 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.6275862068965518 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.627906976744186 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.6275862068965518 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5581395348837209 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.6275862068965518 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.4883720930232558 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.6275862068965518 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.4186046511627907 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.6275862068965518 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.3488372093023256 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.6275862068965518 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.27906976744186046 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.6275862068965518 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.20930232558139536 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.6275862068965518 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.6137931034482759 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.593103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.5793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.8023255813953488 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.5862068965517241 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.7325581395348837 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.5862068965517241 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.6627906976744186 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.5862068965517241 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5930232558139535 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.5862068965517241 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5232558139534884 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.5862068965517241 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.45348837209302323 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.5862068965517241 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.38372093023255816 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.5862068965517241 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.313953488372093 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.5862068965517241 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.2441860465116279 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.5862068965517241 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.1744186046511628 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.5862068965517241 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.13953488372093023 * WIDTH, 0.5724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.13953488372093023 * WIDTH, 0.5517241379310345 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.5379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.8372093023255814 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.872093023255814 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.872093023255814 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.5448275862068965 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.7674418604651163 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.5448275862068965 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.6976744186046512 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.5448275862068965 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.627906976744186 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.5448275862068965 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5581395348837209 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.5448275862068965 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.4883720930232558 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.5448275862068965 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.4186046511627907 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.5448275862068965 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.3488372093023256 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.5448275862068965 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.27906976744186046 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.5448275862068965 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.20930232558139536 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.5448275862068965 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.5310344827586206 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.5103448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.496551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.8023255813953488 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.503448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.7325581395348837 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.503448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.6627906976744186 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.503448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5930232558139535 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.503448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5232558139534884 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.503448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.45348837209302323 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.503448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.38372093023255816 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.503448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.313953488372093 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.503448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.2441860465116279 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.503448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.1744186046511628 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.503448275862069 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.13953488372093023 * WIDTH, 0.4896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.13953488372093023 * WIDTH, 0.4689655172413793 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.45517241379310347 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.8372093023255814 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.872093023255814 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.872093023255814 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.46206896551724136 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.7674418604651163 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.46206896551724136 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.6976744186046512 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.46206896551724136 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.627906976744186 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.46206896551724136 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5581395348837209 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.46206896551724136 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.4883720930232558 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.46206896551724136 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.4186046511627907 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.46206896551724136 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.3488372093023256 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.46206896551724136 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.27906976744186046 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.46206896551724136 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.20930232558139536 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.46206896551724136 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.4482758620689655 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.42758620689655175 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.41379310344827586 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.8023255813953488 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.4206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.7325581395348837 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.4206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.6627906976744186 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.4206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5930232558139535 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.4206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5232558139534884 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.4206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.45348837209302323 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.4206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.38372093023255816 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.4206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.313953488372093 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.4206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.2441860465116279 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.4206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.1744186046511628 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.4206896551724138 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.13953488372093023 * WIDTH, 0.4068965517241379 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.13953488372093023 * WIDTH, 0.38620689655172413 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.3724137931034483 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.8372093023255814 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.872093023255814 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.872093023255814 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.3793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.7674418604651163 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.3793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.6976744186046512 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.3793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.627906976744186 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.3793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5581395348837209 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.3793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.4883720930232558 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.3793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.4186046511627907 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.3793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.3488372093023256 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.3793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.27906976744186046 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.3793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.20930232558139536 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.3793103448275862 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.36551724137931035 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.3448275862068966 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.3310344827586207 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.8023255813953488 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8372093023255814 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.33793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.7325581395348837 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7674418604651163 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.33793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.6627906976744186 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6976744186046512 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.33793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.6627906976744186 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5930232558139535 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.33793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5930232558139535 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.5232558139534884 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.33793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.5232558139534884 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.45348837209302323 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4883720930232558 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.33793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.38372093023255816 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.4186046511627907 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.33793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.313953488372093 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.3488372093023256 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.33793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.313953488372093 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.2441860465116279 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.33793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.2441860465116279 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.getElements().add((Object)new MoveTo(0.1744186046511628 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.33793103448275863 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.13953488372093023 * WIDTH, 0.32413793103448274 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.13953488372093023 * WIDTH, 0.30344827586206896 * HEIGHT));
        this.hatch.getElements().add((Object)new LineTo(0.1744186046511628 * WIDTH, 0.2896551724137931 * HEIGHT));
        this.hatch.getElements().add((Object)new ClosePath());
        this.hatch.setFill((Paint)Color.color((double)this.control.getGlowColor().getRed(), (double)this.control.getGlowColor().getGreen(), (double)this.control.getGlowColor().getBlue(), (double)0.05));
        this.hatch.setStroke((Paint)Color.color((double)0.2, (double)0.2, (double)0.2, (double)0.5));
        this.hatch.setEffect((Effect)this.hatchGlow);
        this.tube.getChildren().addAll((Object[])new Node[]{this.hatch});
        this.tube.setCache(true);
        this.continueTube(this.tube, WIDTH, HEIGHT);
    }

    private void continueTube(Group foreground2, double WIDTH, double HEIGHT) {
        Path CONNECTOR = new Path();
        CONNECTOR.setFillRule(FillRule.EVEN_ODD);
        CONNECTOR.getElements().add((Object)new MoveTo(0.7906976744186046 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.8023255813953488 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.7906976744186046 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.7906976744186046 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new ClosePath());
        CONNECTOR.getElements().add((Object)new MoveTo(0.7325581395348837 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.7441860465116279 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.7441860465116279 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.7325581395348837 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new ClosePath());
        CONNECTOR.getElements().add((Object)new MoveTo(0.6744186046511628 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.686046511627907 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.686046511627907 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.6744186046511628 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.6744186046511628 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new ClosePath());
        CONNECTOR.getElements().add((Object)new MoveTo(0.6162790697674418 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.627906976744186 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.6162790697674418 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.6162790697674418 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new ClosePath());
        CONNECTOR.getElements().add((Object)new MoveTo(0.5581395348837209 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.5697674418604651 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.5697674418604651 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.5581395348837209 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new ClosePath());
        CONNECTOR.getElements().add((Object)new MoveTo(0.5 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.5116279069767442 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.5116279069767442 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new ClosePath());
        CONNECTOR.getElements().add((Object)new MoveTo(0.4418604651162791 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.45348837209302323 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.4418604651162791 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.4418604651162791 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new ClosePath());
        CONNECTOR.getElements().add((Object)new MoveTo(0.38372093023255816 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.3953488372093023 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.3953488372093023 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.38372093023255816 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new ClosePath());
        CONNECTOR.getElements().add((Object)new MoveTo(0.32558139534883723 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.3372093023255814 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.3372093023255814 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.32558139534883723 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.32558139534883723 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new ClosePath());
        CONNECTOR.getElements().add((Object)new MoveTo(0.26744186046511625 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.27906976744186046 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.26744186046511625 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.26744186046511625 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new ClosePath());
        CONNECTOR.getElements().add((Object)new MoveTo(0.20930232558139536 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.22093023255813954 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.22093023255813954 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.9379310344827586 * HEIGHT));
        CONNECTOR.getElements().add((Object)new LineTo(0.20930232558139536 * WIDTH, 0.8689655172413793 * HEIGHT));
        CONNECTOR.getElements().add((Object)new ClosePath());
        CONNECTOR.setFill(null);
        CONNECTOR.setStroke((Paint)Color.color((double)0.35, (double)0.35, (double)0.35, (double)0.3));
        Path TUBE = new Path();
        TUBE.setFillRule(FillRule.EVEN_ODD);
        TUBE.getElements().add((Object)new MoveTo(0.0, 0.35172413793103446 * HEIGHT));
        TUBE.getElements().add((Object)new CubicCurveTo(0.0, 0.35172413793103446 * HEIGHT, 0.0, 0.8827586206896552 * HEIGHT, 0.0, 0.8827586206896552 * HEIGHT));
        TUBE.getElements().add((Object)new CubicCurveTo(0.0, 0.9448275862068966 * HEIGHT, 0.09302325581395349 * WIDTH, HEIGHT, 0.20930232558139536 * WIDTH, HEIGHT));
        TUBE.getElements().add((Object)new CubicCurveTo(0.20930232558139536 * WIDTH, HEIGHT, 0.8023255813953488 * WIDTH, HEIGHT, 0.8023255813953488 * WIDTH, HEIGHT));
        TUBE.getElements().add((Object)new CubicCurveTo(0.9069767441860465 * WIDTH, HEIGHT, WIDTH, 0.9448275862068966 * HEIGHT, WIDTH, 0.8827586206896552 * HEIGHT));
        TUBE.getElements().add((Object)new CubicCurveTo(WIDTH, 0.8827586206896552 * HEIGHT, WIDTH, 0.35172413793103446 * HEIGHT, WIDTH, 0.35172413793103446 * HEIGHT));
        TUBE.getElements().add((Object)new CubicCurveTo(WIDTH, 0.2 * HEIGHT, 0.813953488372093 * WIDTH, 0.07586206896551724 * HEIGHT, 0.5697674418604651 * WIDTH, 0.05517241379310345 * HEIGHT));
        TUBE.getElements().add((Object)new CubicCurveTo(0.5697674418604651 * WIDTH, 0.027586206896551724 * HEIGHT, 0.5348837209302325 * WIDTH, 0.0, 0.5 * WIDTH, 0.0));
        TUBE.getElements().add((Object)new CubicCurveTo(0.46511627906976744 * WIDTH, 0.0, 0.43023255813953487 * WIDTH, 0.027586206896551724 * HEIGHT, 0.43023255813953487 * WIDTH, 0.05517241379310345 * HEIGHT));
        TUBE.getElements().add((Object)new CubicCurveTo(0.18604651162790697 * WIDTH, 0.07586206896551724 * HEIGHT, 0.0, 0.2 * HEIGHT, 0.0, 0.35172413793103446 * HEIGHT));
        TUBE.getElements().add((Object)new ClosePath());
        LinearGradient TUBE_FILL = new LinearGradient(0.011627906976744186 * WIDTH, 0.5655172413793104 * HEIGHT, 0.9883720930232558 * WIDTH, 0.5655172413793104 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.6)), new Stop(0.06, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.4)), new Stop(0.07, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.3921568627)), new Stop(0.35, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.2)), new Stop(0.36, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.2)), new Stop(0.66, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.2)), new Stop(0.66010004, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.2)), new Stop(0.92, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.5098039216)), new Stop(1.0, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.6))});
        TUBE.setFill((Paint)TUBE_FILL);
        TUBE.setStroke(null);
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.setWidth(0.16744186046511628 * TUBE.getLayoutBounds().getWidth());
        INNER_SHADOW.setHeight(0.16744186046511628 * TUBE.getLayoutBounds().getHeight());
        INNER_SHADOW.setOffsetX(0.0);
        INNER_SHADOW.setOffsetY(0.0);
        INNER_SHADOW.setRadius(0.16744186046511628 * TUBE.getLayoutBounds().getWidth());
        INNER_SHADOW.setColor(Color.BLACK);
        INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        INNER_SHADOW.inputProperty().set(null);
        TUBE.setEffect((Effect)INNER_SHADOW);
        Rectangle HL_MIDDLE = new Rectangle(0.13953488372093023 * WIDTH, 0.2620689655172414 * HEIGHT, 0.7209302325581395 * WIDTH, 0.013793103448275862 * HEIGHT);
        HL_MIDDLE.setId("tube-hl-middle");
        Path HL_LEFT = new Path();
        HL_LEFT.setFillRule(FillRule.EVEN_ODD);
        HL_LEFT.getElements().add((Object)new MoveTo(0.18604651162790697 * WIDTH, 0.2689655172413793 * HEIGHT));
        HL_LEFT.getElements().add((Object)new CubicCurveTo(0.18604651162790697 * WIDTH, 0.2689655172413793 * HEIGHT, 0.09302325581395349 * WIDTH, 0.2689655172413793 * HEIGHT, 0.09302325581395349 * WIDTH, 0.2689655172413793 * HEIGHT));
        HL_LEFT.getElements().add((Object)new CubicCurveTo(0.046511627906976744 * WIDTH, 0.27586206896551724 * HEIGHT, 0.023255813953488372 * WIDTH, 0.2827586206896552 * HEIGHT, 0.023255813953488372 * WIDTH, 0.30344827586206896 * HEIGHT));
        HL_LEFT.getElements().add((Object)new CubicCurveTo(0.023255813953488372 * WIDTH, 0.3103448275862069 * HEIGHT, 0.023255813953488372 * WIDTH, 0.9103448275862069 * HEIGHT, 0.023255813953488372 * WIDTH, 0.9103448275862069 * HEIGHT));
        HL_LEFT.getElements().add((Object)new CubicCurveTo(0.023255813953488372 * WIDTH, 0.9241379310344827 * HEIGHT, 0.046511627906976744 * WIDTH, 0.9310344827586207 * HEIGHT, 0.046511627906976744 * WIDTH, 0.9310344827586207 * HEIGHT));
        HL_LEFT.getElements().add((Object)new CubicCurveTo(0.046511627906976744 * WIDTH, 0.9310344827586207 * HEIGHT, 0.13953488372093023 * WIDTH, 0.9310344827586207 * HEIGHT, 0.13953488372093023 * WIDTH, 0.9310344827586207 * HEIGHT));
        HL_LEFT.getElements().add((Object)new CubicCurveTo(0.16279069767441862 * WIDTH, 0.9310344827586207 * HEIGHT, 0.1744186046511628 * WIDTH, 0.9103448275862069 * HEIGHT, 0.1744186046511628 * WIDTH, 0.9103448275862069 * HEIGHT));
        HL_LEFT.getElements().add((Object)new CubicCurveTo(0.1744186046511628 * WIDTH, 0.9103448275862069 * HEIGHT, 0.1744186046511628 * WIDTH, 0.31724137931034485 * HEIGHT, 0.1744186046511628 * WIDTH, 0.31724137931034485 * HEIGHT));
        HL_LEFT.getElements().add((Object)new CubicCurveTo(0.1744186046511628 * WIDTH, 0.2896551724137931 * HEIGHT, 0.18604651162790697 * WIDTH, 0.2689655172413793 * HEIGHT, 0.18604651162790697 * WIDTH, 0.2689655172413793 * HEIGHT));
        HL_LEFT.getElements().add((Object)new ClosePath());
        HL_LEFT.setId("tube-hl-left");
        Path HL_RIGHT = new Path();
        HL_RIGHT.setFillRule(FillRule.EVEN_ODD);
        HL_RIGHT.getElements().add((Object)new MoveTo(0.8604651162790697 * WIDTH, 0.2689655172413793 * HEIGHT));
        HL_RIGHT.getElements().add((Object)new CubicCurveTo(0.8837209302325582 * WIDTH, 0.27586206896551724 * HEIGHT, 0.8953488372093024 * WIDTH, 0.2896551724137931 * HEIGHT, 0.8953488372093024 * WIDTH, 0.2896551724137931 * HEIGHT));
        HL_RIGHT.getElements().add((Object)new CubicCurveTo(0.8953488372093024 * WIDTH, 0.2896551724137931 * HEIGHT, 0.8953488372093024 * WIDTH, 0.9172413793103448 * HEIGHT, 0.8953488372093024 * WIDTH, 0.9172413793103448 * HEIGHT));
        HL_RIGHT.getElements().add((Object)new CubicCurveTo(0.8953488372093024 * WIDTH, 0.9241379310344827 * HEIGHT, 0.9302325581395349 * WIDTH, 0.9310344827586207 * HEIGHT, 0.9302325581395349 * WIDTH, 0.9310344827586207 * HEIGHT));
        HL_RIGHT.getElements().add((Object)new CubicCurveTo(0.9651162790697675 * WIDTH, 0.9310344827586207 * HEIGHT, 0.9651162790697675 * WIDTH, 0.9172413793103448 * HEIGHT, 0.9651162790697675 * WIDTH, 0.9172413793103448 * HEIGHT));
        HL_RIGHT.getElements().add((Object)new CubicCurveTo(0.9651162790697675 * WIDTH, 0.9172413793103448 * HEIGHT, 0.9651162790697675 * WIDTH, 0.2896551724137931 * HEIGHT, 0.9651162790697675 * WIDTH, 0.2896551724137931 * HEIGHT));
        HL_RIGHT.getElements().add((Object)new CubicCurveTo(0.9651162790697675 * WIDTH, 0.27586206896551724 * HEIGHT, 0.9302325581395349 * WIDTH, 0.2689655172413793 * HEIGHT, 0.9302325581395349 * WIDTH, 0.2689655172413793 * HEIGHT));
        HL_RIGHT.getElements().add((Object)new CubicCurveTo(0.9302325581395349 * WIDTH, 0.2689655172413793 * HEIGHT, 0.8604651162790697 * WIDTH, 0.2689655172413793 * HEIGHT, 0.8604651162790697 * WIDTH, 0.2689655172413793 * HEIGHT));
        HL_RIGHT.getElements().add((Object)new ClosePath());
        HL_RIGHT.setId("tube-hl-right");
        Ellipse HL_UPPER = new Ellipse(0.5 * WIDTH, 0.1482758620689655 * HEIGHT, 0.3023255813953488 * WIDTH, 0.07241379310344828 * HEIGHT);
        HL_UPPER.setId("tube-hl-upper");
        Ellipse HL_TOP = new Ellipse(0.47674418604651164 * WIDTH, 0.04482758620689655 * HEIGHT, 0.03488372093023256 * WIDTH, 0.02413793103448276 * HEIGHT);
        HL_TOP.setId("tube-hl-top");
        this.leftLight = new Rectangle(0.0, 0.32413793103448274 * HEIGHT, 0.011627906976744186 * WIDTH, 0.5793103448275863 * HEIGHT);
        LinearGradient LEFTLIGHT_FILL = new LinearGradient(0.011627906976744186 * WIDTH, 0.32413793103448274 * HEIGHT, 0.011627906976744245 * WIDTH, 0.903448275862069 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)this.control.getGlowColor().getRed(), (double)this.control.getGlowColor().getGreen(), (double)this.control.getGlowColor().getBlue(), (double)0.1)), new Stop(0.5, Color.color((double)this.control.getGlowColor().getRed(), (double)this.control.getGlowColor().getGreen(), (double)this.control.getGlowColor().getBlue(), (double)0.4)), new Stop(1.0, Color.color((double)this.control.getGlowColor().getRed(), (double)this.control.getGlowColor().getGreen(), (double)this.control.getGlowColor().getBlue(), (double)0.1))});
        this.leftLight.setFill((Paint)LEFTLIGHT_FILL);
        this.leftLight.setStroke(null);
        this.rightLight = new Rectangle(0.9883720930232558 * WIDTH, 0.32413793103448274 * HEIGHT, 0.011627906976744186 * WIDTH, 0.5793103448275863 * HEIGHT);
        LinearGradient RIGHTLIGHT_FILL = new LinearGradient(WIDTH, 0.32413793103448274 * HEIGHT, WIDTH, 0.903448275862069 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)this.control.getGlowColor().getRed(), (double)this.control.getGlowColor().getGreen(), (double)this.control.getGlowColor().getBlue(), (double)0.1)), new Stop(0.5, Color.color((double)this.control.getGlowColor().getRed(), (double)this.control.getGlowColor().getGreen(), (double)this.control.getGlowColor().getBlue(), (double)0.4)), new Stop(1.0, Color.color((double)this.control.getGlowColor().getRed(), (double)this.control.getGlowColor().getGreen(), (double)this.control.getGlowColor().getBlue(), (double)0.1))});
        this.rightLight.setFill((Paint)RIGHTLIGHT_FILL);
        this.rightLight.setStroke(null);
        foreground2.getChildren().addAll((Object[])new Node[]{CONNECTOR, TUBE, HL_MIDDLE, HL_LEFT, HL_RIGHT, HL_UPPER, HL_TOP, this.leftLight, this.rightLight});
        foreground2.setCache(true);
    }
}

