/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import javafx.animation.AnimationTimer;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import jfxtras.labs.internal.scene.control.behavior.LedBehavior;
import jfxtras.labs.scene.control.gauge.Led;
import jfxtras.labs.scene.control.gauge.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LedSkin
extends SkinBase<Led, LedBehavior> {
    public static final long BLINK_INTERVAL = 500000000L;
    private Led control;
    private boolean isDirty;
    private boolean initialized;
    private Group led;
    private Shape ledOn;
    private boolean on;
    private AnimationTimer timer;
    private long lastTimerCall;

    public LedSkin(Led CONTROL) {
        super((Control)CONTROL, (BehaviorBase)new LedBehavior(CONTROL));
        this.control = CONTROL;
        this.initialized = false;
        this.isDirty = false;
        this.led = new Group();
        this.timer = new AnimationTimer(){

            public void handle(long l) {
                long currentNanoTime = System.nanoTime();
                if (currentNanoTime > LedSkin.this.lastTimerCall + 500000000L) {
                    LedSkin.this.on = (byte)(LedSkin.this.on ^ 1);
                    LedSkin.this.ledOn.setVisible(LedSkin.this.on);
                    LedSkin.this.lastTimerCall = currentNanoTime;
                }
            }
        };
        this.lastTimerCall = 0L;
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 | this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(16.0, 16.0);
        }
        this.control.prefWidthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                LedSkin.this.isDirty = true;
            }
        });
        this.control.prefHeightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                LedSkin.this.isDirty = true;
            }
        });
        this.registerChangeListener((ObservableValue)this.control.onProperty(), "ON");
        this.registerChangeListener((ObservableValue)this.control.blinkingProperty(), "BLINKING");
        if (this.control.isBlinking()) {
            this.timer.start();
        }
        this.initialized = true;
        this.paint();
    }

    public final void paint() {
        if (!this.initialized) {
            this.init();
        }
        this.getChildren().clear();
        this.drawLed();
        this.getChildren().addAll((Object[])new Node[]{this.led});
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if (PROPERTY == "ON") {
            this.ledOn.setVisible(this.control.isOn());
        } else if (PROPERTY == "BLINKING") {
            if (this.control.isBlinking()) {
                this.timer.start();
            } else {
                this.timer.stop();
                this.ledOn.setVisible(false);
            }
        }
    }

    public void layoutChildren() {
        if (this.isDirty) {
            this.paint();
            this.isDirty = false;
        }
        super.layoutChildren();
    }

    public final Led getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    protected double computePrefWidth(double PREF_WIDTH) {
        double prefWidth = 20.0;
        if (PREF_WIDTH != -1.0) {
            prefWidth = Math.max(0.0, PREF_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    protected double computePrefHeight(double PREF_HEIGHT) {
        double prefHeight = 20.0;
        if (PREF_HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, PREF_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefWidth(prefHeight);
    }

    public final void drawLed() {
        Circle HIGHLIGHT;
        Circle LED_OFF;
        Circle LED_FRAME;
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        this.led.setStyle("-fx-led: " + Util.INSTANCE.createCssColor(this.control.getColor()));
        this.led.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.led.getChildren().add((Object)IBOUNDS);
        switch (this.control.getType()) {
            case SQUARE: {
                LED_FRAME = new Rectangle(0.0625 * WIDTH, 0.0625 * HEIGHT, 0.875 * WIDTH, 0.875 * HEIGHT);
                LED_OFF = new Rectangle(0.1875 * WIDTH, 0.1875 * HEIGHT, 0.625 * WIDTH, 0.625 * HEIGHT);
                this.ledOn = new Rectangle(0.1875 * WIDTH, 0.1875 * HEIGHT, 0.625 * WIDTH, 0.625 * HEIGHT);
                HIGHLIGHT = new Rectangle(0.25 * WIDTH, 0.25 * HEIGHT, 0.5 * WIDTH, 0.1875 * HEIGHT);
                break;
            }
            case VERTICAL: {
                LED_FRAME = new Rectangle(0.25 * WIDTH, 0.0625 * HEIGHT, 0.5 * WIDTH, 0.875 * HEIGHT);
                LED_OFF = new Rectangle(0.3125 * WIDTH, 0.125 * HEIGHT, 0.375 * WIDTH, 0.75 * HEIGHT);
                this.ledOn = new Rectangle(0.3125 * WIDTH, 0.125 * HEIGHT, 0.375 * WIDTH, 0.75 * HEIGHT);
                HIGHLIGHT = new Rectangle(0.3125 * WIDTH, 0.125 * HEIGHT, 0.375 * WIDTH, 0.375 * HEIGHT);
                break;
            }
            case HORIZONTAL: {
                LED_FRAME = new Rectangle(0.0625 * WIDTH, 0.25 * HEIGHT, 0.875 * WIDTH, 0.5 * HEIGHT);
                LED_OFF = new Rectangle(0.125 * WIDTH, 0.3125 * HEIGHT, 0.75 * WIDTH, 0.375 * HEIGHT);
                this.ledOn = new Rectangle(0.125 * WIDTH, 0.3125 * HEIGHT, 0.75 * WIDTH, 0.375 * HEIGHT);
                HIGHLIGHT = new Rectangle(0.125 * WIDTH, 0.3125 * HEIGHT, 0.75 * WIDTH, 0.1875 * HEIGHT);
                break;
            }
            default: {
                LED_FRAME = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.4375 * WIDTH);
                LED_OFF = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.3125 * WIDTH);
                this.ledOn = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.3125 * WIDTH);
                HIGHLIGHT = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.2 * WIDTH);
            }
        }
        LED_FRAME.setId("fx-led-frame");
        LED_FRAME.setStroke(null);
        LED_OFF.setId("fx-led-off");
        LED_OFF.setStroke(null);
        this.ledOn.setId("fx-led-on");
        this.ledOn.setStroke(null);
        this.ledOn.setVisible(this.control.isOn());
        HIGHLIGHT.setId("fx-led-highlight");
        HIGHLIGHT.setStroke(null);
        if (!LED_FRAME.visibleProperty().isBound()) {
            LED_FRAME.visibleProperty().bind((ObservableValue)this.control.frameVisibleProperty());
        }
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.setWidth(0.18 * SIZE);
        INNER_SHADOW.setHeight(0.18 * SIZE);
        INNER_SHADOW.setRadius(0.15 * SIZE);
        INNER_SHADOW.setColor(Color.BLACK);
        INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        INNER_SHADOW.inputProperty().set(null);
        LED_OFF.setEffect((Effect)INNER_SHADOW);
        DropShadow GLOW = new DropShadow();
        GLOW.setSpread(0.35);
        GLOW.setRadius(0.16 * this.ledOn.getLayoutBounds().getWidth());
        GLOW.setColor(this.control.getColor());
        GLOW.setBlurType(BlurType.GAUSSIAN);
        GLOW.inputProperty().set((Object)INNER_SHADOW);
        this.ledOn.setEffect((Effect)GLOW);
        this.led.getChildren().addAll((Object[])new Node[]{LED_FRAME, LED_OFF, this.ledOn, HIGHLIGHT});
        this.led.setCache(true);
    }
}

