/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javafx.animation.AnimationTimer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import jfxtras.labs.internal.scene.control.behavior.ClockBehavior;
import jfxtras.labs.scene.control.gauge.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClockSkin
extends SkinBase<Clock, ClockBehavior> {
    private static final long INTERVAL = 50000000L;
    private static final Calendar CAL = Calendar.getInstance();
    private Clock control;
    private int dst;
    private Group hourPointer;
    private Group minutePointer;
    private Group secondPointer;
    private Group clock;
    private DoubleProperty hourAngle;
    private DoubleProperty minuteAngle;
    private DoubleProperty secondAngle;
    private int hourOffset;
    private int minuteOffset;
    private int lastHour;
    private long lastTimerCall;
    private boolean isDay;
    private AnimationTimer timer;
    private boolean isDirty;
    private boolean initialized;

    public ClockSkin(Clock CONTROL) {
        super((Control)CONTROL, (BehaviorBase)new ClockBehavior(CONTROL));
        this.control = CONTROL;
        CAL.setTimeZone(TimeZone.getTimeZone(this.control.getTimeZone()));
        this.dst = this.control.isDaylightSavingTime() ? 1 : 0;
        this.hourPointer = new Group();
        this.minutePointer = new Group();
        this.secondPointer = new Group();
        this.clock = new Group();
        this.hourAngle = new SimpleDoubleProperty((double)(30 * Calendar.getInstance().get(10) + this.dst));
        this.minuteAngle = new SimpleDoubleProperty((double)(6 * Calendar.getInstance().get(12)));
        this.secondAngle = new SimpleDoubleProperty((double)(6 * Calendar.getInstance().get(13)));
        this.hourOffset = CAL.get(11) - Calendar.getInstance().get(11);
        this.minuteOffset = CAL.get(12) - Calendar.getInstance().get(12);
        this.lastHour = CAL.get(11);
        this.lastTimerCall = 0L;
        this.isDay = true;
        this.timer = new AnimationTimer(){

            public void handle(long l) {
                long currentNanoTime = System.nanoTime();
                if (currentNanoTime >= ClockSkin.this.lastTimerCall + 50000000L) {
                    CAL.setTimeZone(TimeZone.getTimeZone(ClockSkin.this.control.getTimeZone()));
                    if (CAL.get(11) < ClockSkin.this.lastHour) {
                        ClockSkin.this.checkForNight();
                        ClockSkin.this.paint();
                    }
                    ClockSkin.this.secondAngle.set((double)(Calendar.getInstance().get(13) * 6) + (double)Calendar.getInstance().get(14) * 0.006);
                    ClockSkin.this.minuteAngle.set((double)((ClockSkin.this.minuteOffset + Calendar.getInstance().get(12)) * 6));
                    ClockSkin.this.hourAngle.set((double)((ClockSkin.this.hourOffset + Calendar.getInstance().get(10)) * 30) + 0.5 * (double)Calendar.getInstance().get(12));
                    ClockSkin.this.lastTimerCall = currentNanoTime;
                    ClockSkin.this.lastHour = CAL.get(11);
                }
            }
        };
        this.isDirty = false;
        this.initialized = false;
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 | this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(200.0, 200.0);
        }
        this.control.prefWidthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                ClockSkin.this.isDirty = true;
            }
        });
        this.control.prefHeightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                ClockSkin.this.isDirty = true;
            }
        });
        if (this.secondPointer.visibleProperty().isBound()) {
            this.secondPointer.visibleProperty().unbind();
        }
        this.secondPointer.visibleProperty().bind((ObservableValue)this.control.secondPointerVisibleProperty());
        this.registerChangeListener((ObservableValue)this.control.runningProperty(), "RUNNING");
        this.registerChangeListener((ObservableValue)this.control.timeZoneProperty(), "TIME_ZONE");
        this.registerChangeListener((ObservableValue)this.secondAngle, "SECOND");
        this.registerChangeListener((ObservableValue)this.minuteAngle, "MINUTE");
        this.registerChangeListener((ObservableValue)this.hourAngle, "HOUR");
        this.setTime();
        this.initialized = true;
        this.paint();
        if (this.control.isRunning()) {
            this.timer.start();
        }
    }

    public final void paint() {
        if (!this.initialized) {
            this.init();
        }
        this.getChildren().clear();
        this.drawClock();
        this.drawMinutePointer();
        this.drawHourPointer();
        this.drawSecondPointer();
        this.getChildren().addAll((Object[])new Node[]{this.clock, this.minutePointer, this.hourPointer, this.secondPointer});
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if (PROPERTY == "TIME_ZONE") {
            this.setTime();
        } else if (PROPERTY == "RUNNING") {
            if (this.control.isRunning()) {
                this.setTime();
                this.timer.start();
            } else {
                this.timer.stop();
            }
        } else if (PROPERTY == "SECOND") {
            this.secondPointer.setRotate(this.secondAngle.get());
        } else if (PROPERTY == "MINUTE") {
            this.minutePointer.setRotate(this.minuteAngle.get());
        } else if (PROPERTY == "HOUR") {
            this.hourPointer.setRotate(this.hourAngle.get());
        }
    }

    public void layoutChildren() {
        if (this.isDirty) {
            this.paint();
            this.isDirty = false;
        }
        super.layoutChildren();
    }

    public final Clock getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    protected double computePrefWidth(double PREF_WIDTH) {
        double prefWidth = 127.0;
        if (PREF_WIDTH != -1.0) {
            prefWidth = Math.max(0.0, PREF_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    protected double computePrefHeight(double PREF_HEIGHT) {
        double prefHeight = 127.0;
        if (PREF_HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, PREF_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefWidth(prefHeight);
    }

    private void setTime() {
        CAL.setTimeZone(TimeZone.getTimeZone(this.control.getTimeZone()));
        this.dst = this.control.isDaylightSavingTime() ? 1 : 0;
        int localDst = Calendar.getInstance().getTimeZone().inDaylightTime(new Date()) ? 1 : 0;
        this.hourOffset = CAL.get(11) + this.dst - Calendar.getInstance().get(11) + localDst;
        this.minuteOffset = CAL.get(12) - Calendar.getInstance().get(12);
        this.secondAngle.set((double)(Calendar.getInstance().get(13) * 6) + (double)Calendar.getInstance().get(14) * 0.006);
        this.minuteAngle.set((double)((this.minuteOffset + Calendar.getInstance().get(12)) * 6));
        this.hourAngle.set((double)((this.hourOffset + Calendar.getInstance().get(10)) * 30) + 0.5 * (double)Calendar.getInstance().get(12));
        this.checkForNight();
    }

    private void checkForNight() {
        this.isDay = this.control.isAutoDimEnabled() ? CAL.get(11) > 6 && CAL.get(11) < 18 : true;
    }

    public void drawClock() {
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        this.clock.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.clock.getChildren().add((Object)IBOUNDS);
        Circle FRAME = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.5 * WIDTH);
        FRAME.setId("clock-frame-fill");
        FRAME.setStroke(null);
        Circle BACKGROUND = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.4921259842519685 * WIDTH);
        if (this.isDay) {
            BACKGROUND.setId("clock-bright-background-fill");
        } else {
            BACKGROUND.setId("clock-dark-background-fill");
        }
        BACKGROUND.setStroke(null);
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.setWidth(0.08503937007874016 * BACKGROUND.getLayoutBounds().getWidth());
        INNER_SHADOW.setHeight(0.08503937007874016 * BACKGROUND.getLayoutBounds().getHeight());
        INNER_SHADOW.setOffsetX(1.157146581871515E-18 * SIZE);
        INNER_SHADOW.setOffsetY(0.01889763779527559 * SIZE);
        INNER_SHADOW.setRadius(0.08503937007874016 * BACKGROUND.getLayoutBounds().getWidth());
        INNER_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.4980392157));
        INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        INNER_SHADOW.inputProperty().set(null);
        BACKGROUND.setEffect((Effect)INNER_SHADOW);
        Group TICK_MARKS = new Group();
        for (int angle = 0; angle < 360; angle += 6) {
            Rotate TRANSFORM = Transform.rotate((double)angle, (double)(SIZE / 2.0), (double)(SIZE / 2.0));
            Rectangle TICK = angle % 30 == 0 ? new Rectangle(0.48031496062992124 * WIDTH, 0.023622047244094488 * HEIGHT, 0.03937007874015748 * WIDTH, 0.14960629921259844 * HEIGHT) : new Rectangle(0.4881889763779528 * WIDTH, 0.023622047244094488 * HEIGHT, 0.023622047244094488 * WIDTH, 0.047244094488188976 * HEIGHT);
            if (this.isDay) {
                TICK.setId("clock-bright-foreground-fill");
            } else {
                TICK.setId("clock-dark-foreground-fill");
            }
            TICK.setStroke(null);
            TICK.getTransforms().add((Object)TRANSFORM);
            TICK_MARKS.getChildren().add((Object)TICK);
        }
        this.clock.getChildren().addAll((Object[])new Node[]{FRAME, BACKGROUND, TICK_MARKS});
        this.clock.setCache(true);
    }

    public void drawMinutePointer() {
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        this.minutePointer.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.minutePointer.getChildren().add((Object)IBOUNDS);
        Rectangle MINUTE = new Rectangle(0.48031496062992124 * WIDTH, 0.047244094488188976 * HEIGHT, 0.03937007874015748 * WIDTH, 0.47244094488188976 * HEIGHT);
        if (this.isDay) {
            MINUTE.setId("clock-bright-foreground-fill");
        } else {
            MINUTE.setId("clock-dark-foreground-fill");
        }
        MINUTE.setStroke(null);
        DropShadow DROP_SHADOW = new DropShadow();
        DROP_SHADOW.setWidth(2.0);
        DROP_SHADOW.setHeight(2.0);
        DROP_SHADOW.setOffsetX(0.0);
        DROP_SHADOW.setOffsetY(0.0);
        DROP_SHADOW.setRadius(2.0);
        DROP_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.65));
        DROP_SHADOW.setBlurType(BlurType.GAUSSIAN);
        DROP_SHADOW.inputProperty().set(null);
        MINUTE.setEffect((Effect)DROP_SHADOW);
        this.minutePointer.setRotate(this.minuteAngle.get());
        this.minutePointer.getChildren().add((Object)MINUTE);
        this.minutePointer.setCache(true);
    }

    public void drawHourPointer() {
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        this.hourPointer.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.hourPointer.getChildren().add((Object)IBOUNDS);
        Rectangle HOUR = new Rectangle(0.47244094488188976 * WIDTH, 0.2125984251968504 * HEIGHT, 0.05511811023622047 * WIDTH, 0.2992125984251969 * HEIGHT);
        if (this.isDay) {
            HOUR.setId("clock-bright-foreground-fill");
        } else {
            HOUR.setId("clock-dark-foreground-fill");
        }
        HOUR.setStroke(null);
        DropShadow DROP_SHADOW = new DropShadow();
        DROP_SHADOW.setWidth(2.0);
        DROP_SHADOW.setHeight(2.0);
        DROP_SHADOW.setOffsetX(0.0);
        DROP_SHADOW.setOffsetY(0.0);
        DROP_SHADOW.setRadius(2.0);
        DROP_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.65));
        DROP_SHADOW.setBlurType(BlurType.GAUSSIAN);
        DROP_SHADOW.inputProperty().set(null);
        HOUR.setEffect((Effect)DROP_SHADOW);
        this.hourPointer.setRotate(this.hourAngle.get());
        this.hourPointer.getChildren().add((Object)HOUR);
        this.hourPointer.setCache(true);
    }

    public void drawSecondPointer() {
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        this.secondPointer.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.secondPointer.getChildren().add((Object)IBOUNDS);
        Circle OUTER_CIRCLE = new Circle(SIZE * 0.5, SIZE * 0.190909091, SIZE * 0.0454545454);
        Circle INNER_CIRCLE = new Circle(SIZE * 0.5, SIZE * 0.190909091, SIZE * 0.0363636364);
        Path second = (Path)Path.subtract((Shape)OUTER_CIRCLE, (Shape)INNER_CIRCLE);
        second.getElements().add((Object)new MoveTo(WIDTH * 0.4863636364, SIZE * 0.5));
        second.getElements().add((Object)new LineTo(WIDTH * 0.5136363636, SIZE * 0.5));
        second.getElements().add((Object)new LineTo(WIDTH * 0.5045454545, WIDTH * 0.0363636364));
        second.getElements().add((Object)new LineTo(WIDTH * 0.4954545455, WIDTH * 0.0363636364));
        second.getElements().add((Object)new ClosePath());
        second = (Path)Path.subtract((Shape)second, (Shape)new Circle(SIZE * 0.5, SIZE * 0.190909091, SIZE * 0.0363636364));
        second.setFill((Paint)Color.rgb((int)237, (int)0, (int)58));
        second.setStroke(null);
        DropShadow DROP_SHADOW = new DropShadow();
        DROP_SHADOW.setWidth(2.0);
        DROP_SHADOW.setHeight(2.0);
        DROP_SHADOW.setOffsetX(0.0);
        DROP_SHADOW.setOffsetY(0.0);
        DROP_SHADOW.setRadius(2.0);
        DROP_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.65));
        DROP_SHADOW.setBlurType(BlurType.GAUSSIAN);
        second.setEffect((Effect)DROP_SHADOW);
        Circle CENTER_KNOB = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.051181102362204724 * WIDTH);
        if (this.isDay) {
            CENTER_KNOB.setId("clock-bright-foreground-fill");
        } else {
            CENTER_KNOB.setId("clock-dark-foreground-fill");
        }
        CENTER_KNOB.setStroke(null);
        this.secondPointer.setRotate(this.secondAngle.get());
        this.secondPointer.getChildren().addAll((Object[])new Node[]{second, CENTER_KNOB});
        this.secondPointer.setCache(true);
    }
}

