/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.cli.shell.command;

import griffon.util.BuildSettings;
import griffon.util.BuildSettingsHolder;
import griffon.util.GriffonNameUtils;
import griffon.util.Metadata;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.runtime.CommandProcessorImpl;
import org.apache.felix.service.command.CommandSession;
import org.codehaus.griffon.cli.GriffonScriptRunner;
import org.codehaus.griffon.cli.shell.CommandProcessorImplHolder;
import org.codehaus.griffon.cli.shell.support.CommandUtils;
import org.codehaus.griffon.cli.shell.support.GriffonCommandFactory;
import org.codehaus.griffon.plugins.PluginInfo;

@Command(scope="shell", name="reload-commands", description="Reloads the list of available commands")
public class ReloadCommandsCommand
implements Action {
    private static final String[] FORBIDDEN_NAMES = new String[]{"exit", "help", "info", "reload-commands", "create-app", "create-plugin", "create-archetype", "create-addon", "init", "interactive"};

    public static void reload() {
        CommandProcessorImpl commandProcessor = CommandProcessorImplHolder.getCommandProcessor();
        LinkedHashSet<String[]> commandsToRemove = new LinkedHashSet<String[]>();
        for (String commandName : commandProcessor.getCommands()) {
            String[] tmp = commandName.split(":");
            if ("shell".equalsIgnoreCase(tmp[0])) continue;
            commandsToRemove.add(tmp);
        }
        for (String[] command : commandsToRemove) {
            commandProcessor.removeCommand(command[0], command[1]);
        }
        BuildSettings buildSettings = BuildSettingsHolder.getSettings();
        ReloadCommandsCommand.addCommandScripts("griffon", new File(buildSettings.getGriffonHome(), "scripts"), commandProcessor);
        ReloadCommandsCommand.addCommandScripts("global", new File(buildSettings.getUserHome(), ".griffon/scripts"), commandProcessor);
        boolean isPluginProject = buildSettings.isPluginProject() != null;
        String scope = isPluginProject ? Metadata.getCurrent().getApplicationName() : "app";
        ReloadCommandsCommand.addCommandScripts(scope, new File(buildSettings.getBaseDir(), "scripts"), commandProcessor);
        for (PluginInfo pluginInfo : buildSettings.pluginSettings.getPlugins().values()) {
            String name = pluginInfo.getName();
            try {
                File path = pluginInfo.getDirectory().getFile();
                ReloadCommandsCommand.addCommandScripts(name, new File(path, "scripts"), commandProcessor);
            }
            catch (IOException e) {}
        }
    }

    public Object execute(CommandSession session) throws Exception {
        CommandUtils.clearCaches();
        ReloadCommandsCommand.reload();
        return null;
    }

    private static void addCommandScripts(String scope, File dir, CommandProcessorImpl commandProcessor) {
        if (dir.exists()) {
            for (File file : dir.listFiles()) {
                String commandName;
                if (!GriffonScriptRunner.isCommandScript((File)file) || Arrays.binarySearch(FORBIDDEN_NAMES, commandName = GriffonNameUtils.getHyphenatedName((String)GriffonScriptRunner.getScriptNameFromFile((File)file))) >= 0) continue;
                GriffonCommandFactory function = new GriffonCommandFactory(scope, commandName, file);
                commandProcessor.addCommand(scope, (Object)function, commandName);
            }
        }
    }

    static {
        Arrays.sort(FORBIDDEN_NAMES);
    }
}

