/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.filter.context.BaseFilterContext;
import org.radeox.filter.context.FilterContext;
import org.radeox.macro.LocalePreserved;
import org.radeox.macro.code.SourceCodeFormatter;
import org.radeox.macro.parameter.MacroParameter;
import org.radeox.util.Service;

public class CodeMacro
extends LocalePreserved {
    private static Log log = LogFactory.getLog(CodeMacro.class);
    private Map formatters;
    private FilterContext nullContext = new BaseFilterContext();
    private String outerStart;
    private String innerStart;
    private String titleStart;
    private String titleEnd;
    private String end;

    @Override
    public String getLocaleKey() {
        return "macro.code";
    }

    @Override
    public void setInitialContext(InitialRenderContext initialRenderContext) {
        super.setInitialContext(initialRenderContext);
        Locale locale = (Locale)initialRenderContext.get("RenderContext.output_locale");
        String string = (String)initialRenderContext.get("RenderContext.output_bundle_name");
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
        this.outerStart = resourceBundle.getString(this.getLocaleKey() + ".outer.start");
        this.innerStart = resourceBundle.getString(this.getLocaleKey() + ".inner.start");
        this.end = resourceBundle.getString(this.getLocaleKey() + ".end");
        this.titleStart = resourceBundle.getString(this.getLocaleKey() + ".title.start");
        this.titleEnd = resourceBundle.getString(this.getLocaleKey() + ".title.end");
    }

    public CodeMacro() {
        this.formatters = new HashMap();
        Iterator iterator = Service.providers(SourceCodeFormatter.class);
        while (iterator.hasNext()) {
            try {
                SourceCodeFormatter sourceCodeFormatter = (SourceCodeFormatter)iterator.next();
                String string = sourceCodeFormatter.getName();
                if (this.formatters.containsKey(string)) {
                    SourceCodeFormatter sourceCodeFormatter2 = (SourceCodeFormatter)this.formatters.get(string);
                    if (sourceCodeFormatter2.getPriority() >= sourceCodeFormatter.getPriority()) continue;
                    this.formatters.put(string, sourceCodeFormatter);
                    log.debug((Object)("Replacing formatter: " + sourceCodeFormatter.getClass() + " (" + string + ")"));
                    continue;
                }
                this.formatters.put(string, sourceCodeFormatter);
                log.debug((Object)("Loaded formatter: " + sourceCodeFormatter.getClass() + " (" + string + ")"));
            }
            catch (Exception exception) {
                log.warn((Object)"CodeMacro: unable to load code formatter", (Throwable)exception);
            }
        }
        this.addSpecial('[');
        this.addSpecial(']');
        this.addSpecial('{');
        this.addSpecial('}');
        this.addSpecial('*');
        this.addSpecial('-');
        this.addSpecial('#');
        this.addSpecial('\\');
    }

    @Override
    public void execute(Writer writer, MacroParameter macroParameter) throws IllegalArgumentException, IOException {
        SourceCodeFormatter sourceCodeFormatter = null;
        if (macroParameter.getLength() == 0 || !this.formatters.containsKey(macroParameter.get("0"))) {
            sourceCodeFormatter = (SourceCodeFormatter)this.formatters.get(this.initialContext.get("RenderContext.default_formatter"));
            if (null == sourceCodeFormatter) {
                log.warn((Object)"Formatter not found.");
                sourceCodeFormatter = (SourceCodeFormatter)this.formatters.get("java");
            }
        } else {
            sourceCodeFormatter = (SourceCodeFormatter)this.formatters.get(macroParameter.get("0"));
        }
        String string = sourceCodeFormatter.filter(macroParameter.getContent(), this.nullContext);
        writer.write(this.outerStart);
        if (macroParameter.get("title") != null) {
            writer.write(this.titleStart);
            writer.write(macroParameter.get("title"));
            writer.write(this.titleEnd);
        }
        writer.write(this.innerStart);
        writer.write(this.replace(string.trim()));
        writer.write(this.end);
    }
}

