/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter.regex;

import java.util.Locale;
import java.util.ResourceBundle;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.filter.regex.RegexTokenFilter;

public abstract class LocaleRegexTokenFilter
extends RegexTokenFilter {
    protected ResourceBundle inputMessages;
    protected ResourceBundle outputMessages;
    private String modifier;

    public void setModifier(String string) {
        this.modifier = string;
    }

    public String getModifier() {
        return this.modifier;
    }

    protected boolean isSingleLine() {
        return false;
    }

    protected ResourceBundle getInputBundle() {
        Locale locale = (Locale)this.initialContext.get("RenderContext.input_locale");
        String string = (String)this.initialContext.get("RenderContext.input_bundle_name");
        return ResourceBundle.getBundle(string, locale);
    }

    protected ResourceBundle getOutputBundle() {
        Locale locale = (Locale)this.initialContext.get("RenderContext.output_locale");
        String string = (String)this.initialContext.get("RenderContext.output_bundle_name");
        return ResourceBundle.getBundle(string, locale);
    }

    @Override
    public void setInitialContext(InitialRenderContext initialRenderContext) {
        super.setInitialContext(initialRenderContext);
        this.clearRegex();
        this.outputMessages = this.getOutputBundle();
        this.inputMessages = this.getInputBundle();
        String string = this.inputMessages.getString(this.getLocaleKey() + (this.modifier != null ? "." + this.modifier : "") + ".match");
        this.addRegex(string, "", !this.isSingleLine());
    }

    protected abstract String getLocaleKey();
}

