/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.api.engine.context.RenderContext;
import org.radeox.engine.context.BaseInitialRenderContext;
import org.radeox.filter.CacheFilter;
import org.radeox.filter.Filter;
import org.radeox.filter.context.FilterContext;

public class FilterPipe {
    private static Log log = LogFactory.getLog(FilterPipe.class);
    public static final String FIRST_IN_PIPE = "all";
    public static final String LAST_IN_PIPE = "none";
    public static final String[] EMPTY_BEFORE = new String[0];
    public static final String[] NO_REPLACES = new String[0];
    public static final String[] FIRST_BEFORE = new String[]{"all"};
    private InitialRenderContext initialContext;
    private List activeFilters = new ArrayList();
    private Set inactiveFilters = new HashSet();

    public FilterPipe() {
        this(new BaseInitialRenderContext());
    }

    public FilterPipe(InitialRenderContext initialRenderContext) {
        this.initialContext = initialRenderContext;
    }

    public void init() {
        for (Filter filter : new ArrayList(this.activeFilters)) {
            String[] stringArray = filter.replaces();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                this.removeFilter(string);
            }
        }
    }

    public void removeFilter(String string) {
        Iterator iterator = this.activeFilters.iterator();
        while (iterator.hasNext()) {
            Filter filter = (Filter)iterator.next();
            if (!filter.getClass().getName().equals(string)) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateFilter(String string) {
        Set set = this.inactiveFilters;
        synchronized (set) {
            for (Filter filter : this.inactiveFilters) {
                if (!filter.getClass().getName().startsWith(string)) continue;
                this.inactiveFilters.remove(filter);
            }
        }
    }

    public void deactivateFilter(String string) {
        for (Filter filter : this.activeFilters) {
            if (!filter.getClass().getName().startsWith(string)) continue;
            this.inactiveFilters.add(filter);
        }
    }

    public List getAllFilters() {
        return new ArrayList(this.activeFilters);
    }

    public List getInactiveFilters() {
        return new ArrayList(this.inactiveFilters);
    }

    public void addFilter(Filter filter) {
        filter.setInitialContext(this.initialContext);
        int n = Integer.MAX_VALUE;
        String[] stringArray = filter.before();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n2 = FilterPipe.index(this.activeFilters, string);
            if (n2 >= n) continue;
            n = n2;
        }
        if (n == Integer.MAX_VALUE) {
            n = -1;
        }
        if (FilterPipe.contains(filter.before(), FIRST_IN_PIPE)) {
            this.activeFilters.add(0, filter);
        } else if (n != -1) {
            this.activeFilters.add(n, filter);
        } else {
            this.activeFilters.add(filter);
        }
    }

    public int index(String string) {
        return FilterPipe.index(this.activeFilters, string);
    }

    public static int index(List list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i).getClass().getName())) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(Object[] objectArray, Object object) {
        return Arrays.binarySearch(objectArray, object) != -1;
    }

    public String filter(String string, FilterContext filterContext) {
        String string2 = string;
        Iterator iterator = this.activeFilters.iterator();
        RenderContext renderContext = filterContext.getRenderContext();
        while (iterator.hasNext()) {
            Filter filter = (Filter)iterator.next();
            if (this.inactiveFilters.contains(filter)) continue;
            try {
                if (filter instanceof CacheFilter) {
                    renderContext.setCacheable(true);
                } else {
                    renderContext.setCacheable(false);
                }
                String string3 = filter.filter(string2, filterContext);
                if (string2.equals(string3)) {
                    renderContext.setCacheable(true);
                }
                if (null == string3) {
                    log.warn((Object)("FilterPipe.filter: error while filtering: " + filter));
                } else {
                    string2 = string3;
                }
                renderContext.commitCache();
            }
            catch (Exception exception) {
                log.warn((Object)("Filtering exception: " + filter), (Throwable)exception);
            }
        }
        return string2;
    }

    public Filter getFilter(int n) {
        return (Filter)this.activeFilters.get(n);
    }
}

