/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.example;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.radeox.api.engine.RenderEngine;
import org.radeox.api.engine.context.RenderContext;
import org.radeox.engine.BaseRenderEngine;
import org.radeox.engine.context.BaseRenderContext;

public class InteractiveExample {
    private static DateFormat perfFormat = new SimpleDateFormat("m'm's's'S'ms'");

    public static void main(String[] stringArray) {
        System.err.println("Radeox");
        System.err.println("Copyright 2001-2004 Fraunhofer FIRST.");
        System.err.println("See License Agreement for terms and conditions of use.");
        BaseRenderEngine baseRenderEngine = new BaseRenderEngine();
        BaseRenderContext baseRenderContext = new BaseRenderContext();
        if (stringArray.length > 0) {
            File file = new File(stringArray[0]);
            if (file.exists()) {
                InteractiveExample.batch(baseRenderEngine, baseRenderContext, file);
            } else {
                System.err.println("The file '" + stringArray[0] + "' does not exist.");
            }
        } else {
            InteractiveExample.interactive(baseRenderEngine, baseRenderContext);
        }
    }

    private static void batch(RenderEngine renderEngine, RenderContext renderContext, File file) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            char[] cArray = new char[4096];
            int n = 0;
            while ((n = bufferedReader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        InteractiveExample.render(renderEngine, renderContext, stringBuffer.toString());
    }

    private static void interactive(RenderEngine renderEngine, RenderContext renderContext) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String string;
            System.out.print("> ");
            System.out.flush();
            while ((string = bufferedReader.readLine()) != null) {
                InteractiveExample.render(renderEngine, renderContext, string);
                System.out.print("> ");
                System.out.flush();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void render(RenderEngine renderEngine, RenderContext renderContext, String string) {
        long l = System.currentTimeMillis();
        String string2 = renderEngine.render(string, renderContext);
        long l2 = System.currentTimeMillis() - l;
        System.out.println(string2);
        System.out.println("rendered in " + perfFormat.format(new Date(l2)));
    }
}

