/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.radeox.api.engine.RenderEngine;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.api.engine.context.RenderContext;
import org.radeox.engine.context.BaseInitialRenderContext;
import org.radeox.filter.Filter;
import org.radeox.filter.FilterPipe;
import org.radeox.filter.context.BaseFilterContext;
import org.radeox.util.Service;

public class BaseRenderEngine
implements RenderEngine {
    public static final String NAME = "radeox";
    private static Log log = LogFactory.getLog(BaseRenderEngine.class);
    protected InitialRenderContext initialContext;
    protected FilterPipe fp;

    public BaseRenderEngine(InitialRenderContext initialRenderContext) {
        this.initialContext = initialRenderContext;
        this.init();
        this.initialContext.setFilterPipe(this.fp);
    }

    public BaseRenderEngine() {
        this(new BaseInitialRenderContext());
    }

    @Override
    public InitialRenderContext getInitialRenderContext() {
        return this.initialContext;
    }

    protected void init() {
        if (null == this.fp) {
            this.fp = new FilterPipe(this.initialContext);
            Iterator iterator = Service.providers(Filter.class);
            while (iterator.hasNext()) {
                try {
                    Filter filter = (Filter)iterator.next();
                    this.fp.addFilter(filter);
                    log.debug((Object)("Loaded filter: " + filter.getClass().getName()));
                }
                catch (Exception exception) {
                    log.warn((Object)"BaseRenderEngine: unable to load filter", (Throwable)exception);
                }
            }
            this.fp.init();
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String render(String string, RenderContext renderContext) {
        this.init();
        BaseFilterContext baseFilterContext = new BaseFilterContext();
        baseFilterContext.setRenderContext(renderContext);
        return this.fp.filter(string, baseFilterContext);
    }

    @Override
    public String render(Reader reader, RenderContext renderContext) throws IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
        }
        return this.render(stringBuffer.toString(), renderContext);
    }

    @Override
    public void render(Writer writer, String string, RenderContext renderContext) throws IOException {
        writer.write(this.render(string, renderContext));
    }
}

