/*
 * Decompiled with CFR 0.152.
 */
package org.radeox;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.radeox.api.engine.RenderEngine;
import org.radeox.engine.BaseRenderEngine;
import org.radeox.util.Service;

public class EngineManager {
    private static Log log = LogFactory.getLog(EngineManager.class);
    public static final String DEFAULT = "radeox";
    private static Map availableEngines = new HashMap();

    public static synchronized void registerEngine(RenderEngine renderEngine) {
        if (null == availableEngines) {
            availableEngines = new HashMap();
        }
        availableEngines.put(renderEngine.getName(), renderEngine);
    }

    public static synchronized RenderEngine getInstance(String string) {
        if (null == availableEngines) {
            availableEngines = new HashMap();
        }
        return (RenderEngine)availableEngines.get(string);
    }

    public static synchronized RenderEngine getInstance() {
        if (null == availableEngines) {
            availableEngines = new HashMap();
        }
        if (!availableEngines.containsKey(DEFAULT)) {
            BaseRenderEngine baseRenderEngine = new BaseRenderEngine();
            availableEngines.put(baseRenderEngine.getName(), baseRenderEngine);
        }
        return (RenderEngine)availableEngines.get(DEFAULT);
    }

    public static String getVersion() {
        return "0.5.1";
    }

    static {
        Iterator iterator = Service.providers(RenderEngine.class);
        while (iterator.hasNext()) {
            try {
                RenderEngine renderEngine = (RenderEngine)iterator.next();
                EngineManager.registerEngine(renderEngine);
                log.debug((Object)("Loaded RenderEngine: " + renderEngine.getClass().getName()));
            }
            catch (Exception exception) {
                log.warn((Object)"EngineManager: unable to load RenderEngine", (Throwable)exception);
            }
        }
    }
}

