/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovyx.net.http.ContentEncoding;
import groovyx.net.http.DeflateEncoding;
import groovyx.net.http.GZIPEncoding;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.impl.client.AbstractHttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentEncodingRegistry {
    protected Map<String, ContentEncoding> availableEncoders = this.getDefaultEncoders();

    protected Map<String, ContentEncoding> getDefaultEncoders() {
        HashMap<String, ContentEncoding> map = new HashMap<String, ContentEncoding>();
        map.put(ContentEncoding.Type.GZIP.toString(), new GZIPEncoding());
        map.put(ContentEncoding.Type.DEFLATE.toString(), new DeflateEncoding());
        return map;
    }

    void setInterceptors(AbstractHttpClient client, Object ... encodings) {
        client.removeRequestInterceptorByClass(ContentEncoding.RequestInterceptor.class);
        client.removeResponseInterceptorByClass(ContentEncoding.ResponseInterceptor.class);
        Object[] objectArray = encodings;
        int n = encodings.length;
        int n2 = 0;
        while (n2 < n) {
            Object encName = objectArray[n2];
            ContentEncoding enc = this.availableEncoders.get(encName.toString());
            if (enc != null) {
                client.addRequestInterceptor(enc.getRequestInterceptor());
                client.addResponseInterceptor(enc.getResponseInterceptor());
            }
            ++n2;
        }
    }
}

