/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core.controller;

import griffon.core.GriffonApplication;
import griffon.core.GriffonController;
import griffon.core.GriffonControllerClass;
import griffon.core.controller.GriffonControllerAction;
import griffon.core.controller.GriffonControllerActionManager;
import griffon.core.i18n.NoSuchMessageException;
import griffon.util.GriffonApplicationUtils;
import griffon.util.GriffonNameUtils;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGriffonControllerActionManager
implements GriffonControllerActionManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGriffonControllerActionManager.class);
    private final ActionCache actionCache = new ActionCache();
    private GriffonApplication app;

    protected AbstractGriffonControllerActionManager(GriffonApplication app) {
        this.app = app;
    }

    @Override
    public GriffonApplication getApp() {
        return this.app;
    }

    @Override
    public Map<String, GriffonControllerAction> actionsFor(GriffonController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("controller parameter is null!");
        }
        Map<String, GriffonControllerAction> actions = this.actionCache.get(controller);
        if (actions.isEmpty() && LOG.isTraceEnabled()) {
            LOG.trace("No actions defined for controller " + controller);
        }
        return actions;
    }

    @Override
    public GriffonControllerAction actionFor(GriffonController controller, String actionName) {
        if (controller == null) {
            throw new IllegalArgumentException("controller parameter is null!");
        }
        if (GriffonNameUtils.isBlank(actionName)) {
            throw new IllegalArgumentException("actionName parameter is null!");
        }
        return this.actionCache.get(controller).get(this.normalizeName(actionName));
    }

    @Override
    public void createActions(GriffonController controller) {
        GriffonControllerClass griffonClass = (GriffonControllerClass)controller.getGriffonClass();
        for (String actionName : griffonClass.getActionNames()) {
            GriffonControllerAction action = this.createAndConfigureAction(controller, actionName);
            Map<String, GriffonControllerAction> actions = this.actionCache.get(controller);
            if (actions.isEmpty()) {
                actions = new LinkedHashMap<String, GriffonControllerAction>();
                this.actionCache.set(controller, actions);
            }
            String actionKey = this.normalizeName(actionName);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Action for " + controller.getClass().getName() + "." + actionName + " stored as " + actionKey);
            }
            actions.put(actionKey, action);
        }
    }

    protected GriffonControllerAction createAndConfigureAction(GriffonController controller, String actionName) {
        String rsSelected;
        String rsEnabled;
        String rsLargeIcon;
        String rsSmallIcon;
        String rsMnemonic;
        String rsLongDescription;
        String rsShortDescription;
        String rsAccelerator;
        GriffonControllerAction action = this.createControllerAction(controller, actionName);
        String normalizeNamed = GriffonNameUtils.capitalize(this.normalizeName(actionName));
        String keyPrefix = controller.getClass().getName() + ".action.";
        String rsActionName = this.msg(keyPrefix, normalizeNamed, "name", GriffonNameUtils.getNaturalName(normalizeNamed));
        if (!GriffonNameUtils.isBlank(rsActionName)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + ".name = " + rsActionName);
            }
            action.setName(rsActionName);
        }
        if (!GriffonNameUtils.isBlank(rsAccelerator = this.msg(keyPrefix, normalizeNamed, "accelerator", ""))) {
            if (!GriffonApplicationUtils.isMacOSX() && rsAccelerator.contains("meta") && !rsAccelerator.contains("ctrl")) {
                rsAccelerator = rsAccelerator.replace("meta", "ctrl");
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + ".accelerator = " + rsAccelerator);
            }
            action.setAccelerator(rsAccelerator);
        }
        if (!GriffonNameUtils.isBlank(rsShortDescription = this.msg(keyPrefix, normalizeNamed, "short_description", ""))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + ".short_description = " + rsShortDescription);
            }
            action.setShortDescription(rsShortDescription);
        }
        if (!GriffonNameUtils.isBlank(rsLongDescription = this.msg(keyPrefix, normalizeNamed, "long_description", ""))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + ".long_description = " + rsLongDescription);
            }
            action.setLongDescription(rsLongDescription);
        }
        if (!GriffonNameUtils.isBlank(rsMnemonic = this.msg(keyPrefix, normalizeNamed, "mnemonic", ""))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + ".mnemonic = " + rsMnemonic);
            }
            action.setMnemonic(rsMnemonic);
        }
        if (!GriffonNameUtils.isBlank(rsSmallIcon = this.msg(keyPrefix, normalizeNamed, "small_icon", ""))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + ".small_icon = " + rsSmallIcon);
            }
            action.setSmallIcon(rsSmallIcon);
        }
        if (!GriffonNameUtils.isBlank(rsLargeIcon = this.msg(keyPrefix, normalizeNamed, "large_icon", ""))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + ".large_icon = " + rsLargeIcon);
            }
            action.setLargeIcon(rsLargeIcon);
        }
        if (!GriffonNameUtils.isBlank(rsEnabled = this.msg(keyPrefix, normalizeNamed, "enabled", "true"))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + ".enabled = " + rsEnabled);
            }
            action.setEnabled(DefaultTypeTransformation.castToBoolean((Object)rsEnabled));
        }
        if (!GriffonNameUtils.isBlank(rsSelected = this.msg(keyPrefix, normalizeNamed, "selected", "false"))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + ".selected = " + rsSelected);
            }
            action.setSelected(DefaultTypeTransformation.castToBoolean((Object)rsSelected));
        }
        return action;
    }

    protected abstract GriffonControllerAction createControllerAction(GriffonController var1, String var2);

    @Override
    public String normalizeName(String actionName) {
        if (actionName.endsWith("Action")) {
            actionName = actionName.substring(0, actionName.length() - "Action".length());
        }
        return GriffonNameUtils.uncapitalize(actionName);
    }

    protected String msg(String key, String actionName, String subkey, String defaultValue) {
        try {
            return this.app.getMessage(key + actionName + "." + subkey);
        }
        catch (NoSuchMessageException nsme) {
            return this.app.getMessage("application.action." + actionName + "." + subkey, defaultValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActionCache {
        private final Map<WeakReference<GriffonController>, Map<String, GriffonControllerAction>> cache = Collections.synchronizedMap(new LinkedHashMap());

        private ActionCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, GriffonControllerAction> get(GriffonController controller) {
            Map<WeakReference<GriffonController>, Map<String, GriffonControllerAction>> map = this.cache;
            synchronized (map) {
                for (Map.Entry<WeakReference<GriffonController>, Map<String, GriffonControllerAction>> entry : this.cache.entrySet()) {
                    GriffonController test = (GriffonController)entry.getKey().get();
                    if (test != controller) continue;
                    return entry.getValue();
                }
            }
            return Collections.emptyMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(GriffonController controller, Map<String, GriffonControllerAction> actions) {
            WeakReference<GriffonController> existingController = null;
            Map<WeakReference<GriffonController>, Map<String, GriffonControllerAction>> map = this.cache;
            synchronized (map) {
                for (WeakReference<GriffonController> key : this.cache.keySet()) {
                    if (key.get() != controller) continue;
                    existingController = key;
                    break;
                }
            }
            if (null != existingController) {
                this.cache.remove(existingController);
            }
            this.cache.put(new WeakReference<GriffonController>(controller), actions);
        }
    }
}

