/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.ArtifactInfo;
import griffon.core.GriffonApplication;
import griffon.core.GriffonClass;
import griffon.core.GriffonService;
import griffon.exceptions.NewInstanceCreationException;
import griffon.util.ApplicationHolder;
import griffon.util.ConfigUtils;
import griffon.util.GriffonExceptionHandler;
import groovy.lang.MetaClass;
import groovy.lang.MetaProperty;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.griffon.runtime.core.AbstractServiceManager;
import org.codehaus.griffon.runtime.core.ArtifactHandlerAdapter;
import org.codehaus.griffon.runtime.core.DefaultGriffonServiceClass;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceArtifactHandler
extends ArtifactHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceArtifactHandler.class);
    private final DefaultServiceManager serviceManager;

    public ServiceArtifactHandler(GriffonApplication app) {
        super(app, "service", "Service");
        this.serviceManager = new DefaultServiceManager(app);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering " + this.serviceManager + " as ServiceManager.");
        }
        InvokerHelper.setProperty((Object)app, (String)"serviceManager", (Object)this.serviceManager);
    }

    protected GriffonClass newGriffonClassInstance(Class clazz) {
        return new DefaultGriffonServiceClass(this.getApp(), clazz);
    }

    public void initialize(ArtifactInfo[] artifacts) {
        super.initialize(artifacts);
        if (ServiceArtifactHandler.isBasicInjectionDisabled()) {
            return;
        }
        this.getApp().addApplicationEventListener(this);
        if (this.isEagerInstantiationEnabled()) {
            GriffonClass griffonClass;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Instantiating service instances eagerly");
            }
            for (ArtifactInfo artifactInfo : artifacts) {
                griffonClass = this.getClassFor(artifactInfo.getClazz());
                this.serviceManager.doInstantiateService0(griffonClass.getPropertyName(), false);
            }
            for (ArtifactInfo artifactInfo : artifacts) {
                griffonClass = this.getClassFor(artifactInfo.getClazz());
                GriffonService serviceInstance = this.serviceManager.findService(griffonClass.getPropertyName());
                this.getApp().event(GriffonApplication.Event.NEW_INSTANCE.getName(), Arrays.asList(griffonClass.getClazz(), "service", serviceInstance));
            }
        }
    }

    public void onNewInstance(Class klass, String t, Object instance) {
        if (ServiceArtifactHandler.isBasicInjectionDisabled()) {
            return;
        }
        MetaClass metaClass = InvokerHelper.getMetaClass((Object)instance);
        for (MetaProperty property : metaClass.getProperties()) {
            GriffonService serviceInstance;
            String propertyName = property.getName();
            if (!propertyName.endsWith(this.getTrailing()) || (serviceInstance = this.serviceManager.findService(propertyName)) == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Injecting service " + serviceInstance + " on " + instance + " using property '" + propertyName + "'");
            }
            InvokerHelper.setProperty((Object)instance, (String)propertyName, (Object)serviceInstance);
        }
    }

    public static boolean isBasicInjectionDisabled() {
        return ConfigUtils.getConfigValueAsBoolean((Map)ApplicationHolder.getApplication().getConfig(), "griffon.services.basic.disabled", false);
    }

    private boolean isEagerInstantiationEnabled() {
        return ConfigUtils.getConfigValueAsBoolean((Map)this.getApp().getConfig(), "griffon.services.eager.instantiation", false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultServiceManager
    extends AbstractServiceManager {
        private final Map<String, GriffonService> serviceInstances;

        public DefaultServiceManager(GriffonApplication app) {
            super(app);
            this.serviceInstances = new ConcurrentHashMap<String, GriffonService>();
        }

        @Override
        public Map<String, GriffonService> getServices() {
            return Collections.unmodifiableMap(this.serviceInstances);
        }

        @Override
        protected GriffonService doFindService(String name) {
            return this.serviceInstances.get(name);
        }

        @Override
        protected GriffonService doInstantiateService(String name) {
            return this.doInstantiateService0(name, true);
        }

        private GriffonService doInstantiateService0(String name, boolean triggerEvent) {
            GriffonService serviceInstance = null;
            GriffonClass griffonClass = ServiceArtifactHandler.this.findClassFor(name);
            if (griffonClass != null) {
                serviceInstance = this.instantiateService(griffonClass);
                this.serviceInstances.put(name, serviceInstance);
                this.getApp().addApplicationEventListener(serviceInstance);
                if (triggerEvent) {
                    this.getApp().event(GriffonApplication.Event.NEW_INSTANCE.getName(), Arrays.asList(griffonClass.getClazz(), "service", serviceInstance));
                }
            }
            return serviceInstance;
        }

        private GriffonService instantiateService(GriffonClass griffonClass) {
            try {
                GriffonService serviceInstance = (GriffonService)griffonClass.getClazz().newInstance();
                InvokerHelper.setProperty((Object)serviceInstance, (String)"app", (Object)this.getApp());
                return serviceInstance;
            }
            catch (Exception e) {
                Throwable targetException = null;
                targetException = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
                throw new NewInstanceCreationException("Could not create a new instance of class " + griffonClass.getClazz().getName(), GriffonExceptionHandler.sanitize(targetException));
            }
        }
    }
}

