/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.factory;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryUtils {
    private FactoryUtils() {
    }

    public static double toDouble(Object value) {
        return FactoryUtils.toDouble(value, 0.0);
    }

    public static double toDouble(Object value, double defaultValue) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        try {
            return Double.parseDouble(String.valueOf(value));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static float toFloat(Object value) {
        return FactoryUtils.toFloat(value, 0.0f);
    }

    public static float toFloat(Object value, float defaultValue) {
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        try {
            return Float.parseFloat(String.valueOf(value));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static int toInt(Object value) {
        return FactoryUtils.toInt(value, 0);
    }

    public static int toInt(Object value, int defaultValue) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.parseInt(String.valueOf(value));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static Long toLong(Object value) {
        return FactoryUtils.toLong(value, 0L);
    }

    public static Long toLong(Object value, Long defaultValue) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        try {
            return Long.parseLong(String.valueOf(value));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static String parseSize(String size, List<String> sizes) {
        if (sizes.contains(size)) {
            return size + "x" + size;
        }
        return sizes.get(0) + "x" + sizes.get(0);
    }
}

