/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import griffon.core.MVCClosure;
import griffon.exceptions.BeanException;
import griffon.exceptions.BeanInstantiationException;
import griffon.util.GriffonNameUtils;
import griffon.util.MethodUtils;
import griffon.util.RunnableWithArgs;
import groovy.lang.AdaptingMetaClass;
import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.ExpandoMetaClassCreationHandle;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import groovy.lang.Script;
import groovy.util.FactoryBuilderSupport;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.CachedClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GriffonClassUtils {
    public static final Class[] EMPTY_CLASS_ARRAY;
    public static final Object[] EMPTY_OBJECT_ARRAY;
    public static final Object[] EMPTY_ARGS;
    private static final String PROPERTY_GET_PREFIX = "get";
    private static final String PROPERTY_IS_PREFIX = "is";
    private static final String PROPERTY_SET_PREFIX = "set";
    public static final Map<Class, Class> PRIMITIVE_TYPE_COMPATIBLE_CLASSES;
    private static final Pattern EVENT_HANDLER_PATTERN;
    private static final Pattern CONTRIBUTION_PATTERN;
    private static final Pattern GETTER_PATTERN_1;
    private static final Pattern GETTER_PATTERN_2;
    private static final Pattern SETTER_PATTERN;
    private static final Set<MethodDescriptor> BASIC_METHODS;
    private static final Set<MethodDescriptor> ARTIFACT_METHODS;
    private static final Set<MethodDescriptor> MVC_METHODS;
    private static final Set<MethodDescriptor> SERVICE_METHODS;
    private static final Set<MethodDescriptor> THREADING_METHODS;
    private static final Set<MethodDescriptor> EVENT_PUBLISHER_METHODS;
    private static final Set<MethodDescriptor> OBSERVABLE_METHODS;
    private static final Set<MethodDescriptor> RESOURCE_HANDLER_METHODS;
    private static final Set<MethodDescriptor> MESSAGE_SOURCE_METHODS;
    private static final Set<MethodDescriptor> RESOURCE_RESOLVER_METHODS;
    private static final Map<String, PropertyDescriptor[]> descriptorsCache;
    private static final String EMPTY_STRING = "";
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final String PACKAGE_SEPARATOR;
    public static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    public static final String INNER_CLASS_SEPARATOR;
    private static final Map abbreviationMap;
    private static final Map reverseAbbreviationMap;

    private static void registerPrimitiveClassPair(Class<?> left, Class<?> right) {
        PRIMITIVE_TYPE_COMPATIBLE_CLASSES.put(left, right);
        PRIMITIVE_TYPE_COMPATIBLE_CLASSES.put(right, left);
    }

    public static boolean isEventHandler(String name) {
        if (GriffonNameUtils.isBlank(name)) {
            return false;
        }
        return EVENT_HANDLER_PATTERN.matcher(name).matches();
    }

    public static boolean isEventHandler(Method method) {
        return GriffonClassUtils.isEventHandler(MethodDescriptor.forMethod(method));
    }

    public static boolean isEventHandler(MetaMethod method) {
        return GriffonClassUtils.isEventHandler(MethodDescriptor.forMethod(method));
    }

    public static boolean isEventHandler(MethodDescriptor method) {
        if (method == null || method.getModifiers() - 1 != 0) {
            return false;
        }
        return EVENT_HANDLER_PATTERN.matcher(method.getName()).matches();
    }

    public static boolean isBasicMethod(Method method) {
        return GriffonClassUtils.isBasicMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isContributionMethod(String name) {
        if (GriffonNameUtils.isBlank(name)) {
            return false;
        }
        return CONTRIBUTION_PATTERN.matcher(name).matches();
    }

    public static boolean isContributionMethod(Method method) {
        return GriffonClassUtils.isContributionMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isContributionMethod(MetaMethod method) {
        return GriffonClassUtils.isContributionMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isContributionMethod(MethodDescriptor method) {
        if (method == null || method.getModifiers() - 1 != 0) {
            return false;
        }
        return CONTRIBUTION_PATTERN.matcher(method.getName()).matches();
    }

    public static boolean isBasicMethod(MetaMethod method) {
        return GriffonClassUtils.isBasicMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isBasicMethod(MethodDescriptor method) {
        if (method == null || !GriffonClassUtils.isInstanceMethod(method)) {
            return false;
        }
        return BASIC_METHODS.contains(method);
    }

    public static boolean isGroovyInjectedMethod(Method method) {
        return GriffonClassUtils.isGroovyInjectedMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isGroovyInjectedMethod(MetaMethod method) {
        return GriffonClassUtils.isGroovyInjectedMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isGroovyInjectedMethod(MethodDescriptor method) {
        if (method == null || !GriffonClassUtils.isInstanceMethod(method)) {
            return false;
        }
        return method.getName().startsWith("super$") || method.getName().startsWith("this$");
    }

    public static boolean isGetterMethod(Method method) {
        return GriffonClassUtils.isGetterMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isGetterMethod(MetaMethod method) {
        return GriffonClassUtils.isGetterMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isGetterMethod(MethodDescriptor method) {
        if (method == null || !GriffonClassUtils.isInstanceMethod(method)) {
            return false;
        }
        return GETTER_PATTERN_1.matcher(method.getName()).matches() || GETTER_PATTERN_2.matcher(method.getName()).matches();
    }

    public static boolean isSetterMethod(Method method) {
        return GriffonClassUtils.isSetterMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isSetterMethod(MetaMethod method) {
        return GriffonClassUtils.isSetterMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isSetterMethod(MethodDescriptor method) {
        if (method == null || !GriffonClassUtils.isInstanceMethod(method)) {
            return false;
        }
        return SETTER_PATTERN.matcher(method.getName()).matches();
    }

    public static boolean isArtifactMethod(Method method) {
        return GriffonClassUtils.isArtifactMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isArtifactMethod(MetaMethod method) {
        return GriffonClassUtils.isArtifactMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isArtifactMethod(MethodDescriptor method) {
        if (method == null || !GriffonClassUtils.isInstanceMethod(method)) {
            return false;
        }
        return ARTIFACT_METHODS.contains(method);
    }

    public static boolean isMvcMethod(Method method) {
        return GriffonClassUtils.isMvcMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isMvcMethod(MetaMethod method) {
        return GriffonClassUtils.isMvcMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isMvcMethod(MethodDescriptor method) {
        if (method == null || !GriffonClassUtils.isInstanceMethod(method)) {
            return false;
        }
        return MVC_METHODS.contains(method);
    }

    public static boolean isServiceMethod(Method method) {
        return GriffonClassUtils.isServiceMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isServiceMethod(MetaMethod method) {
        return GriffonClassUtils.isServiceMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isServiceMethod(MethodDescriptor method) {
        if (method == null || !GriffonClassUtils.isInstanceMethod(method)) {
            return false;
        }
        return SERVICE_METHODS.contains(method);
    }

    public static boolean isThreadingMethod(Method method) {
        return GriffonClassUtils.isThreadingMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isThreadingMethod(MetaMethod method) {
        return GriffonClassUtils.isThreadingMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isThreadingMethod(MethodDescriptor method) {
        if (method == null || !GriffonClassUtils.isInstanceMethod(method)) {
            return false;
        }
        return THREADING_METHODS.contains(method);
    }

    public static boolean isEventPublisherMethod(Method method) {
        return GriffonClassUtils.isEventPublisherMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isEventPublisherMethod(MetaMethod method) {
        return GriffonClassUtils.isEventPublisherMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isEventPublisherMethod(MethodDescriptor method) {
        if (method == null || !GriffonClassUtils.isInstanceMethod(method)) {
            return false;
        }
        return EVENT_PUBLISHER_METHODS.contains(method);
    }

    public static boolean isObservableMethod(Method method) {
        return GriffonClassUtils.isObservableMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isObservableMethod(MetaMethod method) {
        return GriffonClassUtils.isObservableMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isObservableMethod(MethodDescriptor method) {
        if (method == null || !GriffonClassUtils.isInstanceMethod(method)) {
            return false;
        }
        return OBSERVABLE_METHODS.contains(method);
    }

    public static boolean isResourceHandlerMethod(Method method) {
        return GriffonClassUtils.isResourceHandlerMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isResourceHandlerMethod(MetaMethod method) {
        return GriffonClassUtils.isResourceHandlerMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isResourceHandlerMethod(MethodDescriptor method) {
        if (method == null || !GriffonClassUtils.isInstanceMethod(method)) {
            return false;
        }
        return RESOURCE_HANDLER_METHODS.contains(method);
    }

    public static boolean isMessageSourceMethod(Method method) {
        return GriffonClassUtils.isMessageSourceMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isMessageSourceMethod(MetaMethod method) {
        return GriffonClassUtils.isMessageSourceMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isMessageSourceMethod(MethodDescriptor method) {
        if (method == null || !GriffonClassUtils.isInstanceMethod(method)) {
            return false;
        }
        return MESSAGE_SOURCE_METHODS.contains(method);
    }

    public static boolean isResourceResolverMethod(Method method) {
        return GriffonClassUtils.isResourceResolverMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isResourceResolverMethod(MetaMethod method) {
        return GriffonClassUtils.isResourceResolverMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isResourceResolverMethod(MethodDescriptor method) {
        if (method == null || !GriffonClassUtils.isInstanceMethod(method)) {
            return false;
        }
        return RESOURCE_RESOLVER_METHODS.contains(method);
    }

    public static boolean isInstanceMethod(Method method) {
        return GriffonClassUtils.isInstanceMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isInstanceMethod(MetaMethod method) {
        return GriffonClassUtils.isInstanceMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isInstanceMethod(MethodDescriptor method) {
        if (method == null) {
            return false;
        }
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers);
    }

    public static boolean isPlainMethod(Method method) {
        return GriffonClassUtils.isPlainMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isPlainMethod(MetaMethod method) {
        return GriffonClassUtils.isPlainMethod(MethodDescriptor.forMethod(method));
    }

    public static boolean isPlainMethod(MethodDescriptor method) {
        return GriffonClassUtils.isInstanceMethod(method) && !GriffonClassUtils.isBasicMethod(method) && !GriffonClassUtils.isGroovyInjectedMethod(method) && !GriffonClassUtils.isThreadingMethod(method) && !GriffonClassUtils.isArtifactMethod(method) && !GriffonClassUtils.isMvcMethod(method) && !GriffonClassUtils.isServiceMethod(method) && !GriffonClassUtils.isEventPublisherMethod(method) && !GriffonClassUtils.isObservableMethod(method) && !GriffonClassUtils.isResourceHandlerMethod(method) && !GriffonClassUtils.isGetterMethod(method) && !GriffonClassUtils.isSetterMethod(method) && !GriffonClassUtils.isContributionMethod(method);
    }

    public static boolean isGetter(MetaProperty property) {
        return GriffonClassUtils.isGetter(property, false);
    }

    public static boolean isGetter(MetaProperty property, boolean strict) {
        if (property == null) {
            return false;
        }
        return GETTER_PATTERN_1.matcher(property.getName()).matches() || strict && GETTER_PATTERN_2.matcher(property.getName()).matches();
    }

    public static boolean isSetter(MetaProperty property) {
        if (property == null) {
            return false;
        }
        return SETTER_PATTERN.matcher(property.getName()).matches();
    }

    public static boolean isPropertyOfType(Class<?> clazz, String propertyName, Class<?> type) {
        try {
            Class<?> propType = GriffonClassUtils.getPropertyType(clazz, propertyName);
            return propType != null && propType.equals(type);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Object instantiateClass(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new BeanInstantiationException("Could not create an instance of " + clazz, e);
        }
    }

    public static Object instantiate(Class<?> clazz, Object[] args) {
        try {
            if (args == null) {
                args = EMPTY_OBJECT_ARRAY;
            }
            int arguments = args.length;
            Class[] parameterTypes = new Class[arguments];
            for (int i = 0; i < arguments; ++i) {
                parameterTypes[i] = args[i].getClass();
            }
            return clazz.getDeclaredConstructor(parameterTypes).newInstance(args);
        }
        catch (Exception e) {
            throw new BeanInstantiationException("Could not create an instance of " + clazz, e);
        }
    }

    public static Object getPropertyValueOfNewInstance(Class<?> clazz, String propertyName, Class<?> propertyType) {
        if (clazz == null || GriffonNameUtils.isBlank(propertyName)) {
            return null;
        }
        Object instance = null;
        try {
            instance = GriffonClassUtils.instantiateClass(clazz);
        }
        catch (BeanInstantiationException e) {
            return null;
        }
        return GriffonClassUtils.getPropertyOrStaticPropertyOrFieldValue(instance, propertyName);
    }

    public static Object getPropertyValueOfNewInstance(Class<?> clazz, String propertyName) {
        if (clazz == null || GriffonNameUtils.isBlank(propertyName)) {
            return null;
        }
        Object instance = null;
        try {
            instance = GriffonClassUtils.instantiateClass(clazz);
        }
        catch (BeanInstantiationException e) {
            return null;
        }
        return GriffonClassUtils.getPropertyOrStaticPropertyOrFieldValue(instance, propertyName);
    }

    public static PropertyDescriptor getPropertyDescriptorForValue(Object instance, Object propertyValue) {
        if (instance == null || propertyValue == null) {
            return null;
        }
        PropertyDescriptor[] descriptors = GriffonClassUtils.getPropertyDescriptors(instance.getClass());
        for (int i = 0; i < descriptors.length; ++i) {
            Object value;
            PropertyDescriptor pd = descriptors[i];
            if (!GriffonClassUtils.isAssignableOrConvertibleFrom(pd.getPropertyType(), propertyValue.getClass())) continue;
            try {
                value = GriffonClassUtils.getReadMethod(pd).invoke(instance, (Object[])null);
            }
            catch (Exception e) {
                throw new RuntimeException("Problem calling readMethod of " + pd, e);
            }
            if (!propertyValue.equals(value)) continue;
            return pd;
        }
        return null;
    }

    public static Class<?> getPropertyType(Class<?> clazz, String propertyName) {
        if (clazz == null || GriffonNameUtils.isBlank(propertyName)) {
            return null;
        }
        try {
            PropertyDescriptor desc = GriffonClassUtils.getPropertyDescriptor(clazz, propertyName);
            if (desc != null) {
                return desc.getPropertyType();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PropertyDescriptor[] getPropertiesOfType(Class<?> clazz, Class<?> propertyType) {
        if (clazz == null || propertyType == null) {
            return new PropertyDescriptor[0];
        }
        HashSet<PropertyDescriptor> properties = new HashSet<PropertyDescriptor>();
        try {
            PropertyDescriptor[] descriptors = GriffonClassUtils.getPropertyDescriptors(clazz);
            for (int i = 0; i < descriptors.length; ++i) {
                Class<?> currentPropertyType = descriptors[i].getPropertyType();
                if (!GriffonClassUtils.isTypeInstanceOfPropertyType(propertyType, currentPropertyType)) continue;
                properties.add(descriptors[i]);
            }
        }
        catch (Exception e) {
            return new PropertyDescriptor[0];
        }
        return properties.toArray(new PropertyDescriptor[properties.size()]);
    }

    private static boolean isTypeInstanceOfPropertyType(Class<?> type, Class<?> propertyType) {
        return propertyType.isAssignableFrom(type) && !propertyType.equals(Object.class);
    }

    public static PropertyDescriptor[] getPropertiesAssignableToType(Class<?> clazz, Class<?> propertySuperType) {
        if (clazz == null || propertySuperType == null) {
            return new PropertyDescriptor[0];
        }
        HashSet<PropertyDescriptor> properties = new HashSet<PropertyDescriptor>();
        try {
            PropertyDescriptor[] descriptors = GriffonClassUtils.getPropertyDescriptors(clazz);
            for (int i = 0; i < descriptors.length; ++i) {
                if (!propertySuperType.isAssignableFrom(descriptors[i].getPropertyType())) continue;
                properties.add(descriptors[i]);
            }
        }
        catch (Exception e) {
            return new PropertyDescriptor[0];
        }
        return properties.toArray(new PropertyDescriptor[properties.size()]);
    }

    public static PropertyDescriptor getProperty(Class<?> clazz, String propertyName, Class<?> propertyType) {
        if (clazz == null || propertyName == null || propertyType == null) {
            return null;
        }
        try {
            PropertyDescriptor pd = GriffonClassUtils.getPropertyDescriptor(clazz, propertyName);
            if (pd.getPropertyType().equals(propertyType)) {
                return pd;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object[] collectionToObjectArray(Collection c) {
        if (c == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        return c.toArray(new Object[c.size()]);
    }

    public static boolean isMatchBetweenPrimitiveAndWrapperTypes(Class<?> leftType, Class<?> rightType) {
        if (leftType == null) {
            throw new NullPointerException("Left type is null!");
        }
        if (rightType == null) {
            throw new NullPointerException("Right type is null!");
        }
        Class r = PRIMITIVE_TYPE_COMPATIBLE_CLASSES.get(leftType);
        return r == rightType;
    }

    public static boolean isGroovyAssignableFrom(Class<?> leftType, Class<?> rightType) {
        boolean result;
        if (leftType == null) {
            throw new NullPointerException("Left type is null!");
        }
        if (rightType == null) {
            throw new NullPointerException("Right type is null!");
        }
        if (leftType == Object.class) {
            return true;
        }
        if (leftType == rightType) {
            return true;
        }
        Class r = PRIMITIVE_TYPE_COMPATIBLE_CLASSES.get(leftType);
        boolean bl = result = r == rightType;
        if (!result) {
            if (rightType.isPrimitive()) {
                r = PRIMITIVE_TYPE_COMPATIBLE_CLASSES.get(rightType);
                if (r != null) {
                    result = leftType.isAssignableFrom(r);
                }
            } else {
                result = leftType.isAssignableFrom(rightType);
            }
        }
        return result;
    }

    private static Method findDeclaredMethod(Class<?> clazz, String methodName, Class[] parameterTypes) {
        while (clazz != null) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
                if (method != null) {
                    return method;
                }
            }
            catch (NoSuchMethodException e) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static boolean isStaticProperty(Class<?> clazz, String propertyName) {
        Method getter = GriffonClassUtils.findDeclaredMethod(clazz, GriffonClassUtils.getGetterName(propertyName), null);
        if (getter != null) {
            return GriffonClassUtils.isPublicStatic(getter);
        }
        try {
            Field f = clazz.getDeclaredField(propertyName);
            if (f != null) {
                return GriffonClassUtils.isPublicStatic(f);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isPublicStatic(Method m) {
        int modifiers = m.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers);
    }

    public static boolean isPublicStatic(Field f) {
        int modifiers = f.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers);
    }

    public static String getGetterName(String propertyName) {
        return PROPERTY_GET_PREFIX + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    public static Object getStaticPropertyValue(Class<?> clazz, String name) {
        Method getter = GriffonClassUtils.findDeclaredMethod(clazz, GriffonClassUtils.getGetterName(name), null);
        try {
            if (getter != null) {
                return getter.invoke(null, (Object[])null);
            }
            Field f = clazz.getDeclaredField(name);
            if (f != null) {
                return f.get(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Object getPropertyOrStaticPropertyOrFieldValue(Object obj, String name) {
        if (GriffonClassUtils.isReadable(obj, name)) {
            try {
                return GriffonClassUtils.getProperty(obj, name);
            }
            catch (Exception e) {
                throw new BeanException("Error while reading value of property/field " + name, e);
            }
        }
        if (GriffonClassUtils.isPublicField(obj, name)) {
            return GriffonClassUtils.getFieldValue(obj, name);
        }
        Class<?> clazz = obj.getClass();
        if (GriffonClassUtils.isStaticProperty(clazz, name)) {
            return GriffonClassUtils.getStaticPropertyValue(clazz, name);
        }
        return null;
    }

    public static Object getFieldValue(Object obj, String name) {
        Class<?> clazz = obj.getClass();
        Field f = null;
        try {
            f = clazz.getDeclaredField(name);
            return f.get(obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Field getField(Object obj, String name) {
        return GriffonClassUtils.getField(obj.getClass(), name);
    }

    public static Field getField(Class clazz, String name) {
        Field f = null;
        try {
            f = clazz.getDeclaredField(name);
            return f;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isPublicField(Object obj, String name) {
        Class<?> clazz = obj.getClass();
        Field f = null;
        try {
            f = clazz.getDeclaredField(name);
            return Modifier.isPublic(f.getModifiers());
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    public static boolean isPropertyInherited(Class<?> clz, String propertyName) {
        if (clz == null) {
            return false;
        }
        if (GriffonNameUtils.isBlank(propertyName)) {
            throw new IllegalArgumentException("Argument [propertyName] cannot be null or blank");
        }
        Class<?> superClass = clz.getSuperclass();
        PropertyDescriptor pd = null;
        try {
            pd = GriffonClassUtils.getPropertyDescriptor(superClass, propertyName);
        }
        catch (Exception e) {
            throw new BeanException("Could not read property descritptor for " + propertyName + " in " + superClass, e);
        }
        return pd != null && pd.getReadMethod() != null;
    }

    public static Collection createConcreteCollection(Class<?> interfaceType) {
        AbstractCollection elements = interfaceType.equals(List.class) ? new ArrayList() : (interfaceType.equals(SortedSet.class) ? new TreeSet() : new HashSet());
        return elements;
    }

    public static String getSetterName(String propertyName) {
        return PROPERTY_SET_PREFIX + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }

    public static boolean isGetter(String name, Class[] args) {
        if (GriffonNameUtils.isBlank(name) || args == null) {
            return false;
        }
        if (args.length != 0) {
            return false;
        }
        return name.startsWith(PROPERTY_GET_PREFIX) ? (name = name.substring(3)).length() > 0 && Character.isUpperCase(name.charAt(0)) : name.startsWith(PROPERTY_IS_PREFIX) && (name = name.substring(2)).length() > 0 && Character.isUpperCase(name.charAt(0));
    }

    public static String getPropertyForGetter(String getterName) {
        if (GriffonNameUtils.isBlank(getterName)) {
            return null;
        }
        if (getterName.startsWith(PROPERTY_GET_PREFIX)) {
            String prop = getterName.substring(3);
            return GriffonClassUtils.convertPropertyName(prop);
        }
        if (getterName.startsWith(PROPERTY_IS_PREFIX)) {
            String prop = getterName.substring(2);
            return GriffonClassUtils.convertPropertyName(prop);
        }
        return null;
    }

    private static String convertPropertyName(String prop) {
        if (Character.isUpperCase(prop.charAt(0)) && Character.isUpperCase(prop.charAt(1))) {
            return prop;
        }
        if (Character.isDigit(prop.charAt(0))) {
            return prop;
        }
        return Character.toLowerCase(prop.charAt(0)) + prop.substring(1);
    }

    public static String getPropertyForSetter(String setterName) {
        if (GriffonNameUtils.isBlank(setterName)) {
            return null;
        }
        if (setterName.startsWith(PROPERTY_SET_PREFIX)) {
            String prop = setterName.substring(3);
            return GriffonClassUtils.convertPropertyName(prop);
        }
        return null;
    }

    public static boolean isSetter(String name, Class[] args) {
        if (GriffonNameUtils.isBlank(name) || args == null) {
            return false;
        }
        if (name.startsWith(PROPERTY_SET_PREFIX)) {
            if (args.length != 1) {
                return false;
            }
            if ((name = name.substring(3)).length() > 0 && Character.isUpperCase(name.charAt(0))) {
                return true;
            }
        }
        return false;
    }

    public static MetaClass getExpandoMetaClass(Class<?> clazz) {
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        GriffonClassUtils.isTrue(registry.getMetaClassCreationHandler() instanceof ExpandoMetaClassCreationHandle, "Griffon requires an instance of [ExpandoMetaClassCreationHandle] to be set in Groovy's MetaClassRegistry!");
        MetaClass mc = registry.getMetaClass(clazz);
        AdaptingMetaClass adapter = null;
        if (mc instanceof AdaptingMetaClass) {
            adapter = (AdaptingMetaClass)mc;
            mc = ((AdaptingMetaClass)mc).getAdaptee();
        }
        if (!(mc instanceof ExpandoMetaClass)) {
            registry.removeMetaClass(clazz);
            mc = registry.getMetaClass(clazz);
            if (adapter != null) {
                adapter.setAdaptee(mc);
            }
        }
        GriffonClassUtils.isTrue(mc instanceof ExpandoMetaClass, "BUG! Method must return an instance of [ExpandoMetaClass]!");
        return mc;
    }

    public static boolean isAssignableOrConvertibleFrom(Class<?> clazz, Class<?> type) {
        if (type == null || clazz == null) {
            return false;
        }
        if (type.isPrimitive()) {
            Class primitiveClass = PRIMITIVE_TYPE_COMPATIBLE_CLASSES.get(type);
            if (primitiveClass == null) {
                return false;
            }
            return clazz.isAssignableFrom(primitiveClass);
        }
        return clazz.isAssignableFrom(type);
    }

    public static boolean getBooleanFromMap(String key, Map map) {
        if (map == null) {
            return false;
        }
        if (map.containsKey(key)) {
            Object o = map.get(key);
            if (o == null) {
                return false;
            }
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            return Boolean.valueOf(o.toString());
        }
        return false;
    }

    public static String findPropertyNameForValue(Object target, Object obj) {
        MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(target.getClass());
        List metaProperties = mc.getProperties();
        for (MetaProperty metaProperty : metaProperties) {
            Object val;
            if (!GriffonClassUtils.isAssignableOrConvertibleFrom(metaProperty.getType(), obj.getClass()) || (val = metaProperty.getProperty(target)) == null || !val.equals(obj)) continue;
            return metaProperty.getName();
        }
        return null;
    }

    public static boolean isClassBelowPackage(Class<?> theClass, List packageList) {
        String classPackage = theClass.getPackage().getName();
        for (Object packageName : packageList) {
            if (packageName == null || !classPackage.startsWith(packageName.toString())) continue;
            return true;
        }
        return false;
    }

    public static PropertyDescriptor getPropertyDescriptor(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        return GriffonClassUtils.getPropertyDescriptor(bean instanceof Class ? (Class<?>)bean : bean.getClass(), name);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (clazz == null) {
            throw new IllegalArgumentException("No class specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for class '" + clazz + "'");
        }
        PropertyDescriptor[] descriptors = GriffonClassUtils.getPropertyDescriptors(clazz);
        if (descriptors != null) {
            for (int i = 0; i < descriptors.length; ++i) {
                if (!name.equals(descriptors[i].getName())) continue;
                return descriptors[i];
            }
        }
        return null;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("No bean class specified");
        }
        PropertyDescriptor[] descriptors = null;
        descriptors = descriptorsCache.get(beanClass.getName());
        if (descriptors != null) {
            return descriptors;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
        descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        descriptorsCache.put(beanClass.getName(), descriptors);
        return descriptors;
    }

    public static Method getReadMethod(PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(descriptor.getReadMethod());
    }

    public static boolean isReadable(Object bean, String name) {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        try {
            PropertyDescriptor desc = GriffonClassUtils.getPropertyDescriptor(bean, name);
            if (desc != null) {
                Method readMethod = GriffonClassUtils.getReadMethod(bean.getClass(), desc);
                if (readMethod == null) {
                    readMethod = MethodUtils.getAccessibleMethod(bean.getClass(), readMethod);
                }
                return readMethod != null;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static Method getWriteMethod(PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(descriptor.getWriteMethod());
    }

    public static boolean isWritable(Object bean, String name) {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        try {
            PropertyDescriptor desc = GriffonClassUtils.getPropertyDescriptor(bean, name);
            if (desc != null) {
                Method writeMethod = GriffonClassUtils.getWriteMethod(bean.getClass(), desc);
                if (writeMethod == null) {
                    writeMethod = MethodUtils.getAccessibleMethod(bean.getClass(), writeMethod);
                }
                return writeMethod != null;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static Object getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        PropertyDescriptor descriptor = GriffonClassUtils.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on class '" + bean.getClass() + "'");
        }
        Method readMethod = GriffonClassUtils.getReadMethod(bean.getClass(), descriptor);
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method in class '" + bean.getClass() + "'");
        }
        Object value = readMethod.invoke(bean, EMPTY_OBJECT_ARRAY);
        return value;
    }

    public static Method getReadMethod(Class<?> clazz, PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(clazz, descriptor.getReadMethod());
    }

    public static Method getWriteMethod(Class<?> clazz, PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(clazz, descriptor.getWriteMethod());
    }

    public static void isTrue(boolean expression, String message) {
        if (expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static Object invokeInstanceMethod(Object object, String methodName) {
        return GriffonClassUtils.invokeInstanceMethod(object, methodName, EMPTY_ARGS);
    }

    public static Object invokeInstanceMethod(Object object, String methodName, Object arg) {
        return GriffonClassUtils.invokeInstanceMethod(object, methodName, new Object[]{arg});
    }

    public static Object invokeInstanceMethod(Object object, String methodName, Object ... args) {
        try {
            return MethodUtils.invokeMethod(object, methodName, args);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e.getMessage(), cause);
        }
    }

    public static Object invokeExactInstanceMethod(Object object, String methodName) {
        return GriffonClassUtils.invokeExactInstanceMethod(object, methodName, EMPTY_ARGS);
    }

    public static Object invokeExactInstanceMethod(Object object, String methodName, Object arg) {
        return GriffonClassUtils.invokeExactInstanceMethod(object, methodName, new Object[]{arg});
    }

    public static Object invokeExactInstanceMethod(Object object, String methodName, Object ... args) {
        try {
            return MethodUtils.invokeExactMethod(object, methodName, args);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e.getMessage(), cause);
        }
    }

    public static Object invokeStaticMethod(Class type, String methodName) {
        return GriffonClassUtils.invokeStaticMethod(type, methodName, EMPTY_ARGS);
    }

    public static Object invokeStaticMethod(Class type, String methodName, Object arg) {
        return GriffonClassUtils.invokeStaticMethod(type, methodName, new Object[]{arg});
    }

    public static Object invokeStaticMethod(Class type, String methodName, Object ... args) {
        try {
            return MethodUtils.invokeStaticMethod(type, methodName, args);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e.getMessage(), cause);
        }
    }

    public static Object invokeExactStaticMethod(Class type, String methodName) {
        return GriffonClassUtils.invokeExactStaticMethod(type, methodName, EMPTY_ARGS);
    }

    public static Object invokeExactStaticMethod(Class type, String methodName, Object arg) {
        return GriffonClassUtils.invokeExactStaticMethod(type, methodName, new Object[]{arg});
    }

    public static Object invokeExactStaticMethod(Class type, String methodName, Object ... args) {
        try {
            return MethodUtils.invokeExactStaticMethod(type, methodName, args);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e.getMessage(), cause);
        }
    }

    private static void addAbbreviation(String primitive, String abbreviation) {
        abbreviationMap.put(primitive, abbreviation);
        reverseAbbreviationMap.put(abbreviation, primitive);
    }

    public static String getShortClassName(Object object, String valueIfNull) {
        if (object == null) {
            return valueIfNull;
        }
        return GriffonClassUtils.getShortClassName(object.getClass());
    }

    public static String getShortClassName(Class<?> cls) {
        if (cls == null) {
            return EMPTY_STRING;
        }
        return GriffonClassUtils.getShortClassName(cls.getName());
    }

    public static String getShortClassName(String className) {
        int lastDotIdx;
        if (className == null) {
            return EMPTY_STRING;
        }
        if (className.length() == 0) {
            return EMPTY_STRING;
        }
        StringBuffer arrayPrefix = new StringBuffer();
        if (className.startsWith("[")) {
            while (className.charAt(0) == '[') {
                className = className.substring(1);
                arrayPrefix.append("[]");
            }
            if (className.charAt(0) == 'L' && className.charAt(className.length() - 1) == ';') {
                className = className.substring(1, className.length() - 1);
            }
        }
        if (reverseAbbreviationMap.containsKey(className)) {
            className = (String)reverseAbbreviationMap.get(className);
        }
        int innerIdx = className.indexOf(36, (lastDotIdx = className.lastIndexOf(46)) == -1 ? 0 : lastDotIdx + 1);
        String out = className.substring(lastDotIdx + 1);
        if (innerIdx != -1) {
            out = out.replace('$', '.');
        }
        return out + arrayPrefix;
    }

    public static String getPackageName(Object object, String valueIfNull) {
        if (object == null) {
            return valueIfNull;
        }
        return GriffonClassUtils.getPackageName(object.getClass());
    }

    public static String getPackageName(Class<?> cls) {
        if (cls == null) {
            return EMPTY_STRING;
        }
        return GriffonClassUtils.getPackageName(cls.getName());
    }

    public static String getPackageName(String className) {
        int i;
        if (className == null || className.length() == 0) {
            return EMPTY_STRING;
        }
        while (className.charAt(0) == '[') {
            className = className.substring(1);
        }
        if (className.charAt(0) == 'L' && className.charAt(className.length() - 1) == ';') {
            className = className.substring(1);
        }
        if ((i = className.lastIndexOf(46)) == -1) {
            return EMPTY_STRING;
        }
        return className.substring(0, i);
    }

    static {
        MethodDescriptor md;
        EMPTY_CLASS_ARRAY = new Class[0];
        EMPTY_OBJECT_ARRAY = new Object[0];
        EMPTY_ARGS = EMPTY_OBJECT_ARRAY;
        PRIMITIVE_TYPE_COMPATIBLE_CLASSES = new HashMap<Class, Class>();
        EVENT_HANDLER_PATTERN = Pattern.compile("^on[A-Z][\\w]*$");
        CONTRIBUTION_PATTERN = Pattern.compile("^with[A-Z][a-z0-9_]*[\\w]*$");
        GETTER_PATTERN_1 = Pattern.compile("^get[A-Z][\\w]*$");
        GETTER_PATTERN_2 = Pattern.compile("^is[A-Z][\\w]*$");
        SETTER_PATTERN = Pattern.compile("^set[A-Z][\\w]*$");
        BASIC_METHODS = new TreeSet<MethodDescriptor>();
        ARTIFACT_METHODS = new TreeSet<MethodDescriptor>();
        MVC_METHODS = new TreeSet<MethodDescriptor>();
        SERVICE_METHODS = new TreeSet<MethodDescriptor>();
        THREADING_METHODS = new TreeSet<MethodDescriptor>();
        EVENT_PUBLISHER_METHODS = new TreeSet<MethodDescriptor>();
        OBSERVABLE_METHODS = new TreeSet<MethodDescriptor>();
        RESOURCE_HANDLER_METHODS = new TreeSet<MethodDescriptor>();
        MESSAGE_SOURCE_METHODS = new TreeSet<MethodDescriptor>();
        RESOURCE_RESOLVER_METHODS = new TreeSet<MethodDescriptor>();
        GriffonClassUtils.registerPrimitiveClassPair(Boolean.class, Boolean.TYPE);
        GriffonClassUtils.registerPrimitiveClassPair(Integer.class, Integer.TYPE);
        GriffonClassUtils.registerPrimitiveClassPair(Short.class, Short.TYPE);
        GriffonClassUtils.registerPrimitiveClassPair(Byte.class, Byte.TYPE);
        GriffonClassUtils.registerPrimitiveClassPair(Character.class, Character.TYPE);
        GriffonClassUtils.registerPrimitiveClassPair(Long.class, Long.TYPE);
        GriffonClassUtils.registerPrimitiveClassPair(Float.class, Float.TYPE);
        GriffonClassUtils.registerPrimitiveClassPair(Double.class, Double.TYPE);
        for (Method method : GroovyObject.class.getMethods()) {
            md = MethodDescriptor.forMethod(method);
            if (BASIC_METHODS.contains(md)) continue;
            BASIC_METHODS.add(md);
        }
        for (Method method : GroovyObjectSupport.class.getMethods()) {
            md = MethodDescriptor.forMethod(method);
            if (BASIC_METHODS.contains(md)) continue;
            BASIC_METHODS.add(md);
        }
        for (Method method : Object.class.getMethods()) {
            md = MethodDescriptor.forMethod(method);
            if (BASIC_METHODS.contains(md)) continue;
            BASIC_METHODS.add(md);
        }
        ARTIFACT_METHODS.add(new MethodDescriptor("newInstance", new Class[]{Class.class, String.class}));
        ARTIFACT_METHODS.add(new MethodDescriptor("newInstance", new Class[]{Object[].class}));
        ARTIFACT_METHODS.add(new MethodDescriptor("getApp"));
        ARTIFACT_METHODS.add(new MethodDescriptor("getLog"));
        ARTIFACT_METHODS.add(new MethodDescriptor("getGriffonClass"));
        MVC_METHODS.add(new MethodDescriptor("mvcGroupInit", new Class[]{Map.class}));
        MVC_METHODS.add(new MethodDescriptor("mvcGroupDestroy"));
        MVC_METHODS.add(new MethodDescriptor("buildMVCGroup", new Class[]{String.class}));
        MVC_METHODS.add(new MethodDescriptor("buildMVCGroup", new Class[]{String.class, Map.class}));
        MVC_METHODS.add(new MethodDescriptor("buildMVCGroup", new Class[]{Map.class, String.class}));
        MVC_METHODS.add(new MethodDescriptor("buildMVCGroup", new Class[]{String.class, String.class}));
        MVC_METHODS.add(new MethodDescriptor("buildMVCGroup", new Class[]{String.class, String.class, Map.class}));
        MVC_METHODS.add(new MethodDescriptor("buildMVCGroup", new Class[]{Map.class, String.class, String.class}));
        MVC_METHODS.add(new MethodDescriptor("createMVCGroup", new Class[]{String.class}));
        MVC_METHODS.add(new MethodDescriptor("createMVCGroup", new Class[]{String.class, Map.class}));
        MVC_METHODS.add(new MethodDescriptor("createMVCGroup", new Class[]{Map.class, String.class}));
        MVC_METHODS.add(new MethodDescriptor("createMVCGroup", new Class[]{String.class, String.class}));
        MVC_METHODS.add(new MethodDescriptor("createMVCGroup", new Class[]{String.class, String.class, Map.class}));
        MVC_METHODS.add(new MethodDescriptor("createMVCGroup", new Class[]{Map.class, String.class, String.class}));
        MVC_METHODS.add(new MethodDescriptor("destroyMVCGroup", new Class[]{String.class}));
        MVC_METHODS.add(new MethodDescriptor("withMVCGroup", new Class[]{String.class, Closure.class}));
        MVC_METHODS.add(new MethodDescriptor("withMVCGroup", new Class[]{String.class, Map.class, Closure.class}));
        MVC_METHODS.add(new MethodDescriptor("withMVCGroup", new Class[]{Map.class, String.class, Closure.class}));
        MVC_METHODS.add(new MethodDescriptor("withMVCGroup", new Class[]{String.class, String.class, Closure.class}));
        MVC_METHODS.add(new MethodDescriptor("withMVCGroup", new Class[]{String.class, String.class, Map.class, Closure.class}));
        MVC_METHODS.add(new MethodDescriptor("withMVCGroup", new Class[]{Map.class, String.class, String.class, Closure.class}));
        MVC_METHODS.add(new MethodDescriptor("withMVCGroup", new Class[]{String.class, MVCClosure.class}));
        MVC_METHODS.add(new MethodDescriptor("withMVCGroup", new Class[]{String.class, Map.class, MVCClosure.class}));
        MVC_METHODS.add(new MethodDescriptor("withMVCGroup", new Class[]{Map.class, String.class, MVCClosure.class}));
        MVC_METHODS.add(new MethodDescriptor("withMVCGroup", new Class[]{String.class, String.class, MVCClosure.class}));
        MVC_METHODS.add(new MethodDescriptor("withMVCGroup", new Class[]{String.class, String.class, Map.class, MVCClosure.class}));
        MVC_METHODS.add(new MethodDescriptor("withMVCGroup", new Class[]{Map.class, String.class, String.class, MVCClosure.class}));
        MVC_METHODS.add(new MethodDescriptor("buildMVCGroup", new Class[]{Object[].class}));
        MVC_METHODS.add(new MethodDescriptor("createMVCGroup", new Class[]{Object[].class}));
        MVC_METHODS.add(new MethodDescriptor("withMVCGroup", new Class[]{Object[].class}));
        MVC_METHODS.add(new MethodDescriptor("getArtifactManager"));
        MVC_METHODS.add(new MethodDescriptor("getAddonManager"));
        MVC_METHODS.add(new MethodDescriptor("getMVCGroupManager"));
        MVC_METHODS.add(new MethodDescriptor("setBuilder", new Class[]{FactoryBuilderSupport.class}));
        SERVICE_METHODS.add(new MethodDescriptor("serviceInit"));
        SERVICE_METHODS.add(new MethodDescriptor("serviceDestroy"));
        THREADING_METHODS.add(new MethodDescriptor("isUIThread"));
        THREADING_METHODS.add(new MethodDescriptor("execInsideUIAsync", new Class[]{Runnable.class}));
        THREADING_METHODS.add(new MethodDescriptor("execInsideUIAsync", new Class[]{Script.class}));
        THREADING_METHODS.add(new MethodDescriptor("execInsideUISync", new Class[]{Runnable.class}));
        THREADING_METHODS.add(new MethodDescriptor("execInsideUISync", new Class[]{Script.class}));
        THREADING_METHODS.add(new MethodDescriptor("execOutsideUI", new Class[]{Runnable.class}));
        THREADING_METHODS.add(new MethodDescriptor("execOutsideUI", new Class[]{Script.class}));
        THREADING_METHODS.add(new MethodDescriptor("execFuture", new Class[]{Closure.class}));
        THREADING_METHODS.add(new MethodDescriptor("execFuture", new Class[]{Callable.class}));
        THREADING_METHODS.add(new MethodDescriptor("execFuture", new Class[]{ExecutorService.class, Closure.class}));
        THREADING_METHODS.add(new MethodDescriptor("execFuture", new Class[]{ExecutorService.class, Callable.class}));
        THREADING_METHODS.add(new MethodDescriptor("edt", new Class[]{Runnable.class}));
        THREADING_METHODS.add(new MethodDescriptor("edt", new Class[]{Closure.class}));
        THREADING_METHODS.add(new MethodDescriptor("doLater", new Class[]{Runnable.class}));
        THREADING_METHODS.add(new MethodDescriptor("doLater", new Class[]{Closure.class}));
        THREADING_METHODS.add(new MethodDescriptor("doOutside", new Class[]{Runnable.class}));
        THREADING_METHODS.add(new MethodDescriptor("doOutside", new Class[]{Closure.class}));
        THREADING_METHODS.add(new MethodDescriptor("execFuture", new Class[]{Object[].class}));
        EVENT_PUBLISHER_METHODS.add(new MethodDescriptor("addEventListener", new Class[]{Object.class}));
        EVENT_PUBLISHER_METHODS.add(new MethodDescriptor("addEventListener", new Class[]{String.class, Closure.class}));
        EVENT_PUBLISHER_METHODS.add(new MethodDescriptor("addEventListener", new Class[]{String.class, RunnableWithArgs.class}));
        EVENT_PUBLISHER_METHODS.add(new MethodDescriptor("removeEventListener", new Class[]{Object.class}));
        EVENT_PUBLISHER_METHODS.add(new MethodDescriptor("removeEventListener", new Class[]{String.class, Closure.class}));
        EVENT_PUBLISHER_METHODS.add(new MethodDescriptor("removeEventListener", new Class[]{String.class, RunnableWithArgs.class}));
        EVENT_PUBLISHER_METHODS.add(new MethodDescriptor("publishEvent", new Class[]{String.class}));
        EVENT_PUBLISHER_METHODS.add(new MethodDescriptor("publishEvent", new Class[]{String.class, List.class}));
        EVENT_PUBLISHER_METHODS.add(new MethodDescriptor("publishEventAsync", new Class[]{String.class}));
        EVENT_PUBLISHER_METHODS.add(new MethodDescriptor("publishEventAsync", new Class[]{String.class, List.class}));
        EVENT_PUBLISHER_METHODS.add(new MethodDescriptor("publishEventOutsideUI", new Class[]{String.class}));
        EVENT_PUBLISHER_METHODS.add(new MethodDescriptor("publishEventOutsideUI", new Class[]{String.class, List.class}));
        OBSERVABLE_METHODS.add(new MethodDescriptor("addPropertyChangeListener", new Class[]{PropertyChangeListener.class}));
        OBSERVABLE_METHODS.add(new MethodDescriptor("addPropertyChangeListener", new Class[]{String.class, PropertyChangeListener.class}));
        OBSERVABLE_METHODS.add(new MethodDescriptor("removePropertyChangeListener", new Class[]{PropertyChangeListener.class}));
        OBSERVABLE_METHODS.add(new MethodDescriptor("removePropertyChangeListener", new Class[]{String.class, PropertyChangeListener.class}));
        OBSERVABLE_METHODS.add(new MethodDescriptor("getPropertyChangeListeners", new Class[0]));
        OBSERVABLE_METHODS.add(new MethodDescriptor("getPropertyChangeListeners", new Class[]{String.class}));
        RESOURCE_HANDLER_METHODS.add(new MethodDescriptor("getResourceAsURL", new Class[]{String.class}));
        RESOURCE_HANDLER_METHODS.add(new MethodDescriptor("getResourceAsStream", new Class[]{String.class}));
        RESOURCE_HANDLER_METHODS.add(new MethodDescriptor("getResources", new Class[]{String.class}));
        MESSAGE_SOURCE_METHODS.add(new MethodDescriptor("getMessage", new Class[]{String.class}));
        MESSAGE_SOURCE_METHODS.add(new MethodDescriptor("getMessage", new Class[]{String.class, Object[].class}));
        MESSAGE_SOURCE_METHODS.add(new MethodDescriptor("getMessage", new Class[]{String.class, Locale.class}));
        MESSAGE_SOURCE_METHODS.add(new MethodDescriptor("getMessage", new Class[]{String.class, Object[].class, Locale.class}));
        MESSAGE_SOURCE_METHODS.add(new MethodDescriptor("getMessage", new Class[]{String.class, String.class}));
        MESSAGE_SOURCE_METHODS.add(new MethodDescriptor("getMessage", new Class[]{String.class, Object[].class, String.class}));
        MESSAGE_SOURCE_METHODS.add(new MethodDescriptor("getMessage", new Class[]{String.class, String.class, Locale.class}));
        MESSAGE_SOURCE_METHODS.add(new MethodDescriptor("getMessage", new Class[]{String.class, Object[].class, String.class, Locale.class}));
        MESSAGE_SOURCE_METHODS.add(new MethodDescriptor("getMessage", new Class[]{String.class, List.class}));
        MESSAGE_SOURCE_METHODS.add(new MethodDescriptor("getMessage", new Class[]{String.class, List.class, Locale.class}));
        MESSAGE_SOURCE_METHODS.add(new MethodDescriptor("getMessage", new Class[]{String.class, List.class, String.class}));
        MESSAGE_SOURCE_METHODS.add(new MethodDescriptor("getMessage", new Class[]{String.class, List.class, String.class, Locale.class}));
        MESSAGE_SOURCE_METHODS.add(new MethodDescriptor("getMessage", new Class[]{String.class, Map.class}));
        MESSAGE_SOURCE_METHODS.add(new MethodDescriptor("getMessage", new Class[]{String.class, Map.class, Locale.class}));
        MESSAGE_SOURCE_METHODS.add(new MethodDescriptor("getMessage", new Class[]{String.class, Map.class, String.class}));
        MESSAGE_SOURCE_METHODS.add(new MethodDescriptor("getMessage", new Class[]{String.class, Map.class, String.class, Locale.class}));
        RESOURCE_RESOLVER_METHODS.add(new MethodDescriptor("resolveResource", new Class[]{String.class}));
        RESOURCE_RESOLVER_METHODS.add(new MethodDescriptor("resolveResource", new Class[]{String.class, Object[].class}));
        RESOURCE_RESOLVER_METHODS.add(new MethodDescriptor("resolveResource", new Class[]{String.class, Locale.class}));
        RESOURCE_RESOLVER_METHODS.add(new MethodDescriptor("resolveResource", new Class[]{String.class, Object[].class, Locale.class}));
        RESOURCE_RESOLVER_METHODS.add(new MethodDescriptor("resolveResource", new Class[]{String.class, Object.class}));
        RESOURCE_RESOLVER_METHODS.add(new MethodDescriptor("resolveResource", new Class[]{String.class, Object[].class, Object.class}));
        RESOURCE_RESOLVER_METHODS.add(new MethodDescriptor("resolveResource", new Class[]{String.class, Object.class, Locale.class}));
        RESOURCE_RESOLVER_METHODS.add(new MethodDescriptor("resolveResource", new Class[]{String.class, Object[].class, Object.class, Locale.class}));
        RESOURCE_RESOLVER_METHODS.add(new MethodDescriptor("resolveResource", new Class[]{String.class, List.class}));
        RESOURCE_RESOLVER_METHODS.add(new MethodDescriptor("resolveResource", new Class[]{String.class, List.class, Locale.class}));
        RESOURCE_RESOLVER_METHODS.add(new MethodDescriptor("resolveResource", new Class[]{String.class, List.class, Object.class}));
        RESOURCE_RESOLVER_METHODS.add(new MethodDescriptor("resolveResource", new Class[]{String.class, List.class, Object.class, Locale.class}));
        RESOURCE_RESOLVER_METHODS.add(new MethodDescriptor("resolveResource", new Class[]{String.class, Map.class}));
        RESOURCE_RESOLVER_METHODS.add(new MethodDescriptor("resolveResource", new Class[]{String.class, Map.class, Locale.class}));
        RESOURCE_RESOLVER_METHODS.add(new MethodDescriptor("resolveResource", new Class[]{String.class, Map.class, Object.class}));
        RESOURCE_RESOLVER_METHODS.add(new MethodDescriptor("resolveResource", new Class[]{String.class, Map.class, Object.class, Locale.class}));
        descriptorsCache = new LinkedHashMap<String, PropertyDescriptor[]>();
        PACKAGE_SEPARATOR = String.valueOf('.');
        INNER_CLASS_SEPARATOR = String.valueOf('$');
        abbreviationMap = new HashMap();
        reverseAbbreviationMap = new HashMap();
        GriffonClassUtils.addAbbreviation("int", "I");
        GriffonClassUtils.addAbbreviation("boolean", "Z");
        GriffonClassUtils.addAbbreviation("float", "F");
        GriffonClassUtils.addAbbreviation("long", "J");
        GriffonClassUtils.addAbbreviation("short", "S");
        GriffonClassUtils.addAbbreviation("byte", "B");
        GriffonClassUtils.addAbbreviation("double", "D");
        GriffonClassUtils.addAbbreviation("char", "C");
    }

    public static class MethodDescriptor
    implements Comparable {
        private final String methodName;
        private final String[] paramTypes;
        private final int hashCode;
        private final int modifiers;
        private static final String[] EMPTY_CLASS_PARAMETERS = new String[0];

        public static MethodDescriptor forMethod(Method method) {
            if (method == null) {
                return null;
            }
            return new MethodDescriptor(method.getName(), method.getParameterTypes(), method.getModifiers());
        }

        public static MethodDescriptor forMethod(MetaMethod method) {
            if (method == null) {
                return null;
            }
            CachedClass[] types = method.getParameterTypes();
            String[] parameterTypes = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                parameterTypes[i] = types[i].getTheClass().getName();
            }
            return new MethodDescriptor(method.getName(), parameterTypes, method.getModifiers());
        }

        public MethodDescriptor(String methodName) {
            this(methodName, EMPTY_CLASS_PARAMETERS, 1);
        }

        public MethodDescriptor(String methodName, int modifiers) {
            this(methodName, EMPTY_CLASS_PARAMETERS, modifiers);
        }

        public MethodDescriptor(String methodName, Class[] paramTypes) {
            this(methodName, paramTypes, 1);
        }

        public MethodDescriptor(String methodName, String[] paramTypes) {
            this(methodName, paramTypes, 1);
        }

        public MethodDescriptor(String methodName, Class[] paramTypes, int modifiers) {
            this.methodName = methodName;
            if (paramTypes == null) {
                this.paramTypes = EMPTY_CLASS_PARAMETERS;
            } else {
                this.paramTypes = new String[paramTypes.length];
                for (int i = 0; i < paramTypes.length; ++i) {
                    this.paramTypes[i] = paramTypes[i].getName();
                }
            }
            this.modifiers = modifiers;
            this.hashCode = methodName.length() + modifiers;
        }

        public MethodDescriptor(String methodName, String[] paramTypes, int modifiers) {
            this.methodName = methodName;
            this.paramTypes = paramTypes == null ? EMPTY_CLASS_PARAMETERS : paramTypes;
            this.modifiers = modifiers;
            this.hashCode = methodName.length() + modifiers;
        }

        public String getName() {
            return this.methodName;
        }

        public String[] getParameterTypes() {
            return this.paramTypes;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodDescriptor)) {
                return false;
            }
            MethodDescriptor md = (MethodDescriptor)obj;
            return this.methodName.equals(md.methodName) && this.modifiers == md.modifiers && Arrays.equals(this.paramTypes, md.paramTypes);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(Modifier.toString(this.modifiers)).append(" ");
            b.append(this.methodName).append("(");
            for (int i = 0; i < this.paramTypes.length; ++i) {
                if (i != 0) {
                    b.append(", ");
                }
                b.append(this.paramTypes[i]);
            }
            b.append(")");
            return b.toString();
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof MethodDescriptor)) {
                return -1;
            }
            MethodDescriptor md = (MethodDescriptor)obj;
            int c = this.methodName.compareTo(md.methodName);
            if (c != 0) {
                return c;
            }
            c = this.modifiers - md.modifiers;
            if (c != 0) {
                return c;
            }
            c = this.paramTypes.length - md.paramTypes.length;
            if (c != 0) {
                return c;
            }
            for (int i = 0; i < this.paramTypes.length; ++i) {
                c = this.paramTypes[i].compareTo(md.paramTypes[i]);
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
    }
}

