/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import griffon.util.Metadata;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Environment {
    DEVELOPMENT,
    PRODUCTION,
    TEST,
    CUSTOM;

    public static final String KEY = "griffon.env";
    public static final String DEFAULT = "griffon.env.default";
    private static final String PRODUCTION_ENV_SHORT_NAME = "prod";
    private static final String DEVELOPMENT_ENVIRONMENT_SHORT_NAME = "dev";
    private static final String TEST_ENVIRONMENT_SHORT_NAME = "test";
    private static Map<String, String> envNameMappings;
    private String name;

    public static Environment getCurrent() {
        String envName = System.getProperty(KEY);
        Metadata metadata = Metadata.getCurrent();
        if (metadata != null && Environment.isBlank(envName)) {
            envName = metadata.getEnvironment();
        }
        if (Environment.isBlank(envName)) {
            return DEVELOPMENT;
        }
        Environment env = Environment.getEnvironment(envName);
        if (env == null) {
            try {
                env = Environment.valueOf(envName.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (env == null) {
            env = CUSTOM;
            env.setName(envName);
        }
        return env;
    }

    public static Environment getCurrentEnvironment() {
        return Environment.getCurrent();
    }

    public static boolean isSystemSet() {
        return System.getProperty(KEY) != null;
    }

    public static Environment getEnvironment(String shortName) {
        String envName = envNameMappings.get(shortName);
        if (envName != null) {
            return Environment.valueOf(envName.toUpperCase());
        }
        return null;
    }

    public static Closure getEnvironmentSpecificBlock(Closure closure) {
        Environment env = Environment.getCurrent();
        return Environment.getEnvironmentSpecificBlock(env, closure);
    }

    public static Closure getEnvironmentSpecificBlock(Environment env, Closure closure) {
        if (closure == null) {
            return null;
        }
        EnvironmentBlockEvaluator evaluator = Environment.evaluateEnvironmentSpecificBlock(env, closure);
        return evaluator.getCallable();
    }

    public static Object executeForCurrentEnvironment(Closure closure) {
        Environment env = Environment.getCurrent();
        return Environment.executeForEnvironment(env, closure);
    }

    public static Object executeForEnvironment(Environment env, Closure closure) {
        if (closure == null) {
            return null;
        }
        EnvironmentBlockEvaluator evaluator = Environment.evaluateEnvironmentSpecificBlock(env, closure);
        return evaluator.execute();
    }

    private static EnvironmentBlockEvaluator evaluateEnvironmentSpecificBlock(Environment environment, Closure closure) {
        EnvironmentBlockEvaluator evaluator = new EnvironmentBlockEvaluator(environment);
        closure.setDelegate((Object)evaluator);
        closure.call();
        return evaluator;
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public String getName() {
        if (this.name == null) {
            return this.toString().toLowerCase(Locale.getDefault());
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    static {
        envNameMappings = new HashMap<String, String>(){
            {
                this.put(Environment.DEVELOPMENT_ENVIRONMENT_SHORT_NAME, DEVELOPMENT.getName());
                this.put(Environment.PRODUCTION_ENV_SHORT_NAME, PRODUCTION.getName());
                this.put(Environment.TEST_ENVIRONMENT_SHORT_NAME, TEST.getName());
            }
        };
    }

    private static class EnvironmentBlockEvaluator
    extends GroovyObjectSupport {
        private Environment current;
        private Closure callable;

        public Closure getCallable() {
            return this.callable;
        }

        Object execute() {
            return this.callable == null ? null : this.callable.call();
        }

        private EnvironmentBlockEvaluator(Environment e) {
            this.current = e;
        }

        public void environments(Closure c) {
            if (c != null) {
                c.setDelegate((Object)this);
                c.call();
            }
        }

        public void production(Closure c) {
            if (this.current == PRODUCTION) {
                this.callable = c;
            }
        }

        public void development(Closure c) {
            if (this.current == DEVELOPMENT) {
                this.callable = c;
            }
        }

        public void test(Closure c) {
            if (this.current == TEST) {
                this.callable = c;
            }
        }

        public Object methodMissing(String name, Object args) {
            Object[] argsArray = (Object[])args;
            if (args != null && argsArray.length > 0 && argsArray[0] instanceof Closure) {
                if (this.current == CUSTOM && this.current.getName().equals(name)) {
                    this.callable = (Closure)argsArray[0];
                }
                return null;
            }
            throw new MissingMethodException(name, Environment.class, argsArray);
        }
    }
}

