/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtils {
    public static <K, V> Map newMap(Object ... keysAndValues) {
        if (keysAndValues == null) {
            return Collections.emptyMap();
        }
        if (keysAndValues.length % 2 == 1) {
            throw new IllegalArgumentException("Must have an even number of keys and values");
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < keysAndValues.length; i += 2) {
            map.put(keysAndValues[i], keysAndValues[i + 1]);
        }
        return map;
    }

    public static <T> Set<T> newSet(T ... values) {
        if (values == null) {
            return Collections.emptySet();
        }
        return new HashSet<T>(Arrays.asList(values));
    }

    public static <T> List<T> newList(T ... values) {
        if (values == null) {
            return Collections.emptyList();
        }
        return new ArrayList<T>(Arrays.asList(values));
    }

    public static <K, V> MapBuilder<K, V> map() {
        return CollectionUtils.map(new LinkedHashMap());
    }

    public static <K, V> MapBuilder<K, V> map(Map<K, V> delegate) {
        return new MapBuilder<K, V>(delegate);
    }

    public static <E> ListBuilder<E> list() {
        return CollectionUtils.list(new ArrayList());
    }

    public static <E> ListBuilder<E> list(List<E> delegate) {
        return new ListBuilder<E>(delegate);
    }

    public static <E> SetBuilder<E> set() {
        return CollectionUtils.set(new HashSet());
    }

    public static <E> SetBuilder<E> set(Set<E> delegate) {
        return new SetBuilder<E>(delegate);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetBuilder<E>
    implements Set<E> {
        private final Set<E> delegate;

        public SetBuilder(Set<E> delegate) {
            this.delegate = delegate;
        }

        public SetBuilder<E> e(E e) {
            this.delegate.add(e);
            return this;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] ts) {
            return this.delegate.toArray(ts);
        }

        @Override
        public boolean add(E e) {
            return this.delegate.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> objects) {
            return this.delegate.containsAll(objects);
        }

        @Override
        public boolean addAll(Collection<? extends E> es) {
            return this.delegate.addAll(es);
        }

        @Override
        public boolean retainAll(Collection<?> objects) {
            return this.delegate.retainAll(objects);
        }

        @Override
        public boolean removeAll(Collection<?> objects) {
            return this.delegate.removeAll(objects);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.delegate).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.delegate).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListBuilder<E>
    implements List<E> {
        private final List<E> delegate;

        public ListBuilder(List<E> delegate) {
            this.delegate = delegate;
        }

        public ListBuilder<E> e(E e) {
            this.delegate.add(e);
            return this;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] ts) {
            return this.delegate.toArray(ts);
        }

        @Override
        public boolean add(E e) {
            return this.delegate.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> objects) {
            return this.delegate.containsAll(objects);
        }

        @Override
        public boolean addAll(Collection<? extends E> es) {
            return this.delegate.addAll(es);
        }

        @Override
        public boolean addAll(int i, Collection<? extends E> es) {
            return this.delegate.addAll(i, es);
        }

        @Override
        public boolean removeAll(Collection<?> objects) {
            return this.delegate.removeAll(objects);
        }

        @Override
        public boolean retainAll(Collection<?> objects) {
            return this.delegate.retainAll(objects);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.delegate).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.delegate).hashCode();
        }

        @Override
        public E get(int i) {
            return this.delegate.get(i);
        }

        @Override
        public E set(int i, E e) {
            return this.delegate.set(i, e);
        }

        @Override
        public void add(int i, E e) {
            this.delegate.add(i, e);
        }

        @Override
        public E remove(int i) {
            return this.delegate.remove(i);
        }

        @Override
        public int indexOf(Object o) {
            return this.delegate.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.delegate.lastIndexOf(o);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.delegate.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int i) {
            return this.delegate.listIterator(i);
        }

        @Override
        public List<E> subList(int i, int i1) {
            return this.delegate.subList(i, i1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapBuilder<K, V>
    implements Map<K, V> {
        private final Map<K, V> delegate;

        public MapBuilder(Map<K, V> delegate) {
            this.delegate = delegate;
        }

        public MapBuilder<K, V> e(K k, V v) {
            this.delegate.put(k, v);
            return this;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object o) {
            return this.delegate.containsKey(o);
        }

        @Override
        public boolean containsValue(Object o) {
            return this.delegate.containsValue(o);
        }

        @Override
        public V get(Object o) {
            return this.delegate.get(o);
        }

        @Override
        public V put(K k, V v) {
            return this.delegate.put(k, v);
        }

        @Override
        public V remove(Object o) {
            return this.delegate.remove(o);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            this.delegate.putAll(map);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.delegate.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.delegate.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.delegate).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.delegate).hashCode();
        }
    }
}

