/*
 * Decompiled with CFR 0.152.
 */
package griffon.core.resources.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class URIPropertyEditor
extends AbstractPropertyEditor {
    public void setAsText(String value) throws IllegalArgumentException {
        this.setValue(value);
    }

    public void setValue(Object value) {
        if (null == value) {
            return;
        }
        if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof File) {
            this.handleAsFile((File)value);
        } else if (value instanceof URI) {
            super.setValue(value);
        } else {
            throw this.illegalValue(value, URI.class);
        }
    }

    private void handleAsString(String str) {
        try {
            super.setValue(new URI(str));
        }
        catch (URISyntaxException e) {
            throw this.illegalValue(str, URI.class, e);
        }
    }

    private void handleAsFile(File file) {
        super.setValue(file.toURI());
    }
}

