/*
 * Decompiled with CFR 0.152.
 */
package griffon.core;

import griffon.core.ThreadingHandler;
import griffon.util.ApplicationClassLoader;
import griffon.util.CallableWithArgs;
import griffon.util.CallableWithArgsClosure;
import griffon.util.RunnableWithArgs;
import griffon.util.RunnableWithArgsClosure;
import griffon.util.UIThreadHandler;
import groovy.lang.Closure;
import groovy.lang.DelegatingMetaClass;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MissingMethodException;
import groovy.lang.Script;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.codehaus.griffon.runtime.util.CallableWithArgsMetaMethod;
import org.codehaus.griffon.runtime.util.ExecutorServiceHolder;
import org.codehaus.griffon.runtime.util.RunnableWithArgsMetaMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UIThreadManager {
    private UIThreadHandler uiThreadHandler;
    private static final ExecutorService DEFAULT_EXECUTOR_SERVICE = ExecutorServiceHolder.add(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
    private static final Logger LOG = LoggerFactory.getLogger(UIThreadManager.class);
    private static final UIThreadManager INSTANCE = new UIThreadManager();
    private static Class[] EXEC_METHOD_ARGS = new Class[]{Runnable.class};
    private static final String EXECUTE_INSIDE_UI_SYNC = "execInsideUISync";
    private static final RunnableWithArgs EXECUTE_INSIDE_UI_SYNC_RUNNER = new RunnableRunner("execInsideUISync"){

        protected void withRunnable(Runnable runnable) {
            INSTANCE.executeSync(runnable);
        }
    };
    private static final Closure EXECUTE_INSIDE_UI_SYNC_CLOSURE = new RunnableWithArgsClosure(INSTANCE, EXECUTE_INSIDE_UI_SYNC_RUNNER);
    private static final MetaMethod EXECUTE_INSIDE_UI_SYNC_METHOD = new RunnableWithArgsMetaMethod("execInsideUISync", UIThreadManager.class, EXECUTE_INSIDE_UI_SYNC_RUNNER, EXEC_METHOD_ARGS);
    private static final String EXECUTE_INSIDE_UI_ASYNC = "execInsideUIAsync";
    private static final RunnableWithArgs EXECUTE_INSIDE_UI_ASYNC_RUNNER = new RunnableRunner("execInsideUIAsync"){

        protected void withRunnable(Runnable runnable) {
            INSTANCE.executeAsync(runnable);
        }
    };
    private static final Closure EXECUTE_INSIDE_UI_ASYNC_CLOSURE = new RunnableWithArgsClosure(INSTANCE, EXECUTE_INSIDE_UI_ASYNC_RUNNER);
    private static final MetaMethod EXECUTE_INSIDE_UI_ASYNC_METHOD = new RunnableWithArgsMetaMethod("execInsideUIAsync", UIThreadManager.class, EXECUTE_INSIDE_UI_ASYNC_RUNNER, EXEC_METHOD_ARGS);
    private static final String EXECUTE_OUTSIDE_UI = "execOutsideUI";
    private static final RunnableWithArgs EXECUTE_OUTSIDE_UI_RUNNER = new RunnableRunner("execOutsideUI"){

        protected void withRunnable(Runnable runnable) {
            INSTANCE.executeOutside(runnable);
        }
    };
    private static final Closure EXECUTE_OUTSIDE_UI_CLOSURE = new RunnableWithArgsClosure(INSTANCE, EXECUTE_OUTSIDE_UI_RUNNER);
    private static final MetaMethod EXECUTE_OUTSIDE_UI_METHOD = new RunnableWithArgsMetaMethod("execOutsideUI", UIThreadManager.class, EXECUTE_OUTSIDE_UI_RUNNER, EXEC_METHOD_ARGS);
    private static final String IS_UITHREAD = "isUIThread";
    private static final CallableWithArgs IS_UITHREAD_CALLABLE = new CallableWithArgs<Boolean>(){

        @Override
        public Boolean call(Object[] args) {
            if (args.length == 0) {
                return INSTANCE.isUIThread();
            }
            throw new MissingMethodException(UIThreadManager.IS_UITHREAD, UIThreadManager.class, args);
        }
    };
    private static final Closure IS_UITHREAD_CLOSURE = new CallableWithArgsClosure(INSTANCE, IS_UITHREAD_CALLABLE);
    private static final MetaMethod IS_UITHREAD_METHOD = new CallableWithArgsMetaMethod("isUIThread", UIThreadManager.class, IS_UITHREAD_CALLABLE, new Class[0]);
    private static final String EXECUTE_FUTURE = "execFuture";
    private static final Closure EXECUTE_FUTURE_CLOSURE = new CallableWithArgsClosure<Future>(new CallableWithArgs<Future>(){

        @Override
        public Future call(Object[] args) {
            if (args.length == 1 && args[0] instanceof Callable) {
                return INSTANCE.executeFuture((Callable)args[0]);
            }
            if (args.length == 2 && args[0] instanceof ExecutorService && args[1] instanceof Callable) {
                return INSTANCE.executeFuture((ExecutorService)args[0], (Callable)args[1]);
            }
            throw new MissingMethodException(UIThreadManager.EXECUTE_FUTURE, UIThreadManager.class, args);
        }
    });
    private static final MetaMethod EXECUTE_FUTURE_METHOD1 = new CallableWithArgsMetaMethod("execFuture", UIThreadManager.class, new CallableWithArgs<Future>(){

        @Override
        public Future call(Object[] args) {
            if (args.length == 1 && args[0] instanceof Callable) {
                return INSTANCE.executeFuture((Callable)args[0]);
            }
            throw new MissingMethodException(UIThreadManager.EXECUTE_FUTURE, UIThreadManager.class, args);
        }
    }, new Class[]{Callable.class});
    private static final MetaMethod EXECUTE_FUTURE_METHOD2 = new CallableWithArgsMetaMethod("execFuture", UIThreadManager.class, new CallableWithArgs<Future>(){

        @Override
        public Future call(Object[] args) {
            if (args.length == 2 && args[0] instanceof ExecutorService && args[1] instanceof Callable) {
                return INSTANCE.executeFuture((ExecutorService)args[0], (Callable)args[1]);
            }
            throw new MissingMethodException(UIThreadManager.EXECUTE_FUTURE, UIThreadManager.class, args);
        }
    }, new Class[]{ExecutorService.class, Callable.class});
    public static final String[] THREADING_METHOD_NAMES = new String[]{"execInsideUISync", "execInsideUISync", "execOutsideUI", "isUIThread", "execFuture"};

    public static UIThreadManager getInstance() {
        return INSTANCE;
    }

    private UIThreadManager() {
    }

    public static void enhance(Script script) {
        if (script instanceof ThreadingHandler) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Enhancing script " + script);
        }
        script.getBinding().setVariable(EXECUTE_INSIDE_UI_SYNC, (Object)EXECUTE_INSIDE_UI_SYNC_CLOSURE);
        script.getBinding().setVariable(EXECUTE_INSIDE_UI_ASYNC, (Object)EXECUTE_INSIDE_UI_ASYNC_CLOSURE);
        script.getBinding().setVariable(EXECUTE_OUTSIDE_UI, (Object)EXECUTE_OUTSIDE_UI_CLOSURE);
        script.getBinding().setVariable(IS_UITHREAD, (Object)IS_UITHREAD_CLOSURE);
        script.getBinding().setVariable(EXECUTE_FUTURE, (Object)EXECUTE_FUTURE_CLOSURE);
    }

    public static void enhance(MetaClass mc) {
        if (null == mc) {
            return;
        }
        ExpandoMetaClass emc = null;
        if (mc instanceof DelegatingMetaClass) {
            mc = ((DelegatingMetaClass)mc).getAdaptee();
        }
        if (mc instanceof ExpandoMetaClass) {
            emc = (ExpandoMetaClass)mc;
        }
        if (null == emc) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Enhancing metaClass " + emc);
        }
        emc.registerInstanceMethod(EXECUTE_INSIDE_UI_SYNC_METHOD);
        emc.registerInstanceMethod(EXECUTE_INSIDE_UI_ASYNC_METHOD);
        emc.registerInstanceMethod(EXECUTE_OUTSIDE_UI_METHOD);
        emc.registerInstanceMethod(IS_UITHREAD_METHOD);
        emc.registerInstanceMethod(EXECUTE_FUTURE_METHOD1);
        emc.registerInstanceMethod(EXECUTE_FUTURE_METHOD2);
    }

    public void setUIThreadHandler(UIThreadHandler threadHandler) {
        this.uiThreadHandler = threadHandler;
    }

    public UIThreadHandler getUIThreadHandler() {
        if (this.uiThreadHandler == null) {
            try {
                this.setUIThreadHandler((UIThreadHandler)ApplicationClassLoader.get().loadClass("griffon.swing.SwingUIThreadHandler").newInstance());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Can't locate a suitable UIThreadHandler.", e);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Can't locate a suitable UIThreadHandler.", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Can't locate a suitable UIThreadHandler.", e);
            }
        }
        return this.uiThreadHandler;
    }

    public boolean isUIThread() {
        return this.getUIThreadHandler().isUIThread();
    }

    public void executeAsync(Runnable runnable) {
        this.getUIThreadHandler().executeAsync(runnable);
    }

    public void executeAsync(final Script script) {
        this.getUIThreadHandler().executeAsync(new Runnable(){

            public void run() {
                script.run();
            }
        });
    }

    public void executeSync(Runnable runnable) {
        this.getUIThreadHandler().executeSync(runnable);
    }

    public void executeSync(final Script script) {
        this.getUIThreadHandler().executeSync(new Runnable(){

            public void run() {
                script.run();
            }
        });
    }

    public void executeOutside(Runnable runnable) {
        this.getUIThreadHandler().executeOutside(runnable);
    }

    public void executeOutside(final Script script) {
        this.getUIThreadHandler().executeOutside(new Runnable(){

            public void run() {
                script.run();
            }
        });
    }

    public <R> Future<R> executeFuture(Callable<R> callable) {
        return this.executeFuture(DEFAULT_EXECUTOR_SERVICE, callable);
    }

    public <R> Future<R> executeFuture(ExecutorService executorService, Callable<R> callable) {
        executorService = executorService != null ? executorService : DEFAULT_EXECUTOR_SERVICE;
        return executorService.submit(callable);
    }

    private static abstract class RunnableRunner
    extends RunnableWithArgs {
        private final String methodName;

        protected RunnableRunner(String methodName) {
            this.methodName = methodName;
        }

        public void run(Object[] args) {
            if (args != null && args.length == 1 && args[0] instanceof Runnable) {
                this.withRunnable((Runnable)args[0]);
                return;
            }
            throw new MissingMethodException(this.methodName, UIThreadManager.class, args);
        }

        protected abstract void withRunnable(Runnable var1);
    }
}

