/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.RolePrincipal;
import org.apache.karaf.jaas.modules.UserPrincipal;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCBackingEngine
implements BackingEngine {
    private final Logger logger = LoggerFactory.getLogger(JDBCBackingEngine.class);
    private DataSource dataSource;
    private EncryptionSupport encryptionSupport;
    private static final String MSG_CONNECTION_CLOSE_FAILED = "Failed to clearly close connection to the database:";
    private String addUserStatement = "INSERT INTO USERS VALUES(?,?)";
    private String addRoleStatement = "INSERT INTO ROLES VALUES(?,?)";
    private String deleteRoleStatement = "DELETE FROM ROLES WHERE USERNAME=? AND ROLE=?";
    private String deleteAllUserRolesStatement = "DELETE FROM ROLES WHERE USERNAME=?";
    private String deleteUserStatement = "DELETE FROM USERS WHERE USERNAME=?";
    private String selectUsersQuery = "SELECT USERNAME FROM USERS";
    private String selectRolesQuery = "SELECT ROLE FROM ROLES WHERE USERNAME=?";

    public JDBCBackingEngine(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public JDBCBackingEngine(DataSource dataSource, EncryptionSupport encryptionSupport) {
        this.dataSource = dataSource;
        this.encryptionSupport = encryptionSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUser(String username, String password) {
        Connection connection = null;
        Statement statement = null;
        String newPassword = password;
        if (this.encryptionSupport != null && this.encryptionSupport.getEncryption() != null) {
            newPassword = this.encryptionSupport.getEncryption().encryptPassword(password);
            if (this.encryptionSupport.getEncryptionPrefix() != null) {
                newPassword = this.encryptionSupport.getEncryptionPrefix() + newPassword;
            }
            if (this.encryptionSupport.getEncryptionSuffix() != null) {
                newPassword = newPassword + this.encryptionSupport.getEncryptionSuffix();
            }
        }
        if (this.dataSource != null) {
            try {
                connection = this.dataSource.getConnection();
                statement = connection.prepareStatement(this.addUserStatement);
                statement.setString(1, username);
                statement.setString(2, newPassword);
                int rows = statement.executeUpdate();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(String.format("Executiong [%s], USERNAME=%s, PASSWORD=%s. %i rows affected.", this.addUserStatement, username, newPassword, rows));
                }
            }
            catch (SQLException e) {
                this.logger.error("Error executiong statement", (Throwable)e);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    this.logger.warn(MSG_CONNECTION_CLOSE_FAILED, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteUser(String username) {
        Connection connection = null;
        Statement userStatement = null;
        PreparedStatement roleStatement = null;
        if (this.dataSource != null) {
            try {
                connection = this.dataSource.getConnection();
                roleStatement = connection.prepareStatement(this.deleteAllUserRolesStatement);
                roleStatement.setString(1, username);
                roleStatement.executeUpdate();
                userStatement = connection.prepareStatement(this.deleteUserStatement);
                userStatement.setString(1, username);
                int userRows = userStatement.executeUpdate();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(String.format("Executiong [%s], USERNAME=%s. %i userRows affected.", this.deleteUserStatement, username, userRows));
                }
            }
            catch (SQLException e) {
                this.logger.error("Error executiong statement", (Throwable)e);
            }
            finally {
                try {
                    if (userStatement != null) {
                        userStatement.close();
                    }
                    if (roleStatement != null) {
                        roleStatement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    this.logger.warn(MSG_CONNECTION_CLOSE_FAILED, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserPrincipal> listUsers() {
        ArrayList<UserPrincipal> users = new ArrayList<UserPrincipal>();
        Connection connection = null;
        PreparedStatement listUserStatement = null;
        ResultSet usersResultSet = null;
        if (this.dataSource != null) {
            try {
                connection = this.dataSource.getConnection();
                listUserStatement = connection.prepareStatement(this.selectUsersQuery);
                usersResultSet = listUserStatement.executeQuery();
                while (!usersResultSet.next()) {
                    String username = usersResultSet.getString("USERNAME");
                    users.add(new UserPrincipal(username));
                }
            }
            catch (SQLException e) {
                this.logger.error("Error executiong statement", (Throwable)e);
            }
            finally {
                try {
                    if (usersResultSet != null) {
                        usersResultSet.close();
                    }
                    if (listUserStatement != null) {
                        listUserStatement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    this.logger.warn(MSG_CONNECTION_CLOSE_FAILED, (Throwable)e);
                }
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RolePrincipal> listRoles(UserPrincipal user) {
        ArrayList<RolePrincipal> roles = new ArrayList<RolePrincipal>();
        Connection connection = null;
        PreparedStatement listRolesStatement = null;
        ResultSet rolesResultSet = null;
        if (this.dataSource != null) {
            try {
                connection = this.dataSource.getConnection();
                listRolesStatement = connection.prepareStatement(this.selectRolesQuery);
                listRolesStatement.setString(1, user.getName());
                rolesResultSet = listRolesStatement.executeQuery();
                while (!rolesResultSet.next()) {
                    String role = rolesResultSet.getString(1);
                    roles.add(new RolePrincipal(role));
                }
            }
            catch (SQLException e) {
                this.logger.error("Error executiong statement", (Throwable)e);
            }
            finally {
                try {
                    if (rolesResultSet != null) {
                        rolesResultSet.close();
                    }
                    if (listRolesStatement != null) {
                        listRolesStatement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    this.logger.warn(MSG_CONNECTION_CLOSE_FAILED, (Throwable)e);
                }
            }
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRole(String username, String role) {
        Connection connection = null;
        Statement statement = null;
        if (this.dataSource != null) {
            try {
                connection = this.dataSource.getConnection();
                statement = connection.prepareStatement(this.addRoleStatement);
                statement.setString(1, username);
                statement.setString(2, role);
                int rows = statement.executeUpdate();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(String.format("Executiong [%s], USERNAME=%s, ROLE=%s. %i rows affected.", this.addRoleStatement, username, role, rows));
                }
            }
            catch (SQLException e) {
                this.logger.error("Error executiong statement", (Throwable)e);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    this.logger.warn(MSG_CONNECTION_CLOSE_FAILED, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRole(String username, String role) {
        Connection connection = null;
        Statement statement = null;
        if (this.dataSource != null) {
            try {
                connection = this.dataSource.getConnection();
                statement = connection.prepareStatement(this.deleteRoleStatement);
                statement.setString(1, username);
                statement.setString(2, role);
                int rows = statement.executeUpdate();
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(String.format("Executiong [%s], USERNAME=%s, ROLE=%s. %i rows affected.", this.deleteRoleStatement, username, role, rows));
                }
            }
            catch (SQLException e) {
                this.logger.error("Error executing statement", (Throwable)e);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    this.logger.warn(MSG_CONNECTION_CLOSE_FAILED, (Throwable)e);
                }
            }
        }
    }

    public String getAddUserStatement() {
        return this.addUserStatement;
    }

    public void setAddUserStatement(String addUserStatement) {
        this.addUserStatement = addUserStatement;
    }

    public String getAddRoleStatement() {
        return this.addRoleStatement;
    }

    public void setAddRoleStatement(String addRoleStatement) {
        this.addRoleStatement = addRoleStatement;
    }

    public String getDeleteRoleStatement() {
        return this.deleteRoleStatement;
    }

    public void setDeleteRoleStatement(String deleteRoleStatement) {
        this.deleteRoleStatement = deleteRoleStatement;
    }

    public String getDeleteAllUserRolesStatement() {
        return this.deleteAllUserRolesStatement;
    }

    public void setDeleteAllUserRolesStatement(String deleteAllUserRolesStatement) {
        this.deleteAllUserRolesStatement = deleteAllUserRolesStatement;
    }

    public String getDeleteUserStatement() {
        return this.deleteUserStatement;
    }

    public void setDeleteUserStatement(String deleteUserStatement) {
        this.deleteUserStatement = deleteUserStatement;
    }

    public String getSelectUsersQuery() {
        return this.selectUsersQuery;
    }

    public void setSelectUsersQuery(String selectUsersQuery) {
        this.selectUsersQuery = selectUsersQuery;
    }

    public String getSelectRolesQuery() {
        return this.selectRolesQuery;
    }

    public void setSelectRolesQuery(String selectRolesQuery) {
        this.selectRolesQuery = selectRolesQuery;
    }
}

