/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.detection;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.internal.file.RelativeFile;
import org.gradle.api.internal.tasks.testing.DefaultTestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.detection.ClassFileExtractionManager;
import org.gradle.api.internal.tasks.testing.detection.TestClassVisitor;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.FileUtils;
import org.gradle.internal.IoActions;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestFrameworkDetector<T extends TestClassVisitor>
implements TestFrameworkDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTestFrameworkDetector.class);
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private List<File> testClassDirectories;
    private final ClassFileExtractionManager classFileExtractionManager;
    private final Map<File, Boolean> superClasses;
    private TestClassProcessor testClassProcessor;
    private List<File> testClassesDirectories;
    private List<File> testClasspath;

    protected AbstractTestFrameworkDetector(ClassFileExtractionManager classFileExtractionManager) {
        assert (classFileExtractionManager != null);
        this.classFileExtractionManager = classFileExtractionManager;
        this.superClasses = new HashMap<File, Boolean>();
    }

    protected abstract T createClassVisitor();

    private File getSuperTestClassFile(String superClassName) {
        this.prepareClasspath();
        if (StringUtils.isEmpty((CharSequence)superClassName)) {
            throw new IllegalArgumentException("superClassName is empty!");
        }
        File superTestClassFile = null;
        for (File testClassDirectory : this.testClassDirectories) {
            File candidate = new File(testClassDirectory, superClassName + ".class");
            if (!candidate.exists()) continue;
            superTestClassFile = candidate;
        }
        if (superTestClassFile != null) {
            return superTestClassFile;
        }
        if (JAVA_LANG_OBJECT.equals(superClassName)) {
            return null;
        }
        return this.classFileExtractionManager.getLibraryClassFile(superClassName);
    }

    private void prepareClasspath() {
        if (this.testClassDirectories != null) {
            return;
        }
        this.testClassDirectories = new ArrayList<File>();
        if (this.testClassesDirectories != null) {
            this.testClassDirectories.addAll(this.testClassesDirectories);
        }
        if (this.testClasspath != null) {
            for (File file : this.testClasspath) {
                if (file.isDirectory()) {
                    this.testClassDirectories.add(file);
                    continue;
                }
                if (!file.isFile() || !FileUtils.hasExtension((File)file, (String)".jar")) continue;
                this.classFileExtractionManager.addLibraryJar(file);
            }
        }
    }

    @Override
    public void setTestClasses(List<File> testClassesDirectories) {
        this.testClassesDirectories = testClassesDirectories;
    }

    @Override
    public void setTestClasspath(List<File> testClasspath) {
        this.testClasspath = testClasspath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestClass readClassFile(File testClassFile, Factory<String> fallbackClassNameProvider) {
        TestClass testClass;
        T classVisitor = this.createClassVisitor();
        BufferedInputStream classStream = null;
        try {
            classStream = new BufferedInputStream(new FileInputStream(testClassFile));
            ClassReader classReader = new ClassReader(IOUtils.toByteArray((InputStream)classStream));
            classReader.accept(classVisitor, 7);
            testClass = TestClass.forParseableFile(classVisitor);
        }
        catch (Throwable e) {
            TestClass testClass2;
            try {
                LOGGER.debug("Failed to read class file " + testClassFile.getAbsolutePath() + "; assuming it's a test class and continuing", e);
                testClass2 = TestClass.forUnparseableFile((String)fallbackClassNameProvider.create());
            }
            catch (Throwable throwable) {
                IoActions.closeQuietly(classStream);
                throw throwable;
            }
            IoActions.closeQuietly((Closeable)classStream);
            return testClass2;
        }
        IoActions.closeQuietly((Closeable)classStream);
        return testClass;
    }

    @Override
    public boolean processTestClass(final RelativeFile testClassFile) {
        return this.processTestClass(testClassFile.getFile(), false, new Factory<String>(){

            public String create() {
                return testClassFile.getRelativePath().getPathString().replace(".class", "");
            }
        });
    }

    private boolean processTestClass(File testClassFile, boolean superClass, Factory<String> fallbackClassNameProvider) {
        TestClass testClass = this.readClassFile(testClassFile, fallbackClassNameProvider);
        boolean isTest = testClass.isTest();
        if (!isTest) {
            String superClassName = testClass.getSuperClassName();
            if (this.isKnownTestCaseClassName(superClassName)) {
                isTest = true;
            } else {
                File superClassFile = this.getSuperTestClassFile(superClassName);
                if (superClassFile != null) {
                    isTest = this.processSuperClass(superClassFile, superClassName);
                } else {
                    LOGGER.debug("test-class-scan : failed to scan parent class {}, could not find the class file", (Object)superClassName);
                }
            }
        }
        this.publishTestClass(isTest, testClass, superClass);
        return isTest;
    }

    protected abstract boolean isKnownTestCaseClassName(String var1);

    private boolean processSuperClass(File testClassFile, String superClassName) {
        boolean isTest;
        Boolean isSuperTest = this.superClasses.get(testClassFile);
        if (isSuperTest == null) {
            isTest = this.processTestClass(testClassFile, true, (Factory<String>)Factories.constant((Object)superClassName));
            this.superClasses.put(testClassFile, isTest);
        } else {
            isTest = isSuperTest;
        }
        return isTest;
    }

    private void publishTestClass(boolean isTest, TestClass testClass, boolean superClass) {
        if (isTest && !testClass.isAbstract() && !superClass) {
            String className = Type.getObjectType((String)testClass.getClassName()).getClassName();
            this.testClassProcessor.processTestClass((TestClassRunInfo)new DefaultTestClassRunInfo(className));
        }
    }

    @Override
    public void startDetection(TestClassProcessor testClassProcessor) {
        this.testClassProcessor = testClassProcessor;
    }

    private static class TestClass {
        private final boolean test;
        private final boolean isAbstract;
        private final String className;
        private final String superClassName;

        static TestClass forParseableFile(TestClassVisitor testClassVisitor) {
            return new TestClass(testClassVisitor.isTest(), testClassVisitor.isAbstract(), testClassVisitor.getClassName(), testClassVisitor.getSuperClassName());
        }

        static TestClass forUnparseableFile(String className) {
            return new TestClass(true, false, className, null);
        }

        private TestClass(boolean test, boolean isAbstract, String className, String superClassName) {
            this.test = test;
            this.isAbstract = isAbstract;
            this.className = className;
            this.superClassName = superClassName;
        }

        boolean isTest() {
            return this.test;
        }

        boolean isAbstract() {
            return this.isAbstract;
        }

        String getClassName() {
            return this.className;
        }

        String getSuperClassName() {
            return this.superClassName;
        }
    }
}

