/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results;

import java.io.Serializable;
import java.util.List;
import org.gradle.api.internal.tasks.testing.results.TestState;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.InternalTransformer;
import org.gradle.util.internal.CollectionUtils;
import org.jspecify.annotations.Nullable;

public class DefaultTestResult
implements TestResult,
Serializable {
    private final List<TestFailure> failures;
    private final @Nullable TestFailure assumptionFailure;
    private final TestResult.ResultType resultType;
    private final long startTime;
    private final long endTime;
    private final long testCount;
    private final long successfulCount;
    private final long failedCount;

    public DefaultTestResult(TestState state) {
        this(state.resultType, state.getStartTime(), state.getEndTime(), state.testCount, state.successfulCount, state.failedCount, state.failures, state.assumptionFailure);
    }

    public DefaultTestResult(TestResult.ResultType resultType, long startTime, long endTime, long testCount, long successfulCount, long failedCount, List<TestFailure> failures, @Nullable TestFailure assumptionFailure) {
        this.resultType = resultType;
        this.startTime = startTime;
        this.endTime = endTime;
        this.testCount = testCount;
        this.successfulCount = successfulCount;
        this.failedCount = failedCount;
        this.failures = failures;
        this.assumptionFailure = assumptionFailure;
    }

    public TestResult.ResultType getResultType() {
        return this.resultType;
    }

    public Throwable getException() {
        return this.failures.isEmpty() ? null : this.failures.get(0).getRawFailure();
    }

    public @Nullable TestFailure getAssumptionFailure() {
        return this.assumptionFailure;
    }

    public List<Throwable> getExceptions() {
        return CollectionUtils.collect(this.failures, (InternalTransformer)new InternalTransformer<Throwable, TestFailure>(){

            public Throwable transform(TestFailure testFailure) {
                return testFailure.getRawFailure();
            }
        });
    }

    public List<TestFailure> getFailures() {
        return this.failures;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getTestCount() {
        return this.testCount;
    }

    public long getSuccessfulTestCount() {
        return this.successfulCount;
    }

    public long getSkippedTestCount() {
        return this.testCount - this.successfulCount - this.failedCount;
    }

    public long getFailedTestCount() {
        return this.failedCount;
    }

    public String toString() {
        return this.resultType.toString();
    }
}

