/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Optional;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.internal.project.taskfactory.IncrementalTaskAction;
import org.gradle.api.internal.project.taskfactory.StandardTaskAction;
import org.gradle.api.internal.project.taskfactory.TaskActionFactory;
import org.gradle.api.internal.project.taskfactory.TaskClassInfo;
import org.gradle.api.internal.project.taskfactory.TaskClassInfoStore;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.properties.annotations.FunctionMetadata;
import org.gradle.internal.properties.annotations.TypeMetadata;
import org.gradle.internal.properties.annotations.TypeMetadataStore;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.work.InputChanges;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class DefaultTaskClassInfoStore
implements TaskClassInfoStore {
    private final CrossBuildInMemoryCache<Class<?>, TaskClassInfo> classInfos;
    private final TypeMetadataStore typeMetadataStore;

    public DefaultTaskClassInfoStore(CrossBuildInMemoryCacheFactory cacheFactory, TypeMetadataStore typeMetadataStore) {
        this.classInfos = cacheFactory.newClassCache();
        this.typeMetadataStore = typeMetadataStore;
    }

    @Override
    public TaskClassInfo getTaskClassInfo(Class<? extends Task> type) {
        return (TaskClassInfo)this.classInfos.get(type, aClass -> this.createTaskClassInfo(aClass.asSubclass(Task.class)));
    }

    private TaskClassInfo createTaskClassInfo(Class<? extends Task> type) {
        TypeMetadata typeMetadata = this.typeMetadataStore.getTypeMetadata(type);
        boolean cacheable = typeMetadata.getTypeAnnotationMetadata().isAnnotationPresent(CacheableTask.class);
        Optional<String> reasonNotToTrackState = typeMetadata.getTypeAnnotationMetadata().getAnnotation(UntrackedTask.class).map(UntrackedTask::because);
        HashMap functions = new HashMap();
        ImmutableList.Builder taskActionFactoriesBuilder = ImmutableList.builder();
        typeMetadata.getFunctionMetadata().stream().filter(functionMetadata -> functionMetadata.getAnnotation(TaskAction.class).isPresent()).forEach(functionMetadata -> {
            TaskActionFactory taskActionFactory;
            FunctionMetadata alreadySeen = functions.put(functionMetadata.getMethodName(), functionMetadata);
            if (alreadySeen != null) {
                throw new GradleException(String.format("Cannot use @TaskAction annotation on multiple overloads of method %s.%s()", typeMetadata.getType().getSimpleName(), functionMetadata.getMethod().getName()));
            }
            Class<?> declaringClass = functionMetadata.getMethod().getDeclaringClass();
            Class<?>[] parameterTypes = functionMetadata.getMethod().getParameterTypes();
            if (parameterTypes.length > 1) {
                throw new GradleException(String.format("Cannot use @TaskAction annotation on method %s.%s() as this method takes multiple parameters.", declaringClass.getSimpleName(), functionMetadata.getMethodName()));
            }
            if (functionMetadata.getMethod().getParameterTypes().length == 1) {
                Class<?> parameterType = parameterTypes[0];
                if (!parameterType.equals(InputChanges.class)) {
                    throw new GradleException(String.format("Cannot use @TaskAction annotation on method %s.%s() because %s is not a valid parameter to an action method.", declaringClass.getSimpleName(), functionMetadata.getMethodName(), parameterType));
                }
                taskActionFactory = new IncrementalTaskActionFactory(type, functionMetadata.getMethod());
            } else {
                taskActionFactory = new StandardTaskActionFactory(type, functionMetadata.getMethod());
            }
            taskActionFactoriesBuilder.add((Object)taskActionFactory);
        });
        if (functions.values().stream().filter(functionMetadata -> functionMetadata.getMethod().getParameterTypes().length > 0).count() > 1L) {
            throw new GradleException(String.format("Cannot have multiple @TaskAction methods accepting an %s parameter.", InputChanges.class.getSimpleName()));
        }
        return new TaskClassInfo((ImmutableList<TaskActionFactory>)taskActionFactoriesBuilder.build(), cacheable, reasonNotToTrackState, typeMetadata);
    }

    private static class IncrementalTaskActionFactory
    implements TaskActionFactory {
        private final Class<? extends Task> taskType;
        private final Method method;

        public IncrementalTaskActionFactory(Class<? extends Task> taskType, Method method) {
            this.taskType = taskType;
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        @Override
        public Action<? super Task> create(Instantiator instantiator) {
            return new IncrementalTaskAction(this.taskType, this.method);
        }
    }

    private static class StandardTaskActionFactory
    implements TaskActionFactory {
        private final Class<? extends Task> taskType;
        private final Method method;

        public StandardTaskActionFactory(Class<? extends Task> taskType, Method method) {
            this.taskType = taskType;
            this.method = method;
        }

        @Override
        public Action<? super Task> create(Instantiator instantiator) {
            return new StandardTaskAction(this.taskType, this.method);
        }
    }
}

