/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ScopedServiceRegistry;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.Scope;

public class ServiceRegistryBuilder {
    private final List<ServiceRegistry> parents = new ArrayList<ServiceRegistry>();
    private final List<ServiceRegistrationProvider> providers = new ArrayList<ServiceRegistrationProvider>();
    private String displayName;
    private Class<? extends Scope> scope;
    private boolean strict;

    private ServiceRegistryBuilder() {
    }

    public static ServiceRegistryBuilder builder() {
        return new ServiceRegistryBuilder();
    }

    public ServiceRegistryBuilder displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public ServiceRegistryBuilder parent(ServiceRegistry parent) {
        this.parents.add(parent);
        return this;
    }

    public ServiceRegistryBuilder provider(ServiceRegistrationProvider provider) {
        this.providers.add(provider);
        return this;
    }

    public ServiceRegistryBuilder scope(Class<? extends Scope> scope) {
        this.scope = scope;
        this.strict = false;
        return this;
    }

    public ServiceRegistryBuilder scopeStrictly(Class<? extends Scope> scope) {
        this.scope = scope;
        this.strict = true;
        return this;
    }

    public ServiceRegistry build() {
        ServiceRegistry[] parents = this.parents.toArray(new ServiceRegistry[0]);
        DefaultServiceRegistry registry = this.scope != null ? new ScopedServiceRegistry(this.scope, this.strict, this.displayName, parents) : new DefaultServiceRegistry(this.displayName, parents);
        for (ServiceRegistrationProvider provider : this.providers) {
            registry.addProvider(provider);
        }
        return registry;
    }
}

