/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.InternalTransformer;
import org.gradle.internal.UncheckedException;

public abstract class InternalTransformers {
    public static <O, I> InternalTransformer<O, I> cast(Class<O> outputType) {
        return new CastingTransformer(outputType);
    }

    public static <T> InternalTransformer<T, T> noOpTransformer() {
        return new InternalTransformer<T, T>(){

            public T transform(T original) {
                return original;
            }
        };
    }

    public static <T> InternalTransformer<String, T> asString() {
        return new ToStringTransformer();
    }

    public static InternalTransformer<String, String> asSafeCommandLineArgument() {
        return new CommandLineArgumentTransformer();
    }

    public static <T> InternalTransformer<Class<T>, T> type() {
        return new InternalTransformer<Class<T>, T>(){

            public Class<T> transform(T original) {
                Class<?> aClass = original.getClass();
                return aClass;
            }
        };
    }

    public static <R> InternalTransformer<R, Object> toTransformer(final Factory<R> factory) {
        return new InternalTransformer<R, Object>(){

            public R transform(Object original) {
                return factory.create();
            }
        };
    }

    public static <R, I> InternalTransformer<R, I> toTransformer(final Action<? super I> action) {
        return new InternalTransformer<R, I>(){

            public R transform(I original) {
                action.execute(original);
                return null;
            }
        };
    }

    public static InternalTransformer<URL, URI> toURL() {
        return new InternalTransformer<URL, URI>(){

            public URL transform(URI original) {
                try {
                    return original.toURL();
                }
                catch (MalformedURLException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        };
    }

    public static <T, I> InternalTransformer<T, I> constant(final T t) {
        return new InternalTransformer<T, I>(){

            public T transform(I original) {
                return t;
            }
        };
    }

    private static class CommandLineArgumentTransformer
    implements InternalTransformer<String, String> {
        private static final Pattern SINGLE_QUOTED = Pattern.compile("^'.*'$");
        private static final Pattern DOUBLE_QUOTED = Pattern.compile("^\".*\"$");
        private static final Pattern A_SINGLE_QUOTE = Pattern.compile("'");

        private CommandLineArgumentTransformer() {
        }

        public String transform(String input) {
            if (SINGLE_QUOTED.matcher(input).matches() || DOUBLE_QUOTED.matcher(input).matches() || !input.contains(" ")) {
                return input;
            }
            return this.wrapWithSingleQuotes(input);
        }

        private String wrapWithSingleQuotes(String input) {
            return String.format("'%1$s'", this.escapeSingleQuotes(input));
        }

        private String escapeSingleQuotes(String input) {
            return A_SINGLE_QUOTE.matcher(input).replaceAll("\\\\'");
        }
    }

    private static class ToStringTransformer<T>
    implements InternalTransformer<String, T> {
        private ToStringTransformer() {
        }

        public String transform(T original) {
            return original == null ? null : original.toString();
        }
    }

    private static class CastingTransformer<O, I>
    implements InternalTransformer<O, I> {
        final Class<O> outputType;

        public CastingTransformer(Class<O> outputType) {
            this.outputType = outputType;
        }

        public O transform(I input) {
            return (O)Cast.cast(this.outputType, input);
        }
    }
}

