/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.plugins.ApplyPluginBuildOperationType;
import org.gradle.api.internal.plugins.DefaultPluginContainer;
import org.gradle.api.internal.plugins.PluginApplicationException;
import org.gradle.api.internal.plugins.PluginImplementation;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.internal.plugins.PluginTarget;
import org.gradle.api.internal.plugins.PotentialPlugin;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.plugins.InvalidPluginException;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.PluginInstantiationException;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.configuration.ConfigurationTargetIdentifier;
import org.gradle.internal.Cast;
import org.gradle.internal.code.DefaultUserCodeSource;
import org.gradle.internal.code.UserCodeApplicationContext;
import org.gradle.internal.code.UserCodeApplicationId;
import org.gradle.internal.code.UserCodeSource;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.operations.trace.CustomOperationTraceSerialization;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.internal.DefaultPluginId;

@NotThreadSafe
public class DefaultPluginManager
implements PluginManagerInternal {
    public static final String CORE_PLUGIN_NAMESPACE = "org.gradle";
    public static final String CORE_PLUGIN_PREFIX = "org.gradle.";
    private final Instantiator instantiator;
    private final PluginTarget target;
    private final PluginRegistry pluginRegistry;
    private final DefaultPluginContainer pluginContainer;
    private final Map<Class<?>, PluginImplementation<?>> plugins = new HashMap();
    private final Map<Class<?>, Plugin> instances = new LinkedHashMap();
    private final Map<PluginId, DomainObjectSet<PluginManagerInternal.PluginWithId>> idMappings = new HashMap<PluginId, DomainObjectSet<PluginManagerInternal.PluginWithId>>();
    private final BuildOperationRunner buildOperationRunner;
    private final UserCodeApplicationContext userCodeApplicationContext;
    private DomainObjectCollectionFactory domainObjectCollectionFactory;
    private static final ApplyPluginBuildOperationType.Result OPERATION_RESULT = new ApplyPluginBuildOperationType.Result(){};

    public DefaultPluginManager(PluginRegistry pluginRegistry, Instantiator instantiator, PluginTarget target, BuildOperationRunner buildOperationRunner, UserCodeApplicationContext userCodeApplicationContext, CollectionCallbackActionDecorator callbackDecorator, DomainObjectCollectionFactory domainObjectCollectionFactory) {
        this.instantiator = instantiator;
        this.target = target;
        this.pluginRegistry = pluginRegistry;
        this.domainObjectCollectionFactory = domainObjectCollectionFactory;
        this.pluginContainer = new DefaultPluginContainer(pluginRegistry, this, callbackDecorator);
        this.buildOperationRunner = buildOperationRunner;
        this.userCodeApplicationContext = userCodeApplicationContext;
    }

    private <T> T instantiatePlugin(Class<T> type) {
        try {
            return (T)this.instantiator.newInstance(type, new Object[0]);
        }
        catch (ObjectInstantiationException e) {
            throw new PluginInstantiationException(String.format("Could not create plugin of type '%s'.", type.getSimpleName()), e.getCause());
        }
    }

    @Override
    public <P extends Plugin> P addImperativePlugin(PluginImplementation<P> plugin) {
        this.doApply(plugin);
        Class pluginClass = plugin.asClass();
        return (P)((Plugin)pluginClass.cast(this.instances.get(pluginClass)));
    }

    @Override
    public <P extends Plugin> P addImperativePlugin(Class<P> type) {
        return this.addImperativePlugin(this.pluginRegistry.inspect(type));
    }

    @Nullable
    private Runnable addPluginInternal(final PluginImplementation<?> plugin) {
        final Class pluginClass = plugin.asClass();
        if (this.plugins.containsKey(pluginClass)) {
            return null;
        }
        this.plugins.put(pluginClass, plugin);
        return new Runnable(){

            @Override
            public void run() {
                ArrayList pluginIds = Lists.newArrayList(DefaultPluginManager.this.idMappings.keySet());
                for (PluginId id : pluginIds) {
                    if (!plugin.isAlsoKnownAs(id)) continue;
                    ((DomainObjectSet)DefaultPluginManager.this.idMappings.get(id)).add((Object)new PluginManagerInternal.PluginWithId(id, pluginClass));
                }
            }
        };
    }

    @Override
    public PluginContainer getPluginContainer() {
        return this.pluginContainer;
    }

    @Override
    public <P extends Plugin<?>> Optional<PluginId> findPluginIdForClass(Class<P> plugin) {
        PluginImplementation<?> pluginImplementation = this.plugins.get(plugin);
        if (pluginImplementation != null) {
            return Optional.ofNullable(pluginImplementation.getPluginId());
        }
        return Optional.empty();
    }

    @Override
    public void apply(PluginImplementation<?> plugin) {
        this.doApply(plugin);
    }

    public void apply(String pluginId) {
        PluginImplementation<?> plugin = this.pluginRegistry.lookup(DefaultPluginId.unvalidated(pluginId));
        if (plugin == null) {
            throw new UnknownPluginException("Plugin with id '" + pluginId + "' not found.");
        }
        this.doApply(plugin);
    }

    public void apply(Class<?> type) {
        this.doApply(this.pluginRegistry.inspect(type));
    }

    private void doApply(PluginImplementation<?> plugin) {
        PluginId pluginId = plugin.getPluginId();
        String pluginIdStr = pluginId == null ? null : pluginId.toString();
        Class pluginClass = plugin.asClass();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(pluginClass.getClassLoader());
            if (plugin.getType().equals((Object)PotentialPlugin.Type.UNKNOWN)) {
                throw new InvalidPluginException("'" + pluginClass.getName() + "' is neither a plugin or a rule source and cannot be applied.");
            }
            Runnable adder = this.addPluginInternal(plugin);
            if (adder != null) {
                DefaultUserCodeSource source = new DefaultUserCodeSource(plugin.getDisplayName(), pluginIdStr);
                this.userCodeApplicationContext.apply((UserCodeSource)source, userCodeApplicationId -> this.buildOperationRunner.run((RunnableBuildOperation)new AddPluginBuildOperation(adder, plugin, pluginIdStr, pluginClass, (UserCodeApplicationId)userCodeApplicationId)));
            }
        }
        catch (PluginApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PluginApplicationException(plugin.getDisplayName(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private void addPlugin(Runnable adder, PluginImplementation<?> plugin, String pluginId, Class<?> pluginClass) {
        boolean imperative = plugin.isImperative();
        if (imperative) {
            Plugin<?> pluginInstance = this.producePluginInstance(pluginClass);
            if (plugin.isHasRules()) {
                this.target.applyImperativeRulesHybrid(pluginId, pluginInstance, pluginClass);
            } else {
                this.target.applyImperative(pluginId, pluginInstance);
            }
            this.instances.put(pluginClass, pluginInstance);
            this.pluginContainer.pluginAdded(pluginInstance);
        } else {
            this.target.applyRules(pluginId, pluginClass);
        }
        adder.run();
    }

    private Plugin<?> producePluginInstance(Class<?> pluginClass) {
        Object instance = this.findInstance(pluginClass, this.pluginContainer);
        if (instance == null) {
            instance = this.instantiatePlugin(pluginClass);
        }
        return (Plugin)Cast.uncheckedCast(instance);
    }

    private <T> T findInstance(Class<T> clazz, Iterable<?> instances) {
        for (Object instance : instances) {
            if (!instance.getClass().equals(clazz)) continue;
            return clazz.cast(instance);
        }
        return null;
    }

    @Override
    public DomainObjectSet<PluginManagerInternal.PluginWithId> pluginsForId(String id) {
        PluginId pluginId = DefaultPluginId.unvalidated(id);
        DomainObjectSet<PluginManagerInternal.PluginWithId> pluginsForId = this.idMappings.get(pluginId);
        if (pluginsForId == null) {
            pluginsForId = this.domainObjectCollectionFactory.newDomainObjectSet(PluginManagerInternal.PluginWithId.class);
            this.idMappings.put(pluginId, pluginsForId);
            for (PluginImplementation<?> plugin : this.plugins.values()) {
                if (!plugin.isAlsoKnownAs(pluginId)) continue;
                pluginsForId.add((Object)new PluginManagerInternal.PluginWithId(pluginId, plugin.asClass()));
            }
        }
        return pluginsForId;
    }

    public AppliedPlugin findPlugin(String id) {
        DomainObjectSet<PluginManagerInternal.PluginWithId> pluginWithIds = this.pluginsForId(id);
        if (!pluginWithIds.isEmpty()) {
            return ((PluginManagerInternal.PluginWithId)pluginWithIds.iterator().next()).asAppliedPlugin();
        }
        return null;
    }

    public boolean hasPlugin(String id) {
        return this.findPlugin(id) != null;
    }

    public void withPlugin(String id, final Action<? super AppliedPlugin> action) {
        Action<PluginManagerInternal.PluginWithId> wrappedAction = new Action<PluginManagerInternal.PluginWithId>(){

            public void execute(PluginManagerInternal.PluginWithId pluginWithId) {
                action.execute((Object)pluginWithId.asAppliedPlugin());
            }
        };
        this.pluginsForId(id).all((Action)wrappedAction);
    }

    public static class OperationDetails
    implements ApplyPluginBuildOperationType.Details,
    CustomOperationTraceSerialization {
        private final PluginImplementation<?> pluginImplementation;
        private final ConfigurationTargetIdentifier targetIdentifier;
        private final UserCodeApplicationId applicationId;

        private OperationDetails(PluginImplementation<?> pluginImplementation, ConfigurationTargetIdentifier targetIdentifier, UserCodeApplicationId applicationId) {
            this.pluginImplementation = pluginImplementation;
            this.targetIdentifier = targetIdentifier;
            this.applicationId = applicationId;
        }

        @Nullable
        public String getPluginId() {
            PluginId pluginId = this.pluginImplementation.getPluginId();
            return pluginId == null ? null : pluginId.getId();
        }

        public Class<?> getPluginClass() {
            return this.pluginImplementation.asClass();
        }

        public String getTargetType() {
            return this.targetIdentifier.getTargetType().label;
        }

        @Nullable
        public String getTargetPath() {
            return this.targetIdentifier.getTargetPath();
        }

        public String getBuildPath() {
            return this.targetIdentifier.getBuildPath();
        }

        public long getApplicationId() {
            return this.applicationId.longValue();
        }

        public Object getCustomOperationTraceSerializableModel() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("pluginId", this.getPluginId());
            map.put("pluginClass", this.getPluginClass().getName());
            map.put("targetType", this.getTargetType());
            map.put("targetPath", this.getTargetPath());
            map.put("buildPath", this.getBuildPath());
            map.put("applicationId", this.getApplicationId());
            return map;
        }
    }

    private class AddPluginBuildOperation
    implements RunnableBuildOperation {
        private final Runnable adder;
        private final PluginImplementation<?> plugin;
        private final String pluginId;
        private final Class<?> pluginClass;
        private final UserCodeApplicationId applicationId;

        private AddPluginBuildOperation(Runnable adder, PluginImplementation<?> plugin, String pluginId, Class<?> pluginClass, UserCodeApplicationId applicationId) {
            this.adder = adder;
            this.plugin = plugin;
            this.pluginId = pluginId;
            this.pluginClass = pluginClass;
            this.applicationId = applicationId;
        }

        public void run(BuildOperationContext context) {
            DefaultPluginManager.this.addPlugin(this.adder, this.plugin, this.pluginId, this.pluginClass);
            context.setResult((Object)OPERATION_RESULT);
        }

        public BuildOperationDescriptor.Builder description() {
            return this.computeApplyPluginBuildOperationDetails(this.plugin);
        }

        private BuildOperationDescriptor.Builder computeApplyPluginBuildOperationDetails(PluginImplementation<?> pluginImplementation) {
            String pluginIdentifier = pluginImplementation.getPluginId() != null ? pluginImplementation.getPluginId().toString() : pluginImplementation.asClass().getName();
            String name = "Apply plugin " + pluginIdentifier;
            return BuildOperationDescriptor.displayName((String)(name + " to " + DefaultPluginManager.this.target.toString())).name(name).details((Object)new OperationDetails(pluginImplementation, DefaultPluginManager.this.target.getConfigurationTargetIdentifier(), this.applicationId));
        }
    }
}

