/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.Category;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.dependencies.SelfResolvingDependencyInternal;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyMetadataFactory;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.ExcludeRuleConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalConfigurationMetadataBuilder;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.DefaultLocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.LocalVariantMetadata;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.component.model.ComponentConfigurationIdentifier;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;

public class DefaultLocalConfigurationMetadataBuilder
implements LocalConfigurationMetadataBuilder {
    private final DependencyMetadataFactory dependencyMetadataFactory;
    private final ExcludeRuleConverter excludeRuleConverter;

    public DefaultLocalConfigurationMetadataBuilder(DependencyMetadataFactory dependencyMetadataFactory, ExcludeRuleConverter excludeRuleConverter) {
        this.dependencyMetadataFactory = dependencyMetadataFactory;
        this.excludeRuleConverter = excludeRuleConverter;
    }

    @Override
    public LocalConfigurationGraphResolveMetadata create(ConfigurationInternal configuration, ConfigurationsProvider configurationsProvider, final ComponentIdentifier componentId, LocalConfigurationMetadataBuilder.DependencyCache dependencyCache, final ModelContainer<?> model, final CalculatedValueContainerFactory calculatedValueContainerFactory) {
        configuration.runDependencyActions();
        configuration.markAsObserved();
        final String configurationName = configuration.getName();
        String description = configuration.getDescription();
        final ComponentConfigurationIdentifier configurationIdentifier = new ComponentConfigurationIdentifier(componentId, configuration.getName());
        ImmutableAttributes attributes = configuration.getAttributes().asImmutable();
        final ImmutableCapabilities capabilities = ImmutableCapabilities.of(Configurations.collectCapabilities(configuration, new HashSet<Capability>(), new HashSet<Configuration>()));
        final ImmutableSet.Builder variantsBuilder = ImmutableSet.builder();
        configuration.collectVariants(new ConfigurationInternal.VariantVisitor(){

            @Override
            public void visitOwnVariant(DisplayName displayName, ImmutableAttributes attributes, Collection<? extends PublishArtifact> artifacts) {
                CalculatedValue variantArtifacts = DefaultLocalConfigurationMetadataBuilder.getVariantArtifacts(displayName, componentId, artifacts, model, calculatedValueContainerFactory);
                variantsBuilder.add((Object)new LocalVariantMetadata(configurationName, (VariantResolveMetadata.Identifier)configurationIdentifier, displayName, attributes, capabilities, (CalculatedValue<ImmutableList<LocalComponentArtifactMetadata>>)variantArtifacts));
            }

            @Override
            public void visitChildVariant(String name, DisplayName displayName, ImmutableAttributes attributes, Collection<? extends PublishArtifact> artifacts) {
                CalculatedValue variantArtifacts = DefaultLocalConfigurationMetadataBuilder.getVariantArtifacts(displayName, componentId, artifacts, model, calculatedValueContainerFactory);
                variantsBuilder.add((Object)new LocalVariantMetadata(configurationName + "-" + name, (VariantResolveMetadata.Identifier)new NestedVariantIdentifier(configurationIdentifier, name), displayName, attributes, capabilities, (CalculatedValue<ImmutableList<LocalComponentArtifactMetadata>>)variantArtifacts));
            }
        });
        ImmutableSet<String> hierarchy = Configurations.getNames(configuration.getHierarchy());
        CalculatedValue<DefaultLocalConfigurationMetadata.ConfigurationDependencyMetadata> dependencies = this.getConfigurationDependencyState(description, hierarchy, attributes, configurationsProvider, dependencyCache, model, calculatedValueContainerFactory);
        CalculatedValue<ImmutableList<LocalComponentArtifactMetadata>> artifacts = DefaultLocalConfigurationMetadataBuilder.getConfigurationArtifacts(configurationName, description, componentId, hierarchy, configurationsProvider, model, calculatedValueContainerFactory);
        return new DefaultLocalConfigurationMetadata(configurationName, description, componentId, configuration.isVisible(), configuration.isTransitive(), (Set<String>)hierarchy, attributes, capabilities, configuration.isCanBeConsumed(), configuration.isDeprecatedForConsumption(), configuration.isCanBeResolved(), dependencies, (Set<LocalVariantMetadata>)variantsBuilder.build(), calculatedValueContainerFactory, artifacts);
    }

    private static CalculatedValue<ImmutableList<LocalComponentArtifactMetadata>> getConfigurationArtifacts(String name, String description, ComponentIdentifier componentId, ImmutableSet<String> hierarchy, ConfigurationsProvider configurationsProvider, ModelContainer<?> model, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        return calculatedValueContainerFactory.create(Describables.of((Object)description, (Object)"artifacts"), context -> (ImmutableList)model.fromMutableState(m -> {
            PublishArtifactSet ownArtifacts = configurationsProvider.findByName(name).getOutgoing().getArtifacts();
            ImmutableSet.Builder result = ImmutableSet.builderWithExpectedSize((int)ownArtifacts.size());
            for (PublishArtifact ownArtifact : ownArtifacts) {
                result.add((Object)new PublishArtifactLocalArtifactMetadata(componentId, ownArtifact));
            }
            for (String config : hierarchy) {
                if (config.equals(name)) continue;
                PublishArtifactSet inheritedArtifacts = configurationsProvider.findByName(config).getOutgoing().getArtifacts();
                for (PublishArtifact inheritedArtifact : inheritedArtifacts) {
                    result.add((Object)new PublishArtifactLocalArtifactMetadata(componentId, inheritedArtifact));
                }
            }
            return result.build().asList();
        }));
    }

    private static CalculatedValue<ImmutableList<LocalComponentArtifactMetadata>> getVariantArtifacts(DisplayName displayName, ComponentIdentifier componentId, Collection<? extends PublishArtifact> sourceArtifacts, ModelContainer<?> model, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        return calculatedValueContainerFactory.create(Describables.of((Object)displayName, (Object)"artifacts"), context -> {
            if (sourceArtifacts.isEmpty()) {
                return ImmutableList.of();
            }
            return (ImmutableList)model.fromMutableState(m -> {
                ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)sourceArtifacts.size());
                for (PublishArtifact sourceArtifact : sourceArtifacts) {
                    result.add((Object)new PublishArtifactLocalArtifactMetadata(componentId, sourceArtifact));
                }
                return result.build();
            });
        });
    }

    private CalculatedValue<DefaultLocalConfigurationMetadata.ConfigurationDependencyMetadata> getConfigurationDependencyState(String description, ImmutableSet<String> hierarchy, ImmutableAttributes attributes, ConfigurationsProvider configurationsProvider, LocalConfigurationMetadataBuilder.DependencyCache dependencyCache, ModelContainer<?> model, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        return calculatedValueContainerFactory.create(Describables.of((Object)"Dependency state for", (Object)description), context -> (DefaultLocalConfigurationMetadata.ConfigurationDependencyMetadata)model.fromMutableState(p -> {
            ImmutableList.Builder dependencies = ImmutableList.builder();
            ImmutableSet.Builder files = ImmutableSet.builder();
            ImmutableList.Builder excludes = ImmutableList.builder();
            configurationsProvider.visitAll(config -> {
                if (hierarchy.contains((Object)config.getName())) {
                    LocalConfigurationMetadataBuilder.DependencyState defined = this.getDefinedState((ConfigurationInternal)config, dependencyCache);
                    dependencies.addAll(defined.dependencies);
                    files.addAll(defined.files);
                    excludes.addAll(defined.excludes);
                }
            });
            LocalConfigurationMetadataBuilder.DependencyState state = new LocalConfigurationMetadataBuilder.DependencyState((ImmutableList<LocalOriginDependencyMetadata>)dependencies.build(), (ImmutableSet<LocalFileDependencyMetadata>)files.build(), (ImmutableList<ExcludeMetadata>)excludes.build());
            return new DefaultLocalConfigurationMetadata.ConfigurationDependencyMetadata((List<LocalOriginDependencyMetadata>)DefaultLocalConfigurationMetadataBuilder.maybeForceDependencies(state.dependencies, attributes), (Set<LocalFileDependencyMetadata>)state.files, (List<ExcludeMetadata>)state.excludes);
        }));
    }

    private LocalConfigurationMetadataBuilder.DependencyState getDefinedState(ConfigurationInternal configuration, LocalConfigurationMetadataBuilder.DependencyCache cache) {
        return cache.computeIfAbsent(configuration, this::doGetDefinedState);
    }

    private LocalConfigurationMetadataBuilder.DependencyState doGetDefinedState(ConfigurationInternal configuration) {
        ImmutableList.Builder dependencyBuilder = ImmutableList.builder();
        ImmutableSet.Builder fileBuilder = ImmutableSet.builder();
        ImmutableList.Builder excludeBuilder = ImmutableList.builder();
        for (Dependency dependency : configuration.getDependencies()) {
            if (dependency instanceof ModuleDependency) {
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                dependencyBuilder.add((Object)this.dependencyMetadataFactory.createDependencyMetadata(moduleDependency));
                continue;
            }
            if (dependency instanceof FileCollectionDependency) {
                FileCollectionDependency fileDependency = (FileCollectionDependency)dependency;
                fileBuilder.add((Object)new DefaultLocalFileDependencyMetadata(fileDependency));
                continue;
            }
            throw new IllegalArgumentException("Cannot convert dependency " + dependency + " to local component dependency metadata.");
        }
        for (DependencyConstraint dependencyConstraint : configuration.getDependencyConstraints()) {
            dependencyBuilder.add((Object)this.dependencyMetadataFactory.createDependencyConstraintMetadata(dependencyConstraint));
        }
        for (ExcludeRule excludeRule : configuration.getExcludeRules()) {
            excludeBuilder.add((Object)this.excludeRuleConverter.convertExcludeRule(excludeRule));
        }
        return new LocalConfigurationMetadataBuilder.DependencyState((ImmutableList<LocalOriginDependencyMetadata>)dependencyBuilder.build(), (ImmutableSet<LocalFileDependencyMetadata>)fileBuilder.build(), (ImmutableList<ExcludeMetadata>)excludeBuilder.build());
    }

    private static ImmutableList<LocalOriginDependencyMetadata> maybeForceDependencies(ImmutableList<LocalOriginDependencyMetadata> dependencies, ImmutableAttributes attributes) {
        AttributeValue attributeValue = attributes.findEntry(Category.CATEGORY_ATTRIBUTE);
        if (!attributeValue.isPresent() || !((Category)attributeValue.get()).getName().equals("enforced-platform")) {
            return dependencies;
        }
        ImmutableList.Builder forcedDependencies = ImmutableList.builder();
        for (LocalOriginDependencyMetadata rawDependency : dependencies) {
            forcedDependencies.add((Object)rawDependency.forced());
        }
        return forcedDependencies.build();
    }

    private static class DefaultLocalFileDependencyMetadata
    implements LocalFileDependencyMetadata {
        private final FileCollectionDependency fileDependency;

        DefaultLocalFileDependencyMetadata(FileCollectionDependency fileDependency) {
            this.fileDependency = fileDependency;
        }

        @Override
        public FileCollectionDependency getSource() {
            return this.fileDependency;
        }

        @Override
        @Nullable
        public ComponentIdentifier getComponentId() {
            return ((SelfResolvingDependencyInternal)this.fileDependency).getTargetComponentId();
        }

        @Override
        public FileCollectionInternal getFiles() {
            return (FileCollectionInternal)this.fileDependency.getFiles();
        }
    }

    private static class NestedVariantIdentifier
    implements VariantResolveMetadata.Identifier {
        private final VariantResolveMetadata.Identifier parent;
        private final String name;

        public NestedVariantIdentifier(VariantResolveMetadata.Identifier parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public int hashCode() {
            return this.parent.hashCode() ^ this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NestedVariantIdentifier other = (NestedVariantIdentifier)obj;
            return this.parent.equals(other.parent) && this.name.equals(other.name);
        }
    }
}

