/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import org.gradle.api.problems.internal.AdditionalDataBuilder;
import org.gradle.api.problems.internal.GeneralData;
import org.gradle.api.problems.internal.GeneralDataSpec;

public class DefaultGeneralData
implements GeneralData,
Serializable {
    private final Map<String, String> map;

    public DefaultGeneralData(Map<String, String> map) {
        this.map = ImmutableMap.copyOf(map);
    }

    @Override
    public Map<String, String> getAsMap() {
        return this.map;
    }

    public static AdditionalDataBuilder<GeneralData> builder() {
        return new DefaultGeneralDataBuilder();
    }

    public static AdditionalDataBuilder<GeneralData> builder(GeneralData from) {
        return new DefaultGeneralDataBuilder(from);
    }

    private static class DefaultGeneralDataBuilder
    implements GeneralDataSpec,
    AdditionalDataBuilder<GeneralData> {
        private final ImmutableMap.Builder<String, String> mapBuilder = ImmutableMap.builder();

        private DefaultGeneralDataBuilder() {
        }

        private DefaultGeneralDataBuilder(GeneralData from) {
            this.mapBuilder.putAll(from.getAsMap());
        }

        @Override
        public GeneralDataSpec put(String key, String value) {
            this.mapBuilder.put((Object)key, (Object)value);
            return this;
        }

        @Override
        public GeneralData build() {
            return new DefaultGeneralData((Map<String, String>)this.mapBuilder.build());
        }
    }
}

