/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import org.gradle.cache.CleanableStore;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.cache.internal.CleanupActionDecorator;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.RunnableBuildOperation;

public class BuildOperationCleanupActionDecorator
implements CleanupActionDecorator {
    private final BuildOperationRunner buildOperationExecutor;

    public BuildOperationCleanupActionDecorator(BuildOperationRunner buildOperationExecutor) {
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public CleanupAction decorate(CleanupAction action) {
        return new BuildOperationCacheCleanupDecorator(action, this.buildOperationExecutor);
    }

    private static class BuildOperationCacheCleanupDecorator
    implements CleanupAction {
        private final BuildOperationRunner buildOperationExecutor;
        private final CleanupAction delegate;

        public BuildOperationCacheCleanupDecorator(CleanupAction delegate, BuildOperationRunner buildOperationExecutor) {
            this.buildOperationExecutor = buildOperationExecutor;
            this.delegate = delegate;
        }

        @Override
        public void clean(final CleanableStore persistentCache, final CleanupProgressMonitor progressMonitor) {
            this.buildOperationExecutor.run(new RunnableBuildOperation(){

                public void run(BuildOperationContext context) {
                    delegate.clean(persistentCache, progressMonitor);
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)("Clean up " + persistentCache));
                }
            });
        }
    }
}

