/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.Serializable;
import org.gradle.api.internal.jvm.JavaVersionParser;
import org.gradle.jvm.toolchain.JavaLanguageVersion;

public class DefaultJavaLanguageVersion
implements JavaLanguageVersion,
Serializable {
    static final int LOWER_CACHED_VERSION = 4;
    static final int HIGHER_CACHED_VERSION = 19;
    static final JavaLanguageVersion[] KNOWN_VERSIONS = new JavaLanguageVersion[16];
    private final int version;

    public static JavaLanguageVersion of(int version) {
        if (version <= 0) {
            throw new IllegalArgumentException("JavaLanguageVersion must be a positive integer, not " + version);
        }
        if (version >= 4 && version <= 19) {
            return KNOWN_VERSIONS[version - 4];
        }
        return new DefaultJavaLanguageVersion(version);
    }

    public static JavaLanguageVersion fromFullVersion(String version) {
        return DefaultJavaLanguageVersion.of(JavaVersionParser.parseMajorVersion((String)version));
    }

    private DefaultJavaLanguageVersion(int version) {
        this.version = version;
    }

    @Override
    public int asInt() {
        return this.version;
    }

    @Override
    public String toString() {
        if (this.version < 5) {
            return String.format("1.%d", this.version);
        }
        return Integer.toString(this.version);
    }

    @Override
    public boolean canCompileOrRun(JavaLanguageVersion other) {
        return this.compareTo(other) >= 0;
    }

    @Override
    public int compareTo(JavaLanguageVersion other) {
        return Integer.compare(this.version, other.asInt());
    }

    @Override
    public boolean canCompileOrRun(int otherVersion) {
        return this.version >= otherVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultJavaLanguageVersion that = (DefaultJavaLanguageVersion)o;
        return this.version == that.version;
    }

    public int hashCode() {
        return this.version;
    }

    static {
        for (int version = 4; version <= 19; ++version) {
            DefaultJavaLanguageVersion.KNOWN_VERSIONS[version - 4] = new DefaultJavaLanguageVersion(version);
        }
    }
}

