/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.Closeable;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingAccessCoordinator;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetadata;
import org.gradle.api.internal.artifacts.ivyservice.CacheLayout;
import org.gradle.api.internal.cache.CacheConfigurationsInternal;
import org.gradle.api.provider.Provider;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.DefaultCacheCleanupStrategy;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.IndexedCache;
import org.gradle.cache.IndexedCacheParameters;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.UnscopedCacheBuilderFactory;
import org.gradle.cache.internal.CacheVersionMapping;
import org.gradle.cache.internal.CompositeCleanupAction;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.cache.internal.UnusedVersionsCacheCleanup;
import org.gradle.cache.internal.UsedGradleVersions;
import org.gradle.internal.Factory;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.time.TimestampSuppliers;

public class WritableArtifactCacheLockingAccessCoordinator
implements ArtifactCacheLockingAccessCoordinator,
Closeable {
    private final PersistentCache cache;

    public WritableArtifactCacheLockingAccessCoordinator(UnscopedCacheBuilderFactory unscopedCacheBuilderFactory, ArtifactCacheMetadata cacheMetaData, FileAccessTimeJournal fileAccessTimeJournal, UsedGradleVersions usedGradleVersions, CacheConfigurationsInternal cacheConfigurations) {
        this.cache = unscopedCacheBuilderFactory.cache(cacheMetaData.getCacheDir()).withDisplayName("artifact cache").withInitialLockMode(FileLockManager.LockMode.OnDemand).withCleanupStrategy(this.createCacheCleanupStrategy(cacheMetaData, fileAccessTimeJournal, usedGradleVersions, cacheConfigurations)).open();
    }

    private CacheCleanupStrategy createCacheCleanupStrategy(ArtifactCacheMetadata cacheMetaData, FileAccessTimeJournal fileAccessTimeJournal, UsedGradleVersions usedGradleVersions, CacheConfigurationsInternal cacheConfigurations) {
        return DefaultCacheCleanupStrategy.from((CleanupAction)this.createCleanupAction(cacheMetaData, fileAccessTimeJournal, usedGradleVersions, cacheConfigurations), () -> ((Provider)cacheConfigurations.getCleanupFrequency()).get());
    }

    private CleanupAction createCleanupAction(ArtifactCacheMetadata cacheMetaData, FileAccessTimeJournal fileAccessTimeJournal, UsedGradleVersions usedGradleVersions, CacheConfigurationsInternal cacheConfigurations) {
        return CompositeCleanupAction.builder().add(new CleanupAction[]{UnusedVersionsCacheCleanup.create((String)CacheLayout.MODULES.getName(), (CacheVersionMapping)CacheLayout.MODULES.getVersionMapping(), (UsedGradleVersions)usedGradleVersions)}).add(cacheMetaData.getExternalResourcesStoreDirectory(), new CleanupAction[]{UnusedVersionsCacheCleanup.create((String)CacheLayout.RESOURCES.getName(), (CacheVersionMapping)CacheLayout.RESOURCES.getVersionMapping(), (UsedGradleVersions)usedGradleVersions), new LeastRecentlyUsedCacheCleanup((FilesFinder)new SingleDepthFilesFinder(2), fileAccessTimeJournal, this.getMaxAgeTimestamp(cacheConfigurations))}).add(cacheMetaData.getFileStoreDirectory(), new CleanupAction[]{UnusedVersionsCacheCleanup.create((String)CacheLayout.FILE_STORE.getName(), (CacheVersionMapping)CacheLayout.FILE_STORE.getVersionMapping(), (UsedGradleVersions)usedGradleVersions), new LeastRecentlyUsedCacheCleanup((FilesFinder)new SingleDepthFilesFinder(4), fileAccessTimeJournal, this.getMaxAgeTimestamp(cacheConfigurations))}).add(cacheMetaData.getMetaDataStoreDirectory().getParentFile(), new CleanupAction[]{UnusedVersionsCacheCleanup.create((String)CacheLayout.META_DATA.getName(), (CacheVersionMapping)CacheLayout.META_DATA.getVersionMapping(), (UsedGradleVersions)usedGradleVersions)}).add(new CleanupAction[]{UnusedVersionsCacheCleanup.create((String)CacheLayout.TRANSFORMS.getName(), (CacheVersionMapping)CacheLayout.TRANSFORMS.getVersionMapping(), (UsedGradleVersions)usedGradleVersions)}).build();
    }

    private Supplier<Long> getMaxAgeTimestamp(CacheConfigurationsInternal cacheConfigurations) {
        Integer maxAgeProperty = Integer.getInteger("org.gradle.internal.cleanup.external.max.age");
        if (maxAgeProperty == null) {
            return cacheConfigurations.getDownloadedResources().getRemoveUnusedEntriesOlderThanAsSupplier();
        }
        return TimestampSuppliers.daysAgo((int)maxAgeProperty);
    }

    @Override
    public void close() {
        this.cache.close();
    }

    public <T> T withFileLock(Factory<? extends T> action) {
        return (T)this.cache.withFileLock(action);
    }

    public void withFileLock(Runnable action) {
        this.cache.withFileLock(action);
    }

    public <T> T useCache(Factory<? extends T> action) {
        return (T)this.cache.useCache(action);
    }

    public void useCache(Runnable action) {
        this.cache.useCache(action);
    }

    @Override
    public <K, V> IndexedCache<K, V> createCache(String cacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        String cacheFileInMetaDataStore = CacheLayout.META_DATA.getKey() + "/" + cacheName;
        IndexedCache indexedCache = this.cache.createIndexedCache(IndexedCacheParameters.of((String)cacheFileInMetaDataStore, keySerializer, valueSerializer));
        return new CacheLockingIndexedCache(indexedCache);
    }

    private class CacheLockingIndexedCache<K, V>
    implements IndexedCache<K, V> {
        private final IndexedCache<K, V> indexedCache;

        public CacheLockingIndexedCache(IndexedCache<K, V> indexedCache) {
            this.indexedCache = indexedCache;
        }

        @Nullable
        public V getIfPresent(K key) {
            return (V)WritableArtifactCacheLockingAccessCoordinator.this.cache.useCache(() -> this.indexedCache.getIfPresent(key));
        }

        public V get(K key, Function<? super K, ? extends V> producer) {
            return (V)WritableArtifactCacheLockingAccessCoordinator.this.cache.useCache(() -> this.indexedCache.get(key, producer));
        }

        public void put(K key, V value) {
            WritableArtifactCacheLockingAccessCoordinator.this.cache.useCache(() -> this.indexedCache.put(key, value));
        }

        public void remove(K key) {
            WritableArtifactCacheLockingAccessCoordinator.this.cache.useCache(() -> this.indexedCache.remove(key));
        }
    }
}

