/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.clientinput;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.function.Function;
import org.gradle.api.internal.tasks.userinput.UserInputReader;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.IoActions;
import org.gradle.internal.UncheckedException;
import org.gradle.launcher.daemon.protocol.ForwardInput;
import org.gradle.launcher.daemon.protocol.UserResponse;
import org.gradle.launcher.daemon.server.api.StdinHandler;

public class ClientInputForwarder {
    private static final Logger LOGGER = Logging.getLogger(ClientInputForwarder.class);
    private final UserInputReader inputReader;

    public ClientInputForwarder(UserInputReader inputReader) {
        this.inputReader = inputReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T forwardInput(Function<StdinHandler, T> action) {
        PipedInputStream replacementStdin;
        final PipedOutputStream inputSource = new PipedOutputStream();
        try {
            replacementStdin = new PipedInputStream(inputSource);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        this.inputReader.startInput();
        StdinHandler stdinHandler = new StdinHandler(){

            @Override
            public void onInput(ForwardInput input) {
                LOGGER.debug("Writing forwarded input on this process' stdin.");
                try {
                    inputSource.write(input.getBytes());
                }
                catch (IOException e) {
                    LOGGER.warn("Received exception trying to forward client input.", (Throwable)e);
                }
            }

            @Override
            public void onUserResponse(UserResponse input) {
                ClientInputForwarder.this.inputReader.putInput((UserInputReader.UserInput)new UserInputReader.TextResponse(input.getResponse()));
            }

            @Override
            public void onEndOfInput() {
                LOGGER.debug("Closing this process' stdin at end of input.");
                try {
                    inputSource.close();
                    ClientInputForwarder.this.inputReader.putInput(UserInputReader.END_OF_INPUT);
                }
                catch (IOException e) {
                    LOGGER.warn("Problem closing output stream connected to replacement stdin", (Throwable)e);
                }
                finally {
                    LOGGER.debug("This process will no longer process any forwarded input.");
                }
            }
        };
        InputStream previousStdin = System.in;
        try {
            System.setIn(replacementStdin);
            T t = action.apply(stdinHandler);
            return t;
        }
        finally {
            System.setIn(previousStdin);
            IoActions.closeQuietly(replacementStdin);
            IoActions.closeQuietly(inputSource);
        }
    }
}

