/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.google.common.base.Objects;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.io.ClassLoaderObjectInputStream;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.internal.snapshot.ValueSnapshottingException;

public class JavaSerializedValueSnapshot
implements ValueSnapshot {
    private final HashCode implementationHash;
    private final byte[] serializedValue;

    public JavaSerializedValueSnapshot(@Nullable HashCode implementationHash, byte[] serializedValue) {
        this.implementationHash = implementationHash;
        this.serializedValue = serializedValue;
    }

    @Nullable
    public HashCode getImplementationHash() {
        return this.implementationHash;
    }

    public byte[] getValue() {
        return this.serializedValue;
    }

    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        ValueSnapshot snapshot = snapshotter.snapshot(value);
        if (this.equals(snapshot)) {
            return this;
        }
        return snapshot;
    }

    public void appendToHasher(Hasher hasher) {
        if (this.implementationHash == null) {
            hasher.putNull();
        } else {
            hasher.putHash(this.implementationHash);
        }
        hasher.putBytes(this.serializedValue);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        JavaSerializedValueSnapshot other = (JavaSerializedValueSnapshot)obj;
        return Objects.equal((Object)this.implementationHash, (Object)other.implementationHash) && Arrays.equals(this.serializedValue, other.serializedValue);
    }

    protected Object populateClass(Class<?> originalClass) {
        return JavaSerializedValueSnapshot.javaDeserialized(originalClass, this.serializedValue);
    }

    private static Object javaDeserialized(Class<?> originalClass, byte[] serializedValue) {
        try {
            return new ClassLoaderObjectInputStream((InputStream)new ByteArrayInputStream(serializedValue), originalClass.getClassLoader()).readObject();
        }
        catch (Exception e) {
            throw new ValueSnapshottingException("Couldn't populate class " + originalClass.getName(), (Throwable)e);
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.serializedValue);
    }
}

