/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DefaultProblemProgressDetails;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.FileLocation;
import org.gradle.api.problems.internal.LineInFileLocation;
import org.gradle.api.problems.internal.OffsetInFileLocation;
import org.gradle.api.problems.internal.PluginIdLocation;
import org.gradle.api.problems.internal.Problem;
import org.gradle.api.problems.internal.ProblemLocation;
import org.gradle.api.problems.internal.TaskPathLocation;
import org.gradle.internal.Pair;
import org.gradle.internal.build.event.types.DefaultAdditionalData;
import org.gradle.internal.build.event.types.DefaultDetails;
import org.gradle.internal.build.event.types.DefaultDocumentationLink;
import org.gradle.internal.build.event.types.DefaultFailure;
import org.gradle.internal.build.event.types.DefaultFileLocation;
import org.gradle.internal.build.event.types.DefaultLabel;
import org.gradle.internal.build.event.types.DefaultLineInFileLocation;
import org.gradle.internal.build.event.types.DefaultOffsetInFileLocation;
import org.gradle.internal.build.event.types.DefaultPluginIdLocation;
import org.gradle.internal.build.event.types.DefaultProblemCategory;
import org.gradle.internal.build.event.types.DefaultProblemDescriptor;
import org.gradle.internal.build.event.types.DefaultProblemDetails;
import org.gradle.internal.build.event.types.DefaultProblemEvent;
import org.gradle.internal.build.event.types.DefaultSeverity;
import org.gradle.internal.build.event.types.DefaultSolution;
import org.gradle.internal.build.event.types.DefaultTaskPathLocation;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.tooling.internal.protocol.InternalFailure;
import org.gradle.tooling.internal.protocol.InternalProblemDetails;
import org.gradle.tooling.internal.protocol.InternalProblemEvent;
import org.gradle.tooling.internal.protocol.events.InternalProblemDescriptor;
import org.gradle.tooling.internal.protocol.problem.InternalAdditionalData;
import org.gradle.tooling.internal.protocol.problem.InternalDetails;
import org.gradle.tooling.internal.protocol.problem.InternalDocumentationLink;
import org.gradle.tooling.internal.protocol.problem.InternalLabel;
import org.gradle.tooling.internal.protocol.problem.InternalLocation;
import org.gradle.tooling.internal.protocol.problem.InternalProblemCategory;
import org.gradle.tooling.internal.protocol.problem.InternalSeverity;
import org.gradle.tooling.internal.protocol.problem.InternalSolution;
import org.gradle.tooling.internal.provider.runner.AggregatingProblemConsumer;
import org.gradle.tooling.internal.provider.runner.ClientForwardingBuildOperationListener;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;

@NonNullApi
public class ProblemsProgressEventConsumer
extends ClientForwardingBuildOperationListener {
    private static final InternalSeverity ADVICE = new DefaultSeverity(0);
    private static final InternalSeverity WARNING = new DefaultSeverity(1);
    private static final InternalSeverity ERROR = new DefaultSeverity(2);
    private final Supplier<OperationIdentifier> operationIdentifierSupplier;
    private final AggregatingProblemConsumer aggregator;

    ProblemsProgressEventConsumer(ProgressEventConsumer progressEventConsumer, Supplier<OperationIdentifier> operationIdentifierSupplier, AggregatingProblemConsumer aggregator) {
        super(progressEventConsumer);
        this.operationIdentifierSupplier = operationIdentifierSupplier;
        this.aggregator = aggregator;
    }

    @Override
    public void progress(OperationIdentifier buildOperationId, OperationProgressEvent progressEvent) {
        Object details = progressEvent.getDetails();
        this.createProblemEvent(buildOperationId, details).ifPresent(this.aggregator::emit);
    }

    private Optional<InternalProblemEvent> createProblemEvent(OperationIdentifier buildOperationId, @Nullable Object details) {
        if (details instanceof DefaultProblemProgressDetails) {
            Problem problem = ((DefaultProblemProgressDetails)details).getProblem();
            return Optional.of(this.createProblemEvent(buildOperationId, problem));
        }
        return Optional.empty();
    }

    private DefaultProblemEvent createProblemEvent(OperationIdentifier buildOperationId, Problem problem) {
        return new DefaultProblemEvent((InternalProblemDescriptor)this.cerateDefaultProblemDescriptor(buildOperationId), (InternalProblemDetails)new DefaultProblemDetails(ProblemsProgressEventConsumer.toInternalCategory(problem.getDefinition().getId()), ProblemsProgressEventConsumer.toInternalLabel(problem.getDefinition().getId().getDisplayName(), problem.getContextualLabel()), ProblemsProgressEventConsumer.toInternalDetails(problem.getDetails()), ProblemsProgressEventConsumer.toInternalSeverity(problem.getDefinition().getSeverity()), ProblemsProgressEventConsumer.toInternalLocations(problem.getLocations()), ProblemsProgressEventConsumer.toInternalDocumentationLink(problem.getDefinition().getDocumentationLink()), ProblemsProgressEventConsumer.toInternalSolutions(problem.getSolutions()), ProblemsProgressEventConsumer.toInternalAdditionalData(problem.getAdditionalData()), ProblemsProgressEventConsumer.toInternalFailure(problem.getException())));
    }

    @Nullable
    private static InternalFailure toInternalFailure(@Nullable RuntimeException ex) {
        if (ex == null) {
            return null;
        }
        return DefaultFailure.fromThrowable((Throwable)ex);
    }

    private DefaultProblemDescriptor cerateDefaultProblemDescriptor(OperationIdentifier parentBuildOperationId) {
        return new DefaultProblemDescriptor(this.operationIdentifierSupplier.get(), parentBuildOperationId);
    }

    private static InternalProblemCategory toInternalCategory(ProblemId problemId) {
        Pair<String, List<String>> categories = ProblemsProgressEventConsumer.categories(problemId);
        String rootCategory = (String)categories.getLeft();
        List subcategories = (List)categories.getRight();
        return new DefaultProblemCategory("", rootCategory, subcategories);
    }

    private static Pair<String, List<String>> categories(ProblemId problemId) {
        ArrayList<String> categories = new ArrayList<String>();
        categories.add(0, problemId.getName());
        for (ProblemGroup current = problemId.getGroup(); current != null; current = current.getParent()) {
            categories.add(0, current.getName());
        }
        Collections.reverse(categories);
        return Pair.of((Object)((String)categories.get(0)), new ArrayList(categories.subList(1, categories.size())));
    }

    private static InternalLabel toInternalLabel(String label, @Nullable String contextualLabel) {
        return new DefaultLabel(contextualLabel == null ? label : contextualLabel);
    }

    @Nullable
    private static InternalDetails toInternalDetails(@Nullable String details) {
        return details == null ? null : new DefaultDetails(details);
    }

    private static InternalSeverity toInternalSeverity(Severity severity) {
        switch (severity) {
            case ADVICE: {
                return ADVICE;
            }
            case WARNING: {
                return WARNING;
            }
            case ERROR: {
                return ERROR;
            }
        }
        throw new RuntimeException("No mapping defined for severity level " + severity);
    }

    private static List<InternalLocation> toInternalLocations(List<ProblemLocation> locations) {
        return (List)locations.stream().map(location -> {
            if (location instanceof LineInFileLocation) {
                LineInFileLocation fileLocation = (LineInFileLocation)location;
                return new DefaultLineInFileLocation(fileLocation.getPath(), fileLocation.getLine(), fileLocation.getColumn(), fileLocation.getLength());
            }
            if (location instanceof OffsetInFileLocation) {
                OffsetInFileLocation fileLocation = (OffsetInFileLocation)location;
                return new DefaultOffsetInFileLocation(fileLocation.getPath(), fileLocation.getOffset(), fileLocation.getLength());
            }
            if (location instanceof FileLocation) {
                FileLocation fileLocation = (FileLocation)location;
                return new DefaultFileLocation(fileLocation.getPath());
            }
            if (location instanceof PluginIdLocation) {
                PluginIdLocation pluginLocation = (PluginIdLocation)location;
                return new DefaultPluginIdLocation(pluginLocation.getPluginId());
            }
            if (location instanceof TaskPathLocation) {
                TaskPathLocation taskLocation = (TaskPathLocation)location;
                return new DefaultTaskPathLocation(taskLocation.getBuildTreePath());
            }
            throw new RuntimeException("No mapping defined for " + location.getClass().getName());
        }).collect(ImmutableList.toImmutableList());
    }

    @Nullable
    private static InternalDocumentationLink toInternalDocumentationLink(@Nullable DocLink link) {
        return link == null || link.getUrl() == null ? null : new DefaultDocumentationLink(link.getUrl());
    }

    private static List<InternalSolution> toInternalSolutions(List<String> solutions) {
        return (List)solutions.stream().map(DefaultSolution::new).collect(ImmutableList.toImmutableList());
    }

    private static InternalAdditionalData toInternalAdditionalData(Map<String, Object> additionalData) {
        return new DefaultAdditionalData(additionalData.entrySet().stream().filter(entry -> ProblemsProgressEventConsumer.isSupportedType(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private static boolean isSupportedType(Object type) {
        return type instanceof String;
    }
}

