/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.parsing;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.gradle.internal.declarativedsl.language.SourceData;
import org.gradle.internal.declarativedsl.language.SourceIdentifier;
import org.gradle.internal.declarativedsl.parsing.LightTreeUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0001 B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001f\u001a\u00020\u0005H\u0016R\u0014\u0010\u000b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\r\u00a8\u0006!"}, d2={"Lorg/gradle/internal/declarativedsl/parsing/LightTreeSourceData;", "Lorg/gradle/internal/declarativedsl/language/SourceData;", "sourceIdentifier", "Lorg/gradle/internal/declarativedsl/language/SourceIdentifier;", "sourceCode", "", "sourceOffset", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "(Lorg/gradle/internal/declarativedsl/language/SourceIdentifier;Ljava/lang/String;ILorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;)V", "endColumn", "getEndColumn", "()I", "indexRange", "Lkotlin/ranges/IntRange;", "getIndexRange", "()Lkotlin/ranges/IntRange;", "indexRange$delegate", "Lkotlin/Lazy;", "lineColumnInfo", "Lorg/gradle/internal/declarativedsl/parsing/LightTreeSourceData$LineColumnInfo;", "getLineColumnInfo", "()Lorg/gradle/internal/declarativedsl/parsing/LightTreeSourceData$LineColumnInfo;", "lineColumnInfo$delegate", "lineRange", "getLineRange", "getSourceIdentifier", "()Lorg/gradle/internal/declarativedsl/language/SourceIdentifier;", "startColumn", "getStartColumn", "text", "LineColumnInfo", "declarative-dsl-core"})
public final class LightTreeSourceData
implements SourceData {
    @NotNull
    private final SourceIdentifier sourceIdentifier;
    @NotNull
    private final String sourceCode;
    private final int sourceOffset;
    @NotNull
    private final LighterASTNode node;
    @NotNull
    private final Lazy indexRange$delegate;
    @NotNull
    private final Lazy lineColumnInfo$delegate;

    public LightTreeSourceData(@NotNull SourceIdentifier sourceIdentifier, @NotNull String sourceCode, int sourceOffset, @NotNull LighterASTNode node) {
        Intrinsics.checkNotNullParameter((Object)sourceIdentifier, (String)"sourceIdentifier");
        Intrinsics.checkNotNullParameter((Object)sourceCode, (String)"sourceCode");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.sourceIdentifier = sourceIdentifier;
        this.sourceCode = sourceCode;
        this.sourceOffset = sourceOffset;
        this.node = node;
        this.indexRange$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IntRange>(this){
            final /* synthetic */ LightTreeSourceData this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IntRange invoke() {
                IntRange originalRange = LightTreeUtilKt.range(LightTreeSourceData.access$getNode$p(this.this$0));
                int first = originalRange.getFirst() - LightTreeSourceData.access$getSourceOffset$p(this.this$0);
                int last = originalRange.getLast() - LightTreeSourceData.access$getSourceOffset$p(this.this$0);
                return new IntRange(first, last);
            }
        }));
        this.lineColumnInfo$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LineColumnInfo>(this){
            final /* synthetic */ LightTreeSourceData this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final LineColumnInfo invoke() {
                return LineColumnInfo.Factory.fromIndexRange(LightTreeSourceData.access$getSourceCode$p(this.this$0), LightTreeSourceData.access$getSourceOffset$p(this.this$0), this.this$0.getIndexRange());
            }
        }));
    }

    @Override
    @NotNull
    public SourceIdentifier getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    @Override
    @NotNull
    public IntRange getIndexRange() {
        Lazy lazy = this.indexRange$delegate;
        return (IntRange)lazy.getValue();
    }

    private final LineColumnInfo getLineColumnInfo() {
        Lazy lazy = this.lineColumnInfo$delegate;
        return (LineColumnInfo)lazy.getValue();
    }

    @Override
    @NotNull
    public IntRange getLineRange() {
        return new IntRange(this.getLineColumnInfo().getStartLine(), this.getLineColumnInfo().getEndLine());
    }

    @Override
    public int getStartColumn() {
        return this.getLineColumnInfo().getStartColumn();
    }

    @Override
    public int getEndColumn() {
        return this.getLineColumnInfo().getEndColumn();
    }

    @Override
    @NotNull
    public String text() {
        return LightTreeUtilKt.getAsText(this.node);
    }

    public static final /* synthetic */ LighterASTNode access$getNode$p(LightTreeSourceData $this) {
        return $this.node;
    }

    public static final /* synthetic */ int access$getSourceOffset$p(LightTreeSourceData $this) {
        return $this.sourceOffset;
    }

    public static final /* synthetic */ String access$getSourceCode$p(LightTreeSourceData $this) {
        return $this.sourceCode;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/gradle/internal/declarativedsl/parsing/LightTreeSourceData$LineColumnInfo;", "", "startLine", "", "startColumn", "endLine", "endColumn", "(IIII)V", "getEndColumn", "()I", "getEndLine", "getStartColumn", "getStartLine", "Factory", "declarative-dsl-core"})
    private static final class LineColumnInfo {
        @NotNull
        public static final Factory Factory = new Factory(null);
        private final int startLine;
        private final int startColumn;
        private final int endLine;
        private final int endColumn;

        public LineColumnInfo(int startLine, int startColumn, int endLine, int endColumn) {
            this.startLine = startLine;
            this.startColumn = startColumn;
            this.endLine = endLine;
            this.endColumn = endColumn;
        }

        public final int getStartLine() {
            return this.startLine;
        }

        public final int getStartColumn() {
            return this.startColumn;
        }

        public final int getEndLine() {
            return this.endLine;
        }

        public final int getEndColumn() {
            return this.endColumn;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/gradle/internal/declarativedsl/parsing/LightTreeSourceData$LineColumnInfo$Factory;", "", "()V", "fromIndexRange", "Lorg/gradle/internal/declarativedsl/parsing/LightTreeSourceData$LineColumnInfo;", "text", "", "offset", "", "offsetRelativeIndexRange", "Lkotlin/ranges/IntRange;", "declarative-dsl-core"})
        public static final class Factory {
            private Factory() {
            }

            @NotNull
            public final LineColumnInfo fromIndexRange(@NotNull String text, int offset, @NotNull IntRange offsetRelativeIndexRange) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)offsetRelativeIndexRange, (String)"offsetRelativeIndexRange");
                if (!org.gradle.internal.declarativedsl.parsing.LightTreeSourceData$LineColumnInfo$Factory.fromIndexRange$isValidIndex(text, offset)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                int realStartIndex = offset + offsetRelativeIndexRange.getFirst();
                if (!org.gradle.internal.declarativedsl.parsing.LightTreeSourceData$LineColumnInfo$Factory.fromIndexRange$isValidIndex(text, realStartIndex)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                int realEndIndex = offset + offsetRelativeIndexRange.getLast();
                if (!org.gradle.internal.declarativedsl.parsing.LightTreeSourceData$LineColumnInfo$Factory.fromIndexRange$isValidIndex(text, realEndIndex)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                if (!(realStartIndex <= realEndIndex)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                int startLine = -1;
                int startColumn = -1;
                int endLine = -1;
                int endColumn = -1;
                int i = offset;
                int line = 1;
                int column = 1;
                while (i < text.length()) {
                    if (i == realStartIndex) {
                        startLine = line;
                        startColumn = column;
                    }
                    if (i == realEndIndex) {
                        endLine = line;
                        endColumn = column;
                        break;
                    }
                    int newLineLength = org.gradle.internal.declarativedsl.parsing.LightTreeSourceData$LineColumnInfo$Factory.fromIndexRange$newLineLength(text, i);
                    if (newLineLength > 0) {
                        i += newLineLength;
                        ++line;
                        column = 1;
                        continue;
                    }
                    ++i;
                    ++column;
                }
                if (!(startLine >= 0 && startColumn >= 0 && endLine >= 0 && endColumn >= 0)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                return new LineColumnInfo(startLine, startColumn, endLine, endColumn);
            }

            private static final int fromIndexRange$newLineLength(String $this$fromIndexRange_u24newLineLength, int index) {
                char c = $this$fromIndexRange_u24newLineLength.charAt(index);
                return c == '\n' ? 1 : (c == '\r' ? (index + 1 < $this$fromIndexRange_u24newLineLength.length() && $this$fromIndexRange_u24newLineLength.charAt(index + 1) == '\n' ? 2 : 1) : 0);
            }

            private static final boolean fromIndexRange$isValidIndex(String $this$fromIndexRange_u24isValidIndex, int index) {
                return 0 <= index ? index < $this$fromIndexRange_u24isValidIndex.length() : false;
            }

            public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

