/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.evaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.declarativedsl.analysis.AnalysisStatementFilter;
import org.gradle.internal.declarativedsl.analysis.DefaultCodeResolverKt;
import org.gradle.internal.declarativedsl.analysis.ObjectOrigin;
import org.gradle.internal.declarativedsl.analysis.ResolutionResult;
import org.gradle.internal.declarativedsl.analysis.ResolverImpl;
import org.gradle.internal.declarativedsl.analysis.SchemaTypeRefContext;
import org.gradle.internal.declarativedsl.analysis.TypeRefContext;
import org.gradle.internal.declarativedsl.evaluationSchema.EvaluationSchema;
import org.gradle.internal.declarativedsl.evaluationSchema.InterpretationSequence;
import org.gradle.internal.declarativedsl.evaluationSchema.InterpretationSequenceStep;
import org.gradle.internal.declarativedsl.evaluator.DeclarativeKotlinScriptEvaluator;
import org.gradle.internal.declarativedsl.evaluator.DefaultDeclarativeKotlinScriptEvaluator;
import org.gradle.internal.declarativedsl.evaluator.InterpretationSchemaBuilder;
import org.gradle.internal.declarativedsl.evaluator.InterpretationSchemaBuildingResult;
import org.gradle.internal.declarativedsl.evaluator.RestrictedScriptContext;
import org.gradle.internal.declarativedsl.language.LanguageTreeResult;
import org.gradle.internal.declarativedsl.language.SourceIdentifier;
import org.gradle.internal.declarativedsl.mappingToJvm.CompositeCustomAccessors;
import org.gradle.internal.declarativedsl.mappingToJvm.CompositeFunctionResolver;
import org.gradle.internal.declarativedsl.mappingToJvm.CompositePropertyResolver;
import org.gradle.internal.declarativedsl.mappingToJvm.DeclarativeReflectionToObjectConverter;
import org.gradle.internal.declarativedsl.mappingToJvm.RuntimeCustomAccessors;
import org.gradle.internal.declarativedsl.mappingToJvm.RuntimeFunctionResolver;
import org.gradle.internal.declarativedsl.mappingToJvm.RuntimePropertyResolver;
import org.gradle.internal.declarativedsl.objectGraph.AssignmentTrace;
import org.gradle.internal.declarativedsl.objectGraph.AssignmentTraceElement;
import org.gradle.internal.declarativedsl.objectGraph.AssignmentTracer;
import org.gradle.internal.declarativedsl.objectGraph.ObjectReflection;
import org.gradle.internal.declarativedsl.objectGraph.ReflectObjectKt;
import org.gradle.internal.declarativedsl.objectGraph.ReflectionContext;
import org.gradle.internal.declarativedsl.parsing.DefaultLanguageTreeBuilder;
import org.gradle.internal.declarativedsl.parsing.ParserKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J(\u0010\u001a\u001a\u00020\f\"\b\b\u0000\u0010\u001b*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001dH\u0002J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/gradle/internal/declarativedsl/evaluator/DefaultDeclarativeKotlinScriptEvaluator;", "Lorg/gradle/internal/declarativedsl/evaluator/DeclarativeKotlinScriptEvaluator;", "schemaBuilder", "Lorg/gradle/internal/declarativedsl/evaluator/InterpretationSchemaBuilder;", "(Lorg/gradle/internal/declarativedsl/evaluator/InterpretationSchemaBuilder;)V", "languageTreeBuilder", "Lorg/gradle/internal/declarativedsl/parsing/DefaultLanguageTreeBuilder;", "assignmentTrace", "Lorg/gradle/internal/declarativedsl/objectGraph/AssignmentTrace;", "result", "Lorg/gradle/internal/declarativedsl/analysis/ResolutionResult;", "evaluate", "Lorg/gradle/internal/declarativedsl/evaluator/DeclarativeKotlinScriptEvaluator$EvaluationResult;", "target", "", "scriptSource", "Lorg/gradle/groovy/scripts/ScriptSource;", "evaluationContext", "Lorg/gradle/internal/declarativedsl/evaluator/DeclarativeKotlinScriptEvaluator$EvaluationContext;", "languageModelFromLightParser", "Lorg/gradle/internal/declarativedsl/language/LanguageTreeResult;", "requirePluginContext", "Lorg/gradle/internal/declarativedsl/evaluator/DeclarativeKotlinScriptEvaluator$EvaluationContext$ScriptPluginEvaluationContext;", "runInterpretationSequence", "sequence", "Lorg/gradle/internal/declarativedsl/evaluationSchema/InterpretationSequence;", "runInterpretationSequenceStep", "R", "step", "Lorg/gradle/internal/declarativedsl/evaluationSchema/InterpretationSequenceStep;", "scriptContextFor", "Lorg/gradle/internal/declarativedsl/evaluator/RestrictedScriptContext;", "declarative-dsl-provider"})
@SourceDebugExtension(value={"SMAP\nDeclarativeKotlinScriptEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarativeKotlinScriptEvaluator.kt\norg/gradle/internal/declarativedsl/evaluator/DefaultDeclarativeKotlinScriptEvaluator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1855#2,2:184\n800#2,11:186\n1#3:197\n*S KotlinDebug\n*F\n+ 1 DeclarativeKotlinScriptEvaluator.kt\norg/gradle/internal/declarativedsl/evaluator/DefaultDeclarativeKotlinScriptEvaluator\n*L\n99#1:184,2\n130#1:186,11\n*E\n"})
public final class DefaultDeclarativeKotlinScriptEvaluator
implements DeclarativeKotlinScriptEvaluator {
    @NotNull
    private final InterpretationSchemaBuilder schemaBuilder;
    @NotNull
    private final DefaultLanguageTreeBuilder languageTreeBuilder;

    public DefaultDeclarativeKotlinScriptEvaluator(@NotNull InterpretationSchemaBuilder schemaBuilder) {
        Intrinsics.checkNotNullParameter((Object)schemaBuilder, (String)"schemaBuilder");
        this.schemaBuilder = schemaBuilder;
        this.languageTreeBuilder = new DefaultLanguageTreeBuilder();
    }

    @Override
    @NotNull
    public DeclarativeKotlinScriptEvaluator.EvaluationResult evaluate(@NotNull Object target, @NotNull ScriptSource scriptSource, @NotNull DeclarativeKotlinScriptEvaluator.EvaluationContext evaluationContext) {
        DeclarativeKotlinScriptEvaluator.EvaluationResult evaluationResult;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)scriptSource, (String)"scriptSource");
        Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
        InterpretationSchemaBuildingResult built = this.schemaBuilder.getEvaluationSchemaForScript(target, this.scriptContextFor(target, scriptSource, evaluationContext));
        if (Intrinsics.areEqual((Object)built, (Object)InterpretationSchemaBuildingResult.SchemaNotBuilt.INSTANCE)) {
            evaluationResult = new DeclarativeKotlinScriptEvaluator.EvaluationResult.NotEvaluated(CollectionsKt.listOf((Object)new DeclarativeKotlinScriptEvaluator.EvaluationResult.NotEvaluated.StageFailure.NoSchemaAvailable(target)));
        } else if (built instanceof InterpretationSchemaBuildingResult.InterpretationSequenceAvailable) {
            evaluationResult = this.runInterpretationSequence(scriptSource, ((InterpretationSchemaBuildingResult.InterpretationSequenceAvailable)built).getSequence());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return evaluationResult;
    }

    private final DeclarativeKotlinScriptEvaluator.EvaluationResult runInterpretationSequence(ScriptSource scriptSource, InterpretationSequence sequence) {
        Iterable<InterpretationSequenceStep<?>> $this$forEach$iv = sequence.getSteps();
        boolean $i$f$forEach = false;
        Iterator<InterpretationSequenceStep<?>> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            InterpretationSequenceStep<?> element$iv;
            InterpretationSequenceStep<?> step = element$iv = iterator.next();
            boolean bl = false;
            DeclarativeKotlinScriptEvaluator.EvaluationResult result = this.runInterpretationSequenceStep(scriptSource, step);
            if (!(result instanceof DeclarativeKotlinScriptEvaluator.EvaluationResult.NotEvaluated)) continue;
            return result;
        }
        return DeclarativeKotlinScriptEvaluator.EvaluationResult.Evaluated.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final <R> DeclarativeKotlinScriptEvaluator.EvaluationResult runInterpretationSequenceStep(ScriptSource scriptSource, InterpretationSequenceStep<R> step) {
        void $this$filterIsInstanceTo$iv$iv;
        ResolutionResult resolution;
        List failureReasons = new ArrayList();
        EvaluationSchema evaluationSchema = step.evaluationSchemaForStep();
        ResolverImpl resolver = DefaultCodeResolverKt.defaultCodeResolver((AnalysisStatementFilter)evaluationSchema.getAnalysisStatementFilter());
        LanguageTreeResult languageModel = this.languageModelFromLightParser(scriptSource);
        if (!((Collection)languageModel.getAllFailures()).isEmpty()) {
            ((Collection)failureReasons).add(new DeclarativeKotlinScriptEvaluator.EvaluationResult.NotEvaluated.StageFailure.FailuresInLanguageTree(languageModel.getAllFailures()));
        }
        if (!((Collection)(resolution = resolver.resolve(evaluationSchema.getAnalysisSchema(), languageModel.getImports(), languageModel.getTopLevelBlock())).getErrors()).isEmpty()) {
            ((Collection)failureReasons).add(new DeclarativeKotlinScriptEvaluator.EvaluationResult.NotEvaluated.StageFailure.FailuresInResolution(resolution.getErrors()));
        }
        AssignmentTrace trace = this.assignmentTrace(resolution);
        Iterable $this$filterIsInstance$iv = trace.getElements();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AssignmentTraceElement.UnassignedValueUsed)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unassignedValueUsages = (List)destination$iv$iv;
        if (!((Collection)unassignedValueUsages).isEmpty()) {
            ((Collection)failureReasons).add(new DeclarativeKotlinScriptEvaluator.EvaluationResult.NotEvaluated.StageFailure.UnassignedValuesUsed(unassignedValueUsages));
        }
        if (!((Collection)failureReasons).isEmpty()) {
            return new DeclarativeKotlinScriptEvaluator.EvaluationResult.NotEvaluated(failureReasons);
        }
        ReflectionContext context = new ReflectionContext((TypeRefContext)new SchemaTypeRefContext(evaluationSchema.getAnalysisSchema()), resolution, trace);
        ObjectReflection topLevelObjectReflection = ReflectObjectKt.reflect((ObjectOrigin)((ObjectOrigin)resolution.getTopLevelReceiver()), (ReflectionContext)context);
        CompositePropertyResolver propertyResolver = new CompositePropertyResolver(evaluationSchema.getRuntimePropertyResolvers());
        CompositeFunctionResolver functionResolver = new CompositeFunctionResolver(evaluationSchema.getRuntimeFunctionResolvers());
        CompositeCustomAccessors customAccessors = new CompositeCustomAccessors(evaluationSchema.getRuntimeCustomAccessors());
        R topLevelReceiver = step.topLevelReceiver();
        DeclarativeReflectionToObjectConverter converter = new DeclarativeReflectionToObjectConverter(MapsKt.emptyMap(), topLevelReceiver, (RuntimeFunctionResolver)functionResolver, (RuntimePropertyResolver)propertyResolver, (RuntimeCustomAccessors)customAccessors);
        DeclarativeReflectionToObjectConverter.apply$default((DeclarativeReflectionToObjectConverter)converter, (ObjectReflection)topLevelObjectReflection, null, (int)2, null);
        step.whenEvaluated(topLevelReceiver);
        return DeclarativeKotlinScriptEvaluator.EvaluationResult.Evaluated.INSTANCE;
    }

    private final AssignmentTrace assignmentTrace(ResolutionResult result) {
        return new AssignmentTracer((Function0)assignmentTrace.1.INSTANCE).produceAssignmentTrace(result);
    }

    private final LanguageTreeResult languageModelFromLightParser(ScriptSource scriptSource) {
        String string = scriptSource.getResource().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scriptSource.resource.text");
        Triple triple = ParserKt.parse((String)string);
        FlyweightCapableTreeStructure tree = (FlyweightCapableTreeStructure)triple.component1();
        String code = (String)triple.component2();
        int codeOffset = ((Number)triple.component3()).intValue();
        String string2 = scriptSource.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"scriptSource.fileName");
        return this.languageTreeBuilder.build(tree, code, codeOffset, new SourceIdentifier(string2));
    }

    private final RestrictedScriptContext scriptContextFor(Object target, ScriptSource scriptSource, DeclarativeKotlinScriptEvaluator.EvaluationContext evaluationContext) {
        Object object = target;
        return object instanceof Settings ? (RestrictedScriptContext)new RestrictedScriptContext.SettingsScript(this.requirePluginContext(evaluationContext).getTargetScope(), scriptSource) : (object instanceof Project ? (RestrictedScriptContext)new RestrictedScriptContext.ProjectScript(this.requirePluginContext(evaluationContext).getTargetScope(), scriptSource) : (RestrictedScriptContext)RestrictedScriptContext.UnknownScript.INSTANCE);
    }

    private final DeclarativeKotlinScriptEvaluator.EvaluationContext.ScriptPluginEvaluationContext requirePluginContext(DeclarativeKotlinScriptEvaluator.EvaluationContext evaluationContext) {
        if (!(evaluationContext instanceof DeclarativeKotlinScriptEvaluator.EvaluationContext.ScriptPluginEvaluationContext)) {
            boolean bl = false;
            String string = "this target is not supported outside script plugins";
            throw new IllegalArgumentException(string.toString());
        }
        return (DeclarativeKotlinScriptEvaluator.EvaluationContext.ScriptPluginEvaluationContext)evaluationContext;
    }
}

