/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.ExternalComponentResolveMetadata;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.AbstractComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveState;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleConfigurationMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantArtifactGraphResolveMetadata;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.resolve.resolver.VariantArtifactResolver;

public class DefaultComponentGraphResolveState<T extends ComponentGraphResolveMetadata, S extends ExternalComponentResolveMetadata>
extends AbstractComponentGraphResolveState<T, S> {
    private final ComponentIdGenerator idGenerator;
    private final ConcurrentMap<ModuleConfigurationMetadata, DefaultConfigurationGraphResolveState> variants = new ConcurrentHashMap<ModuleConfigurationMetadata, DefaultConfigurationGraphResolveState>();
    private final Lazy<Optional<List<? extends VariantGraphResolveState>>> allVariantsForGraphResolution = Lazy.locking().of(() -> graphMetadata.getVariantsForGraphTraversal().map(variants -> variants.stream().map(ModuleConfigurationMetadata.class::cast).map(variant -> this.resolveStateFor((ModuleConfigurationMetadata)variant).asVariant()).collect(Collectors.toList())));
    private final List<ResolvedVariantResult> selectableVariantResults;

    public DefaultComponentGraphResolveState(long instanceId, T graphMetadata, S artifactMetadata, AttributeDesugaring attributeDesugaring, ComponentIdGenerator idGenerator) {
        super(instanceId, graphMetadata, artifactMetadata, attributeDesugaring);
        this.idGenerator = idGenerator;
        this.selectableVariantResults = graphMetadata.getVariantsForGraphTraversal().orElse(Collections.emptyList()).stream().flatMap(variant -> variant.getVariants().stream()).map(variant -> new DefaultResolvedVariantResult(this.getId(), Describables.of((Object)variant.getName()), (AttributeContainer)attributeDesugaring.desugar(variant.getAttributes().asImmutable()), this.capabilitiesFor(variant.getCapabilities()), null)).collect(Collectors.toList());
    }

    @Override
    public ComponentArtifactResolveMetadata getResolveMetadata() {
        return new ExternalArtifactResolveMetadata((ExternalComponentResolveMetadata)this.getArtifactMetadata());
    }

    @Override
    public ModuleSources getSources() {
        return ((ExternalComponentResolveMetadata)this.getArtifactMetadata()).getSources();
    }

    @Override
    public List<ResolvedVariantResult> getAllSelectableVariantResults() {
        return this.selectableVariantResults;
    }

    @Override
    protected Optional<List<? extends VariantGraphResolveState>> getVariantsForGraphTraversal() {
        return (Optional)this.allVariantsForGraphResolution.get();
    }

    @Override
    @Nullable
    public ConfigurationGraphResolveState getConfiguration(String configurationName) {
        ModuleConfigurationMetadata configuration = (ModuleConfigurationMetadata)this.getMetadata().getConfiguration(configurationName);
        if (configuration == null) {
            return null;
        }
        return this.resolveStateFor(configuration);
    }

    private DefaultConfigurationGraphResolveState resolveStateFor(ModuleConfigurationMetadata configuration) {
        return this.variants.computeIfAbsent(configuration, c -> this.newVariantState(configuration));
    }

    protected VariantGraphResolveState newResolveStateFor(ModuleConfigurationMetadata configuration) {
        return this.newVariantState(configuration);
    }

    private DefaultConfigurationGraphResolveState newVariantState(ModuleConfigurationMetadata configuration) {
        return new DefaultConfigurationGraphResolveState(this.idGenerator.nextVariantId(), this, (ExternalComponentResolveMetadata)this.getArtifactMetadata(), configuration);
    }

    private static class ExternalArtifactResolveMetadata
    implements ComponentArtifactResolveMetadata {
        private final ExternalComponentResolveMetadata metadata;

        public ExternalArtifactResolveMetadata(ExternalComponentResolveMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public ComponentIdentifier getId() {
            return this.metadata.getId();
        }

        @Override
        public ModuleVersionIdentifier getModuleVersionId() {
            return this.metadata.getModuleVersionId();
        }

        @Override
        public ModuleSources getSources() {
            return this.metadata.getSources();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.metadata.getAttributes();
        }

        @Override
        public AttributesSchemaInternal getAttributesSchema() {
            return this.metadata.getAttributesSchema();
        }

        @Override
        public ComponentResolveMetadata getMetadata() {
            return this.metadata;
        }
    }

    private static class DefaultConfigurationArtifactResolveState
    implements VariantArtifactResolveState {
        private final ExternalComponentResolveMetadata artifactMetadata;
        private final ConfigurationMetadata graphSelectedConfiguration;
        private final Set<? extends VariantResolveMetadata> variants;

        public DefaultConfigurationArtifactResolveState(ExternalComponentResolveMetadata artifactMetadata, ConfigurationMetadata graphSelectedConfiguration) {
            this.artifactMetadata = artifactMetadata;
            this.graphSelectedConfiguration = graphSelectedConfiguration;
            this.variants = graphSelectedConfiguration.getVariants();
        }

        @Override
        public ResolvedVariant resolveAdhocVariant(VariantArtifactResolver variantResolver, List<IvyArtifactName> dependencyArtifacts) {
            ImmutableList.Builder artifacts = ImmutableList.builderWithExpectedSize((int)dependencyArtifacts.size());
            for (IvyArtifactName dependencyArtifact : dependencyArtifacts) {
                artifacts.add((Object)this.graphSelectedConfiguration.artifact(dependencyArtifact));
            }
            return variantResolver.resolveAdhocVariant(new ExternalArtifactResolveMetadata(this.artifactMetadata), (ImmutableList<? extends ComponentArtifactMetadata>)artifacts.build());
        }

        @Override
        public Set<? extends VariantResolveMetadata> getArtifactVariants() {
            return this.variants;
        }
    }

    private static class DefaultConfigurationGraphResolveState
    extends AbstractComponentGraphResolveState.AbstractVariantGraphResolveState
    implements VariantGraphResolveState,
    ConfigurationGraphResolveState {
        private final long instanceId;
        private final ModuleConfigurationMetadata configuration;
        private final Lazy<DefaultConfigurationArtifactResolveState> artifactResolveState;

        public DefaultConfigurationGraphResolveState(long instanceId, AbstractComponentGraphResolveState<?, ?> componentState, ExternalComponentResolveMetadata component, ModuleConfigurationMetadata configuration) {
            super(componentState);
            this.instanceId = instanceId;
            this.configuration = configuration;
            this.artifactResolveState = Lazy.locking().of(() -> new DefaultConfigurationArtifactResolveState(component, configuration));
        }

        @Override
        public long getInstanceId() {
            return this.instanceId;
        }

        @Override
        public String getName() {
            return this.configuration.getName();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.configuration.getAttributes();
        }

        @Override
        public ImmutableCapabilities getCapabilities() {
            return this.configuration.getCapabilities();
        }

        @Override
        public ConfigurationGraphResolveMetadata getMetadata() {
            return this.configuration;
        }

        @Override
        public VariantGraphResolveState asVariant() {
            return this;
        }

        @Override
        public VariantArtifactGraphResolveMetadata resolveArtifacts() {
            return this.configuration;
        }

        @Override
        public VariantArtifactResolveState prepareForArtifactResolution() {
            return (VariantArtifactResolveState)this.artifactResolveState.get();
        }
    }
}

