/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.ExactVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ResolvableSelectorState;
import org.gradle.internal.component.model.IvyArtifactName;

public class ModuleSelectors<T extends ResolvableSelectorState>
implements Iterable<T> {
    private final Version emptyVersion;
    private final VersionParser versionParser;
    private final List<T> selectors = new ArrayList<T>();
    private boolean deferSelection;
    private boolean forced;
    private final Comparator<ResolvableSelectorState> selectorComparator;

    public ModuleSelectors(Comparator<Version> versionComparator, VersionParser versionParser) {
        this.versionParser = versionParser;
        this.emptyVersion = versionParser.transform("");
        this.selectorComparator = new SelectorComparator(versionComparator);
    }

    public boolean checkDeferSelection() {
        if (this.deferSelection) {
            this.deferSelection = false;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return this.selectors.iterator();
    }

    public void add(T selector, boolean deferSelection) {
        this.deferSelection = deferSelection;
        if (this.selectors.isEmpty() || this.forced) {
            this.selectors.add(selector);
        } else {
            this.doAdd(selector);
        }
        this.forced = this.forced || selector.isForce();
    }

    private void doAdd(T selector) {
        int size = this.selectors.size();
        if (size == 1) {
            this.doAddWhenListHasOneElement(selector);
        } else {
            this.doAddWhenListHasManyElements(this.selectors, selector, size);
        }
    }

    private <T extends ResolvableSelectorState> void doAddWhenListHasManyElements(List<T> selectors, T selector, int size) {
        int insertionPoint = Collections.binarySearch(selectors, selector, this.selectorComparator);
        if ((insertionPoint = this.advanceToPreserveOrder(selectors, selector, size, insertionPoint)) < 0) {
            insertionPoint ^= 0xFFFFFFFF;
        }
        selectors.add(insertionPoint, selector);
    }

    private <T extends ResolvableSelectorState> int advanceToPreserveOrder(List<T> selectors, T selector, int size, int insertionPoint) {
        while (insertionPoint > 0 && insertionPoint < size && this.selectorComparator.compare((ResolvableSelectorState)selectors.get(insertionPoint), selector) == 0) {
            ++insertionPoint;
        }
        return insertionPoint;
    }

    private void doAddWhenListHasOneElement(T selector) {
        ResolvableSelectorState first = (ResolvableSelectorState)this.selectors.get(0);
        int c = this.selectorComparator.compare(first, (ResolvableSelectorState)selector);
        if (c <= 0) {
            this.selectors.add(selector);
        } else {
            this.selectors.add(0, selector);
        }
    }

    public boolean remove(T selector) {
        return this.selectors.remove(selector);
    }

    private static boolean isDynamicSelector(ResolvableSelectorState selector) {
        return selector.getVersionConstraint() != null && selector.getVersionConstraint().isDynamic();
    }

    private static boolean hasLatestSelector(ResolvableSelectorState selector) {
        return selector.getVersionConstraint() != null && ModuleSelectors.hasLatestSelector(selector.getVersionConstraint());
    }

    private static boolean hasLatestSelector(ResolvedVersionConstraint vc) {
        return ModuleSelectors.hasLatestSelector(vc.getRequiredSelector());
    }

    private static boolean hasLatestSelector(@Nullable VersionSelector versionSelector) {
        return versionSelector instanceof LatestVersionSelector;
    }

    private Version requiredVersion(ResolvableSelectorState selector) {
        ResolvedVersionConstraint versionConstraint = selector.getVersionConstraint();
        if (versionConstraint == null) {
            return this.emptyVersion;
        }
        return this.versionOf(versionConstraint.getRequiredSelector());
    }

    private Version preferredVersion(ResolvableSelectorState selector) {
        ResolvedVersionConstraint versionConstraint = selector.getVersionConstraint();
        if (versionConstraint == null) {
            return this.emptyVersion;
        }
        return this.versionOf(versionConstraint.getPreferredSelector());
    }

    private Version versionOf(@Nullable VersionSelector selector) {
        if (!(selector instanceof ExactVersionSelector)) {
            return this.emptyVersion;
        }
        return this.versionParser.transform(selector.getSelector());
    }

    public int size() {
        return this.selectors.size();
    }

    @Nullable
    public T first() {
        if (this.size() == 0) {
            return null;
        }
        return (T)((ResolvableSelectorState)this.selectors.get(0));
    }

    @Nullable
    public IvyArtifactName getFirstDependencyArtifact() {
        for (ResolvableSelectorState selector : this.selectors) {
            IvyArtifactName artifact = selector.getFirstDependencyArtifact();
            if (artifact == null) continue;
            return artifact;
        }
        return null;
    }

    private class SelectorComparator
    implements Comparator<ResolvableSelectorState> {
        private final Comparator<Version> versionComparator;

        private SelectorComparator(Comparator<Version> versionComparator) {
            this.versionComparator = versionComparator;
        }

        @Override
        public int compare(ResolvableSelectorState left, ResolvableSelectorState right) {
            if (right.isProject() == left.isProject()) {
                if (right.isFromLock() == left.isFromLock()) {
                    if (ModuleSelectors.hasLatestSelector(right) == ModuleSelectors.hasLatestSelector(left)) {
                        if (ModuleSelectors.isDynamicSelector(right) == ModuleSelectors.isDynamicSelector(left)) {
                            Version o2RequiredVersion;
                            Version o1RequiredVersion = ModuleSelectors.this.requiredVersion(right);
                            int compareRequiredVersion = this.versionComparator.compare(o1RequiredVersion, o2RequiredVersion = ModuleSelectors.this.requiredVersion(left));
                            if (compareRequiredVersion == 0) {
                                Version o1Version = ModuleSelectors.this.preferredVersion(right);
                                Version o2Version = ModuleSelectors.this.preferredVersion(left);
                                return this.versionComparator.compare(o1Version, o2Version);
                            }
                            return compareRequiredVersion;
                        }
                        return Boolean.compare(ModuleSelectors.isDynamicSelector(left), ModuleSelectors.isDynamicSelector(right));
                    }
                    return Boolean.compare(ModuleSelectors.hasLatestSelector(right), ModuleSelectors.hasLatestSelector(left));
                }
                return Boolean.compare(right.isFromLock(), left.isFromLock());
            }
            return Boolean.compare(right.isProject(), left.isProject());
        }
    }
}

