/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import com.google.common.annotations.VisibleForTesting;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.UUID;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.tasks.userinput.UserInputReader;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.Actions;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.agents.AgentInitializer;
import org.gradle.internal.agents.AgentStatus;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.internal.logging.console.GlobalUserInputReceiver;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.BasicGlobalScopeServices;
import org.gradle.internal.service.scopes.GlobalScopeServices;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.launcher.bootstrap.ExecutionListener;
import org.gradle.launcher.cli.BuildEnvironmentConfigurationConverter;
import org.gradle.launcher.cli.CommandLineActionCreator;
import org.gradle.launcher.cli.InProcessUserInputHandlingExecutor;
import org.gradle.launcher.cli.Parameters;
import org.gradle.launcher.cli.ReportDaemonStatusAction;
import org.gradle.launcher.cli.RunBuildAction;
import org.gradle.launcher.cli.StopDaemonAction;
import org.gradle.launcher.configuration.AllProperties;
import org.gradle.launcher.daemon.bootstrap.ForegroundDaemonAction;
import org.gradle.launcher.daemon.client.DaemonClient;
import org.gradle.launcher.daemon.client.DaemonClientFactory;
import org.gradle.launcher.daemon.client.DaemonClientGlobalServices;
import org.gradle.launcher.daemon.client.DaemonStopClient;
import org.gradle.launcher.daemon.client.ReportDaemonStatusClient;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.configuration.ForegroundDaemonConfiguration;
import org.gradle.launcher.daemon.context.DaemonCompatibilitySpec;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.context.DaemonRequestContext;
import org.gradle.launcher.daemon.context.DefaultDaemonContext;
import org.gradle.launcher.daemon.toolchain.DaemonJvmCriteria;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildExecuter;
import org.gradle.launcher.exec.DefaultBuildActionParameters;
import org.gradle.process.internal.CurrentProcess;

class BuildActionsFactory
implements CommandLineActionCreator {
    private final BuildEnvironmentConfigurationConverter buildEnvironmentConfigurationConverter;
    private final ServiceRegistry loggingServices;
    private final JvmVersionDetector jvmVersionDetector;
    private final FileCollectionFactory fileCollectionFactory;
    private final ServiceRegistry basicServices;

    public BuildActionsFactory(ServiceRegistry loggingServices) {
        this.basicServices = ServiceRegistryBuilder.builder().scope(Scope.Global.class).displayName("Basic global services").parent(loggingServices).parent((ServiceRegistry)NativeServices.getInstance()).provider(new BasicGlobalScopeServices()).build();
        this.loggingServices = loggingServices;
        this.fileCollectionFactory = this.basicServices.get(FileCollectionFactory.class);
        this.buildEnvironmentConfigurationConverter = new BuildEnvironmentConfigurationConverter(new BuildLayoutFactory(), this.fileCollectionFactory);
        this.jvmVersionDetector = this.basicServices.get(JvmVersionDetector.class);
    }

    @Override
    public void configureCommandLineParser(CommandLineParser parser) {
        this.buildEnvironmentConfigurationConverter.configure(parser);
    }

    @Override
    public Action<? super ExecutionListener> createAction(CommandLineParser parser, ParsedCommandLine commandLine) {
        Parameters parameters = this.buildEnvironmentConfigurationConverter.convertParameters(commandLine, null);
        StartParameterInternal startParameter = parameters.getStartParameter();
        DaemonParameters daemonParameters = parameters.getDaemonParameters();
        AllProperties allProperties = parameters.getProperties();
        if (daemonParameters.isStop()) {
            return Actions.toAction(this.stopAllDaemons(daemonParameters));
        }
        if (daemonParameters.isStatus()) {
            return Actions.toAction(this.showDaemonStatus(daemonParameters));
        }
        if (daemonParameters.isForeground()) {
            ForegroundDaemonConfiguration conf = new ForegroundDaemonConfiguration(UUID.randomUUID().toString(), daemonParameters.getBaseDir(), daemonParameters.getIdleTimeout(), daemonParameters.getPeriodicCheckInterval(), this.fileCollectionFactory, daemonParameters.shouldApplyInstrumentationAgent(), daemonParameters.getNativeServicesMode());
            return Actions.toAction(new ForegroundDaemonAction(this.loggingServices, conf));
        }
        DaemonRequestContext requestContext = this.configureForRequestContext(daemonParameters);
        if (daemonParameters.isEnabled()) {
            return Actions.toAction(this.runBuildWithDaemon(startParameter, daemonParameters, requestContext));
        }
        if (this.canUseCurrentProcess(daemonParameters, requestContext)) {
            return Actions.toAction(this.runBuildInProcess(startParameter, daemonParameters));
        }
        return Actions.toAction(this.runBuildInSingleUseDaemon(startParameter, daemonParameters, requestContext));
    }

    private DaemonRequestContext configureForRequestContext(DaemonParameters daemonParameters) {
        if (daemonParameters.getRequestedJvmCriteria() != null) {
            DaemonJvmCriteria criteria = daemonParameters.getRequestedJvmCriteria();
            daemonParameters.applyDefaultsFor(criteria.getJavaVersion());
            return new DaemonRequestContext(daemonParameters.getRequestedJvmBasedOnJavaHome(), daemonParameters.getRequestedJvmCriteria(), daemonParameters.getEffectiveJvmArgs(), daemonParameters.shouldApplyInstrumentationAgent(), daemonParameters.getNativeServicesMode(), daemonParameters.getPriority());
        }
        if (daemonParameters.getRequestedJvmBasedOnJavaHome() != null && daemonParameters.getRequestedJvmBasedOnJavaHome() != Jvm.current()) {
            JavaLanguageVersion detectedVersion = JavaLanguageVersion.of((int)this.jvmVersionDetector.getJavaVersionMajor(daemonParameters.getRequestedJvmBasedOnJavaHome()));
            daemonParameters.applyDefaultsFor(detectedVersion);
            return new DaemonRequestContext(daemonParameters.getRequestedJvmBasedOnJavaHome(), daemonParameters.getRequestedJvmCriteria(), daemonParameters.getEffectiveJvmArgs(), daemonParameters.shouldApplyInstrumentationAgent(), daemonParameters.getNativeServicesMode(), daemonParameters.getPriority());
        }
        daemonParameters.applyDefaultsFor(JavaLanguageVersion.current());
        return new DaemonRequestContext(Jvm.current(), daemonParameters.getRequestedJvmCriteria(), daemonParameters.getEffectiveJvmArgs(), daemonParameters.shouldApplyInstrumentationAgent(), daemonParameters.getNativeServicesMode(), daemonParameters.getPriority());
    }

    private Runnable stopAllDaemons(DaemonParameters daemonParameters) {
        ServiceRegistry clientSharedServices = this.createGlobalClientServices(false);
        ServiceRegistry clientServices = clientSharedServices.get(DaemonClientFactory.class).createMessageDaemonServices(this.loggingServices, daemonParameters);
        DaemonStopClient stopClient = clientServices.get(DaemonStopClient.class);
        return new StopDaemonAction(stopClient);
    }

    private Runnable showDaemonStatus(DaemonParameters daemonParameters) {
        ServiceRegistry clientSharedServices = this.createGlobalClientServices(false);
        ServiceRegistry clientServices = clientSharedServices.get(DaemonClientFactory.class).createMessageDaemonServices(this.loggingServices, daemonParameters);
        ReportDaemonStatusClient statusClient = clientServices.get(ReportDaemonStatusClient.class);
        return new ReportDaemonStatusAction(statusClient);
    }

    private Runnable runBuildWithDaemon(StartParameterInternal startParameter, DaemonParameters daemonParameters, DaemonRequestContext requestContext) {
        ServiceRegistry clientSharedServices = this.createGlobalClientServices(true);
        ServiceRegistry clientServices = clientSharedServices.get(DaemonClientFactory.class).createBuildClientServices(this.loggingServices, daemonParameters, requestContext, System.in);
        DaemonClient client = clientServices.get(DaemonClient.class);
        return this.runBuildAndCloseServices(startParameter, daemonParameters, client, clientSharedServices, clientServices);
    }

    protected boolean canUseCurrentProcess(DaemonParameters daemonParameters, DaemonRequestContext requestContext) {
        CurrentProcess currentProcess = new CurrentProcess(this.fileCollectionFactory);
        DaemonContext contextForCurrentProcess = BuildActionsFactory.buildDaemonContextForCurrentProcess(requestContext, currentProcess);
        DaemonCompatibilitySpec comparison = new DaemonCompatibilitySpec(requestContext);
        if (!currentProcess.isLowMemoryProcess() && comparison.isSatisfiedBy(contextForCurrentProcess)) {
            if (daemonParameters.hasUserDefinedImmutableJvmArgs()) {
                return currentProcess.getJvmOptions().getAllImmutableJvmArgs().equals(daemonParameters.getEffectiveSingleUseJvmArgs());
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static DaemonContext buildDaemonContextForCurrentProcess(DaemonRequestContext requestContext, CurrentProcess currentProcess) {
        return new DefaultDaemonContext(UUID.randomUUID().toString(), currentProcess.getJvm().getJavaHome(), JavaLanguageVersion.current(), null, 0L, 0, requestContext.getDaemonOpts(), AgentStatus.allowed().isAgentInstrumentationEnabled(), requestContext.getNativeServicesMode(), requestContext.getPriority());
    }

    private Runnable runBuildInProcess(StartParameterInternal startParameter, DaemonParameters daemonParameters) {
        Properties properties = new Properties();
        properties.putAll(daemonParameters.getEffectiveSystemProperties());
        System.setProperties(properties);
        ServiceRegistry globalServices = ServiceRegistryBuilder.builder().scope(Scope.Global.class).displayName("Global services").parent(this.loggingServices).parent((ServiceRegistry)NativeServices.getInstance()).provider(new GlobalScopeServices(startParameter.isContinuous(), AgentStatus.of((boolean)daemonParameters.shouldApplyInstrumentationAgent()))).build();
        globalServices.get(AgentInitializer.class).maybeConfigureInstrumentationAgent();
        InProcessUserInputHandlingExecutor executer = new InProcessUserInputHandlingExecutor(globalServices.get(GlobalUserInputReceiver.class), globalServices.get(UserInputReader.class), globalServices.get(BuildExecuter.class));
        return this.runBuildAndCloseServices(startParameter, daemonParameters, executer, globalServices, globalServices.get(GradleUserHomeScopeServiceRegistry.class));
    }

    private Runnable runBuildInSingleUseDaemon(StartParameterInternal startParameter, DaemonParameters daemonParameters, DaemonRequestContext requestContext) {
        int maxTimeout = 120000;
        if (daemonParameters.getIdleTimeout() > maxTimeout) {
            daemonParameters.setIdleTimeout(maxTimeout);
        }
        ServiceRegistry clientSharedServices = this.createGlobalClientServices(true);
        ServiceRegistry clientServices = clientSharedServices.get(DaemonClientFactory.class).createSingleUseDaemonClientServices(clientSharedServices, daemonParameters, requestContext, System.in);
        DaemonClient client = clientServices.get(DaemonClient.class);
        return this.runBuildAndCloseServices(startParameter, daemonParameters, client, clientSharedServices, clientServices);
    }

    private ServiceRegistry createGlobalClientServices(boolean usingDaemon) {
        ServiceRegistryBuilder builder = ServiceRegistryBuilder.builder().displayName("Daemon client global services").parent((ServiceRegistry)NativeServices.getInstance());
        if (usingDaemon) {
            builder.parent(this.basicServices);
        } else {
            builder.provider(new GlobalScopeServices(false, AgentStatus.disabled()));
        }
        return builder.provider(new DaemonClientGlobalServices()).build();
    }

    private Runnable runBuildAndCloseServices(StartParameterInternal startParameter, DaemonParameters daemonParameters, BuildActionExecuter<BuildActionParameters, BuildRequestContext> executer, ServiceRegistry sharedServices, Object ... stopBeforeSharedServices) {
        BuildActionParameters parameters = this.createBuildActionParameters((StartParameter)startParameter, daemonParameters);
        CompositeStoppable stoppable = new CompositeStoppable().add(stopBeforeSharedServices).add((Object)sharedServices);
        return new RunBuildAction(executer, startParameter, (BuildClientMetaData)this.clientMetaData(), this.getBuildStartTime(), parameters, sharedServices, stoppable);
    }

    private BuildActionParameters createBuildActionParameters(StartParameter startParameter, DaemonParameters daemonParameters) {
        return new DefaultBuildActionParameters(daemonParameters.getEffectiveSystemProperties(), daemonParameters.getEnvironmentVariables(), SystemProperties.getInstance().getCurrentDir(), startParameter.getLogLevel(), daemonParameters.isEnabled(), ClassPath.EMPTY);
    }

    private long getBuildStartTime() {
        return ManagementFactory.getRuntimeMXBean().getStartTime();
    }

    private GradleLauncherMetaData clientMetaData() {
        return new GradleLauncherMetaData();
    }
}

