/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.validation;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.internal.InternalProblemBuilder;
import org.gradle.api.problems.internal.Problem;
import org.gradle.internal.reflect.validation.DefaultPluginId;
import org.gradle.internal.reflect.validation.DelegatingProblemBuilder;
import org.gradle.internal.reflect.validation.TypeAwareProblemBuilder;

@NonNullApi
public class DefaultTypeAwareProblemBuilder
extends DelegatingProblemBuilder
implements TypeAwareProblemBuilder {
    public static final String TYPE_NAME = "typeName";
    public static final String PLUGIN_ID = "pluginId";
    public static final String PARENT_PROPERTY_NAME = "parentPropertyName";
    public static final String PROPERTY_NAME = "propertyName";
    public static final String TYPE_IS_IRRELEVANT_IN_ERROR_MESSAGE = "typeIsIrrelevantInErrorMessage";
    private String parentPropertyAdditionalData = null;

    public DefaultTypeAwareProblemBuilder(InternalProblemBuilder problemBuilder) {
        super(problemBuilder);
    }

    @Override
    public TypeAwareProblemBuilder withAnnotationType(@Nullable Class<?> classWithAnnotationAttached) {
        if (classWithAnnotationAttached != null) {
            this.additionalData(TYPE_NAME, classWithAnnotationAttached.getName().replaceAll("\\$", "."));
        }
        return this;
    }

    @Override
    public TypeAwareProblemBuilder typeIsIrrelevantInErrorMessage() {
        this.additionalData(TYPE_IS_IRRELEVANT_IN_ERROR_MESSAGE, Boolean.TRUE.toString());
        return this;
    }

    @Override
    public TypeAwareProblemBuilder forProperty(String propertyName) {
        this.additionalData(PROPERTY_NAME, propertyName);
        return this;
    }

    @Override
    public TypeAwareProblemBuilder parentProperty(@Nullable String parentProperty) {
        if (parentProperty == null) {
            return this;
        }
        String pp = this.getParentProperty(parentProperty);
        this.additionalData(PARENT_PROPERTY_NAME, pp);
        this.parentPropertyAdditionalData = pp;
        return this;
    }

    @Override
    public Problem build() {
        Problem problem = super.build();
        String prefix = DefaultTypeAwareProblemBuilder.introductionFor(problem.getAdditionalData());
        String text = Optional.ofNullable(problem.getContextualLabel()).orElseGet(() -> problem.getDefinition().getId().getDisplayName());
        return problem.toBuilder().contextualLabel(prefix + text).build();
    }

    public static String introductionFor(Map<String, Object> additionalMetadata) {
        Object property;
        boolean typeRelevant;
        Optional<String> rootType = Optional.ofNullable(additionalMetadata.get(TYPE_NAME)).map(Object::toString).filter(DefaultTypeAwareProblemBuilder::shouldRenderType);
        Optional<DefaultPluginId> pluginId = Optional.ofNullable(additionalMetadata.get(PLUGIN_ID)).map(Object::toString).map(DefaultPluginId::new);
        StringBuilder builder = new StringBuilder();
        boolean bl = typeRelevant = rootType.isPresent() && !Boolean.parseBoolean(additionalMetadata.getOrDefault(TYPE_IS_IRRELEVANT_IN_ERROR_MESSAGE, "").toString());
        if (typeRelevant) {
            if (pluginId.isPresent()) {
                builder.append("In plugin '").append(pluginId.get()).append("' type '");
            } else {
                builder.append("Type '");
            }
            builder.append(rootType.get()).append("' ");
        }
        if ((property = additionalMetadata.get(PROPERTY_NAME)) != null) {
            if (typeRelevant) {
                builder.append("property '");
            } else if (pluginId.isPresent()) {
                builder.append("In plugin '").append(pluginId.get()).append("' property '");
            } else {
                builder.append("Property '");
            }
            Optional.ofNullable(additionalMetadata.get(PARENT_PROPERTY_NAME)).ifPresent(parentProperty -> {
                builder.append(parentProperty);
                builder.append('.');
            });
            builder.append(property).append("' ");
        }
        return builder.toString();
    }

    private static boolean shouldRenderType(String className) {
        return !"org.gradle.api.DefaultTask".equals(className);
    }

    private String getParentProperty(String parentProperty) {
        String existingParentProperty = this.parentPropertyAdditionalData;
        if (existingParentProperty == null) {
            return parentProperty;
        }
        return existingParentProperty + "." + parentProperty;
    }
}

