/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import org.gradle.internal.Cast;

public class Types {
    private static final Collection<Class<?>> OBJECT_TYPE = ImmutableList.of(Object.class);

    public static <T> void walkTypeHierarchy(Class<T> clazz, TypeVisitor<? extends T> visitor) {
        Types.walkTypeHierarchy(clazz, OBJECT_TYPE, visitor);
    }

    public static <T> void walkTypeHierarchy(Class<T> clazz, Collection<Class<?>> excludedTypes, TypeVisitor<? extends T> visitor) {
        Class type;
        HashSet seenInterfaces = new HashSet();
        ArrayDeque<Class> queue = new ArrayDeque<Class>();
        queue.add(clazz);
        while ((type = (Class)queue.poll()) != null) {
            if (excludedTypes.contains(type)) continue;
            TypeVisitResult result = visitor.visitType(type);
            switch (result) {
                case CONTINUE: {
                    break;
                }
                case TERMINATE: {
                    return;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected result: " + (Object)((Object)result)));
                }
            }
            Class superclass = type.getSuperclass();
            if (superclass != null) {
                queue.add(superclass);
            }
            for (Class<?> iface : type.getInterfaces()) {
                if (!seenInterfaces.add(iface)) continue;
                queue.add((Class)Cast.uncheckedCast(iface));
            }
        }
    }

    public static enum TypeVisitResult {
        CONTINUE,
        TERMINATE;

    }

    @FunctionalInterface
    public static interface TypeVisitor<T> {
        public TypeVisitResult visitType(Class<? super T> var1);
    }
}

