/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom.output;

import java.util.ArrayList;
import java.util.EmptyStackException;
import org.jetbrains.kotlin.org.jdom.Namespace;

class NamespaceStack {
    private final ArrayList<String> prefixes = new ArrayList();
    private final ArrayList<String> uris = new ArrayList();

    NamespaceStack() {
    }

    public void push(Namespace ns) {
        this.prefixes.add(ns.getPrefix());
        this.uris.add(ns.getURI());
    }

    public String pop() {
        int lastIndex = this.prefixes.size() - 1;
        if (lastIndex < 0) {
            throw new EmptyStackException();
        }
        String prefix = this.prefixes.remove(lastIndex);
        this.uris.remove(lastIndex);
        return prefix;
    }

    public int size() {
        return this.prefixes.size();
    }

    public String getURI(String prefix) {
        int index = this.prefixes.lastIndexOf(prefix);
        if (index == -1) {
            return null;
        }
        return this.uris.get(index);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Stack: ").append(this.prefixes.size()).append('\n');
        for (int i = 0; i < this.prefixes.size(); ++i) {
            buf.append(this.prefixes.get(i)).append("&").append(this.uris.get(i)).append('\n');
        }
        return buf.toString();
    }
}

