/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import org.gradle.internal.UncheckedException;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginManager;
import org.gradle.internal.invocation.BuildAction;

public class BuildCompletionNotifyingBuildActionRunner
implements BuildActionRunner {
    private final BuildActionRunner delegate;
    private final GradleEnterprisePluginManager gradleEnterprisePluginManager;

    public BuildCompletionNotifyingBuildActionRunner(BuildActionRunner delegate, GradleEnterprisePluginManager gradleEnterprisePluginManager) {
        this.delegate = delegate;
        this.gradleEnterprisePluginManager = gradleEnterprisePluginManager;
    }

    public BuildActionRunner.Result run(BuildAction action, BuildTreeLifecycleController buildController) {
        BuildActionRunner.Result result;
        try {
            result = this.delegate.run(action, buildController);
        }
        catch (Throwable t) {
            this.notifyEnterprisePluginManager(BuildActionRunner.Result.failed((Throwable)t));
            throw UncheckedException.throwAsUncheckedException((Throwable)t);
        }
        this.notifyEnterprisePluginManager(result);
        return result;
    }

    private void notifyEnterprisePluginManager(BuildActionRunner.Result result) {
        this.gradleEnterprisePluginManager.buildFinished(result.getBuildFailure());
    }
}

